/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.Msg;

public class FontChooser
extends JPanel {
    protected static final JLabel DEFAULT_FONT = new JLabel();
    protected JDialog dialog;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    protected Font font;
    private static final int MIN_FONT_SIZE = 5;
    private static final int MAX_FONT_SIZE = 72;
    private static final int RENDERED_FONT_SIZE = 16;
    protected JComboBox name = new JComboBox();
    protected JCheckBox bold = new JCheckBox(Msg.BOLD.toString());
    protected JCheckBox italic = new JCheckBox(Msg.ITALIC.toString());
    protected JComboBox size = new JComboBox();
    protected boolean suppressEvents;
    private static final long serialVersionUID = 3978992071925250097L;

    public FontChooser() {
        ItemListener changer = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                FontChooser.this.fireStateChange();
            }
        };
        this.font = DEFAULT_FONT.getFont();
        this.name.setModel(new CustomComboBoxModel());
        this.name.setRenderer(new CustomListCellRenderer());
        this.name.setSelectedItem(this.font.deriveFont(0, 16.0f));
        this.name.addItemListener(changer);
        for (int i = 5; i <= 72; ++i) {
            this.size.addItem(new Integer(i));
        }
        this.size.setSelectedItem(new Integer(16));
        this.size.addItemListener(changer);
        this.bold.setSelected(this.font.isBold());
        this.bold.addItemListener(changer);
        this.italic.setSelected(this.font.isItalic());
        this.italic.addItemListener(changer);
        this.setLayout(new GridLayout(2, 2));
        this.add(this.name);
        this.add(this.size);
        this.add(this.bold);
        this.add(this.italic);
    }

    public static Font showDialog(Component parent, String title, Font initial) {
        JPanel buttons = new JPanel();
        JButton ok = new JButton(Msg.OK.toString());
        JButton cancel = new JButton(Msg.CANCEL.toString());
        Component root = SwingUtilities.getRoot(parent);
        final FontChooser fontc = new FontChooser();
        fontc.dialog = new JDialog((JFrame)root, title, true);
        fontc.name.setSelectedItem(initial);
        buttons.setLayout(new FlowLayout());
        buttons.add(ok);
        buttons.add(cancel);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ex) {
                fontc.dialog.setVisible(false);
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ex) {
                fontc.dialog.setVisible(false);
                fontc.font = null;
            }
        });
        fontc.setBorder(BorderFactory.createTitledBorder(Msg.SELECT_FONT.toString()));
        fontc.dialog.getRootPane().setDefaultButton(ok);
        fontc.dialog.getContentPane().setLayout(new BorderLayout());
        fontc.dialog.getContentPane().add((Component)fontc, "North");
        fontc.dialog.getContentPane().add((Component)buttons, "South");
        fontc.dialog.setSize(800, 500);
        fontc.dialog.pack();
        GuiUtil.centerWindow(fontc.dialog);
        fontc.dialog.setVisible(true);
        fontc.dialog.dispose();
        return fontc.font;
    }

    public void setStyle(Font newFont) {
        this.suppressEvents = true;
        if (newFont == null) {
            return;
        }
        CustomComboBoxModel model = (CustomComboBoxModel)this.name.getModel();
        model.setSelectedItem(newFont.deriveFont(0, 16.0f));
        this.bold.setSelected(newFont.isBold());
        this.italic.setSelected(newFont.isItalic());
        this.size.setSelectedItem(new Integer(newFont.getSize()));
        this.suppressEvents = false;
        this.fireStateChange();
    }

    public Font getStyle() {
        Font selected = (Font)this.name.getSelectedItem();
        if (selected == null) {
            return DEFAULT_FONT.getFont();
        }
        int font_style = (this.bold.isSelected() ? 1 : 0) | (this.italic.isSelected() ? 2 : 0);
        int font_size = (Integer)this.size.getSelectedItem();
        return selected.deriveFont(font_style, font_size);
    }

    public void addPropertyChangeListener(PropertyChangeListener li) {
        this.listeners.addPropertyChangeListener(li);
    }

    public void removePropertyChangeListener(PropertyChangeListener li) {
        this.listeners.removePropertyChangeListener(li);
    }

    protected void fireStateChange() {
        Font old = this.font;
        this.font = this.getStyle();
        if (!this.suppressEvents) {
            this.listeners.firePropertyChange("style", old, this.font);
        }
    }

    static class CustomListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 3256726195025358905L;

        CustomListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean selected, boolean focus) {
            if (value == null) {
                this.setText("<null>");
                this.setFont(DEFAULT_FONT.getFont());
            } else {
                Font afont = (Font)value;
                this.setText(afont.getFamily());
                this.setFont(afont);
            }
            return this;
        }
    }

    static class CustomComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Font[] fonts;
        private Object selection;
        private static final long serialVersionUID = 3258129150505071664L;

        protected CustomComboBoxModel() {
            String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            this.fonts = new Font[names.length];
            for (int i = 0; i < this.fonts.length; ++i) {
                this.fonts[i] = new Font(names[i], 0, 16);
            }
        }

        public void setSelectedItem(Object selection) {
            this.selection = selection;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selection;
        }

        public int getSize() {
            return this.fonts.length;
        }

        public Object getElementAt(int index) {
            return this.fonts[index];
        }
    }
}

