/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.MultipleChoice;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.config.swing.Msg;
import org.crosswire.common.util.Logger;

public class OptionsField
implements Field {
    private JComboBox combo = new JComboBox<String>(new String[]{Msg.NO_OPTIONS.toString()});
    private String[] list;
    private static final Logger log = Logger.getLogger((Class)OptionsField.class);

    public void setChoice(Choice param) {
        if (param instanceof MultipleChoice) {
            MultipleChoice mc = (MultipleChoice)param;
            this.list = mc.getOptions();
            if (this.list == null) {
                throw new IllegalArgumentException("getOptions() returns null for option with help text " + mc.getHelpText());
            }
        } else {
            log.warn("Unknown Choice type: " + param.getClass().getName());
            this.list = new String[]{Msg.ERROR.toString()};
        }
        this.combo.setModel(new DefaultComboBoxModel<String>(this.list));
    }

    public String getValue() {
        String reply = (String)this.combo.getSelectedItem();
        if (reply == null) {
            reply = "";
        }
        return reply;
    }

    public void setValue(String value) {
        if (this.list != null && this.list.length > 0) {
            for (int i = 0; i < this.list.length; ++i) {
                if (!value.equals(this.list[i])) continue;
                this.combo.setSelectedItem(this.list[i]);
                return;
            }
            this.combo.setSelectedItem(this.list[0]);
        }
        log.warn("Checked for options without finding: '" + value + "'. Defaulting to first option: " + this.combo.getSelectedItem());
    }

    public JComponent getComponent() {
        return this.combo;
    }
}

