/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.crosswire.common.util.FileUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.basic.AbstractBookDriver;
import org.crosswire.jsword.book.sword.BookType;
import org.crosswire.jsword.book.sword.ConfigEntry;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordBookPath;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexManagerFactory;
import org.crosswire.jsword.index.IndexStatus;

public class SwordBookDriver
extends AbstractBookDriver {
    private static final BookDriver INSTANCE = new SwordBookDriver();
    private static final Logger log = Logger.getLogger((Class)SwordBookDriver.class);

    public String getDriverName() {
        return "Sword";
    }

    public Book[] getBooks() {
        ConfigEntry.resetStatistics();
        ArrayList valid = new ArrayList();
        File[] dirs = SwordBookPath.getSwordPath();
        for (int j = 0; j < dirs.length; ++j) {
            this.getBooks(valid, dirs[j]);
        }
        ConfigEntry.dumpStatistics();
        return valid.toArray(new Book[valid.size()]);
    }

    private void getBooks(List valid, File bookDir) {
        File mods = new File(bookDir, "mods.d");
        if (mods.isDirectory()) {
            String[] bookConfs = SwordBookPath.getBookList(mods);
            for (int i = 0; i < bookConfs.length; ++i) {
                String bookConf = bookConfs[i];
                try {
                    File configfile = new File(mods, bookConf);
                    String internal = bookConf;
                    if (internal.endsWith(".conf")) {
                        internal = internal.substring(0, internal.length() - 5);
                    }
                    SwordBookMetaData sbmd = new SwordBookMetaData(configfile, internal, NetUtil.getURL((File)bookDir));
                    sbmd.setDriver(this);
                    Book book = this.createBook(sbmd);
                    if (valid.contains(book)) continue;
                    valid.add(book);
                    IndexManager imanager = IndexManagerFactory.getIndexManager();
                    if (imanager.isIndexed(book)) {
                        sbmd.setIndexStatus(IndexStatus.DONE);
                        continue;
                    }
                    sbmd.setIndexStatus(IndexStatus.UNDONE);
                    continue;
                }
                catch (IOException e) {
                    log.warn("Couldn't create SwordBookMetaData", (Throwable)e);
                    continue;
                }
                catch (BookException e) {
                    log.warn("Couldn't create SwordBookMetaData", (Throwable)((Object)e));
                }
            }
        } else {
            log.debug("mods.d directory at " + mods + " does not exist");
        }
    }

    public boolean isDeletable(Book dead) {
        SwordBookMetaData sbmd = (SwordBookMetaData)dead.getBookMetaData();
        File dlDir = SwordBookPath.getDownloadDir();
        File confFile = new File(dlDir, sbmd.getConfPath());
        return confFile.exists();
    }

    public void delete(Book dead) throws BookException {
        URL loc;
        SwordBookMetaData sbmd = (SwordBookMetaData)dead.getBookMetaData();
        File dlDir = SwordBookPath.getDownloadDir();
        File confFile = new File(dlDir, sbmd.getConfPath());
        if (!confFile.exists()) {
            throw new BookException((MsgBase)Msg.DELETE_FAILED, new Object[]{confFile});
        }
        List failures = FileUtil.delete((File)confFile);
        if (failures.size() == 0 && (loc = sbmd.getLocation()) != null) {
            File bookDir = new File(loc.getFile());
            failures = FileUtil.delete((File)bookDir);
            Books.installed().removeBook(dead);
        }
        if (failures.size() > 0) {
            throw new BookException((MsgBase)Msg.DELETE_FAILED, new Object[]{failures.get(0)});
        }
    }

    public static BookDriver instance() {
        return INSTANCE;
    }

    public static void registerNewBook(SwordBookMetaData sbmd) throws BookException {
        BookDriver[] drivers = Books.installed().getDriversByClass(SwordBookDriver.class);
        for (int i = 0; i < drivers.length; ++i) {
            SwordBookDriver sdriver = (SwordBookDriver)drivers[i];
            Book book = sdriver.createBook(sbmd);
            Books.installed().addBook(book);
        }
    }

    private Book createBook(SwordBookMetaData sbmd) throws BookException {
        BookType modtype = sbmd.getBookType();
        if (modtype.getBookCategory() == null) {
            log.warn("No support for book type: DRIVER_RAW_GEN_BOOK");
            throw new BookException(Msg.TYPE_UNSUPPORTED);
        }
        return modtype.createBook(sbmd);
    }
}

