/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.book.CaseType;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.versification.BibleInfo;
import org.crosswire.jsword.versification.Msg;
import org.crosswire.jsword.versification.OSISNames;

public final class BibleNames {
    private static final String FULL_KEY = ".Full";
    private static final String SHORT_KEY = ".Short";
    private static final String ALT_KEY = ".Alt";
    public static final byte GENESIS = 1;
    public static final byte EXODUS = 2;
    public static final byte LEVITICUS = 3;
    public static final byte NUMBERS = 4;
    public static final byte DEUTERONOMY = 5;
    public static final byte JOSHUA = 6;
    public static final byte JUDGES = 7;
    public static final byte RUTH = 8;
    public static final byte SAMUEL1 = 9;
    public static final byte SAMUEL2 = 10;
    public static final byte KINGS1 = 11;
    public static final byte KINGS2 = 12;
    public static final byte CHRONICLES1 = 13;
    public static final byte CHRONICLES2 = 14;
    public static final byte EZRA = 15;
    public static final byte NEHEMIAH = 16;
    public static final byte ESTHER = 17;
    public static final byte JOB = 18;
    public static final byte PSALMS = 19;
    public static final byte PROVERBS = 20;
    public static final byte ECCLESIASTES = 21;
    public static final byte SONGOFSOLOMON = 22;
    public static final byte ISAIAH = 23;
    public static final byte JEREMIAH = 24;
    public static final byte LAMENTATIONS = 25;
    public static final byte EZEKIEL = 26;
    public static final byte DANIEL = 27;
    public static final byte HOSEA = 28;
    public static final byte JOEL = 29;
    public static final byte AMOS = 30;
    public static final byte OBADIAH = 31;
    public static final byte JONAH = 32;
    public static final byte MICAH = 33;
    public static final byte NAHUM = 34;
    public static final byte HABAKKUK = 35;
    public static final byte ZEPHANIAH = 36;
    public static final byte HAGGAI = 37;
    public static final byte ZECHARIAH = 38;
    public static final byte MALACHI = 39;
    public static final byte MATTHEW = 40;
    public static final byte MARK = 41;
    public static final byte LUKE = 42;
    public static final byte JOHN = 43;
    public static final byte ACTS = 44;
    public static final byte ROMANS = 45;
    public static final byte CORINTHIANS1 = 46;
    public static final byte CORINTHIANS2 = 47;
    public static final byte GALATIANS = 48;
    public static final byte EPHESIANS = 49;
    public static final byte PHILIPPIANS = 50;
    public static final byte COLOSSIANS = 51;
    public static final byte THESSALONIANS1 = 52;
    public static final byte THESSALONIANS2 = 53;
    public static final byte TIMOTHY1 = 54;
    public static final byte TIMOTHY2 = 55;
    public static final byte TITUS = 56;
    public static final byte PHILEMON = 57;
    public static final byte HEBREWS = 58;
    public static final byte JAMES = 59;
    public static final byte PETER1 = 60;
    public static final byte PETER2 = 61;
    public static final byte JOHN1 = 62;
    public static final byte JOHN2 = 63;
    public static final byte JOHN3 = 64;
    public static final byte JUDE = 65;
    public static final byte REVELATION = 66;
    private static Pattern normPattern;
    private Locale locale;
    private String[] fullBooks;
    private String[] fullBooksSearch;
    private Map fullBooksMap;
    private String[] shortBooks;
    private String[] shortBooksSearch;
    private Map shortBooksMap;
    private String[][] altBooks;
    private Map altBooksMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BibleNames(Locale locale) {
        this.locale = locale;
        this.initialize();
    }

    public String getBookName(int book) throws NoSuchVerseException {
        if (BibleInfo.isFullBookName()) {
            return this.getLongBookName(book);
        }
        return this.getShortBookName(book);
    }

    public String getLongBookName(int book) throws NoSuchVerseException {
        try {
            CaseType bookCase = BibleInfo.getDefaultCase();
            if (bookCase == CaseType.LOWER) {
                return this.fullBooks[book - 1].toLowerCase(this.locale);
            }
            if (bookCase == CaseType.UPPER) {
                return this.fullBooks[book - 1].toUpperCase(this.locale);
            }
            return this.fullBooks[book - 1];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new NoSuchVerseException((MsgBase)Msg.BOOKS_BOOK, new Object[]{new Integer(book)});
        }
    }

    public String getShortBookName(int book) throws NoSuchVerseException {
        try {
            CaseType bookCase = BibleInfo.getDefaultCase();
            if (bookCase.equals(CaseType.LOWER)) {
                return this.shortBooks[book - 1].toLowerCase(this.locale);
            }
            if (bookCase.equals(CaseType.UPPER)) {
                return this.shortBooks[book - 1].toUpperCase(this.locale);
            }
            return this.shortBooks[book - 1];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new NoSuchVerseException((MsgBase)Msg.BOOKS_BOOK, new Object[]{new Integer(book)});
        }
    }

    public int getBookNumber(String find) {
        int i;
        String match = this.normalize(find);
        Integer bookNum = (Integer)this.fullBooksMap.get(match);
        if (bookNum != null) {
            return bookNum;
        }
        bookNum = (Integer)this.shortBooksMap.get(match);
        if (bookNum != null) {
            return bookNum;
        }
        bookNum = (Integer)this.altBooksMap.get(match);
        if (bookNum != null) {
            return bookNum;
        }
        for (i = 0; i < this.altBooks.length; ++i) {
            for (int j = 0; j < this.altBooks[i].length; ++j) {
                String targetBookName = this.altBooks[i][j];
                if (!targetBookName.startsWith(match) && !match.startsWith(targetBookName)) continue;
                return i + 1;
            }
        }
        for (i = 0; i < this.fullBooksSearch.length; ++i) {
            String targetBookName = this.fullBooksSearch[i];
            if (targetBookName.startsWith(match)) {
                return i + 1;
            }
            targetBookName = this.shortBooksSearch[i];
            if (!targetBookName.startsWith(match) && !match.startsWith(targetBookName)) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean isBookName(String find) {
        return this.getBookNumber(find) != -1;
    }

    private String normalize(String str) {
        return normPattern.matcher(str).replaceAll("").toLowerCase(this.locale);
    }

    private void initialize() {
        int booksInBible = BibleInfo.booksInBible();
        this.fullBooks = new String[booksInBible];
        this.fullBooksSearch = new String[booksInBible];
        this.fullBooksMap = new HashMap(booksInBible);
        this.shortBooks = new String[booksInBible];
        this.shortBooksSearch = new String[booksInBible];
        this.shortBooksMap = new HashMap(booksInBible);
        this.altBooks = new String[booksInBible][];
        this.altBooksMap = new HashMap(booksInBible);
        ResourceBundle resources = ResourceBundle.getBundle(BibleNames.class.getName(), this.locale, (ClassLoader)CWClassLoader.instance((Class)BibleNames.class));
        for (int i = 0; i < booksInBible; ++i) {
            String osisName;
            Integer bookNum;
            block5: {
                bookNum = new Integer(i + 1);
                osisName = "";
                try {
                    osisName = OSISNames.getName(i + 1);
                }
                catch (NoSuchVerseException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            String fullBook = this.getString(resources, osisName + FULL_KEY);
            String normalized = this.normalize(fullBook);
            this.fullBooks[i] = fullBook;
            this.fullBooksSearch[i] = normalized;
            this.fullBooksMap.put(normalized, bookNum);
            String shortBook = this.getString(resources, osisName + SHORT_KEY);
            if (shortBook.length() == 0) {
                shortBook = fullBook;
            }
            normalized = this.normalize(shortBook);
            this.shortBooks[i] = shortBook;
            this.shortBooksSearch[i] = normalized;
            this.shortBooksMap.put(normalized, bookNum);
            String altBook = this.getString(resources, osisName + ALT_KEY);
            String[] alternates = StringUtil.split((String)altBook, (char)',');
            this.altBooks[i] = alternates;
            for (int j = 0; j < alternates.length; ++j) {
                this.altBooksMap.put(alternates[j], bookNum);
            }
        }
    }

    private String getString(ResourceBundle resources, String key) {
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    static {
        $assertionsDisabled = !BibleNames.class.desiredAssertionStatus();
        normPattern = Pattern.compile("[. ]");
    }
}

