/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crosswire.common.util.StringUtil;

public final class StackTrace {
    private String[] classNames;
    private String[] methodNames;
    private String[] fileNames;
    private int[] lineNumbers;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StackTrace() {
        this.init(new Throwable(), 2);
    }

    public StackTrace(Throwable ex) {
        this.init(ex, 1);
    }

    private void init(Throwable ex, int discard) {
        StringWriter sout = new StringWriter();
        ex.printStackTrace(new PrintWriter(sout));
        String msg = new String(sout.getBuffer());
        String[] calls = StringUtil.split(msg, "\n\r");
        this.classNames = new String[calls.length - discard];
        this.methodNames = new String[calls.length - discard];
        this.fileNames = new String[calls.length - discard];
        this.lineNumbers = new int[calls.length - discard];
        for (int i = 0; i < this.classNames.length; ++i) {
            String call = calls[i + discard];
            try {
                int spcIndex = call.indexOf(32);
                int lhsIndex = call.indexOf(40);
                int clnIndex = call.indexOf(58);
                int rhsIndex = call.indexOf(41);
                String fullFn = call.substring(spcIndex + 1, lhsIndex).trim();
                int lastDot = fullFn.lastIndexOf(46);
                this.classNames[i] = fullFn.substring(0, lastDot).replace('/', '.');
                this.methodNames[i] = fullFn.substring(lastDot + 1);
                if (clnIndex != -1) {
                    this.fileNames[i] = call.substring(lhsIndex + 1, clnIndex);
                    this.lineNumbers[i] = Integer.parseInt(call.substring(clnIndex + 1, rhsIndex));
                    continue;
                }
                this.fileNames[i] = call.substring(lhsIndex + 1, rhsIndex);
                this.lineNumbers[i] = 0;
                continue;
            }
            catch (NumberFormatException ex2) {
                this.classNames[i] = "ParseError: ";
                this.methodNames[i] = call;
                this.fileNames[i] = "Error";
                this.lineNumbers[i] = 0;
            }
        }
    }

    public int countStackElements() {
        return this.methodNames.length;
    }

    public String getFunctionName(int level) {
        return this.methodNames[level];
    }

    public String getFullFunctionName(int level) {
        return this.classNames[level] + '.' + this.methodNames[level] + "()";
    }

    public String getClassName(int level) {
        return this.classNames[level];
    }

    public String getFileName(int level) {
        return this.fileNames[level];
    }

    public int getLineNumber(int level) {
        return this.lineNumbers[level];
    }

    public int getClassCount() {
        return this.classNames.length;
    }

    public Class getClass(int level) {
        try {
            return Class.forName(this.classNames[level]);
        }
        catch (ClassNotFoundException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return null;
        }
    }

    public Iterator getClassNameElements() {
        return new AbstractStackIterator(){

            public Object next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StackTrace.this.getClassName(this.getAndIncrementLevel());
            }
        };
    }

    public Iterator getFunctionNameElements() {
        return new AbstractStackIterator(){

            public Object next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StackTrace.this.getFunctionName(this.getAndIncrementLevel());
            }
        };
    }

    public Iterator getFullFunctionNameElements() {
        return new AbstractStackIterator(){

            public Object next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StackTrace.this.getFullFunctionName(this.getAndIncrementLevel());
            }
        };
    }

    static {
        $assertionsDisabled = !StackTrace.class.desiredAssertionStatus();
    }

    public abstract class AbstractStackIterator
    implements Iterator {
        private int level;

        public boolean hasNext() {
            return this.level < StackTrace.this.getClassCount();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public int getAndIncrementLevel() throws NoSuchElementException {
            return this.level++;
        }
    }
}

