/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.filter.Filter;

public final class FilterFactory {
    private static final Logger log = Logger.getLogger((Class)FilterFactory.class);
    private static Map filters = new HashMap();
    private static Filter deft;

    private FilterFactory() {
    }

    public static Filter getFilter(String lookup) {
        Filter reply = null;
        Iterator it = filters.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.equalsIgnoreCase(lookup)) continue;
            reply = (Filter)filters.get(key);
            break;
        }
        if (reply == null) {
            reply = deft;
        }
        return (Filter)reply.clone();
    }

    public static Filter getDefaultFilter() {
        return (Filter)deft.clone();
    }

    public static void addFilter(String name, Filter instance) {
        filters.put(name, instance);
    }

    static {
        Map map = ClassUtil.getImplementorsMap((Class)Filter.class);
        try {
            Class cdeft = (Class)map.remove("default");
            deft = (Filter)cdeft.newInstance();
        }
        catch (InstantiationException e) {
            log.fatal("Failed to get default filter, will attempt to use first", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.fatal("Failed to get default filter, will attempt to use first", (Throwable)e);
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            try {
                Map.Entry entry = it.next();
                Class clazz = (Class)entry.getValue();
                Filter instance = (Filter)clazz.newInstance();
                FilterFactory.addFilter((String)entry.getKey(), instance);
            }
            catch (InstantiationException ex) {
                log.error("Failed to add filter", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                log.error("Failed to add filter", (Throwable)ex);
            }
        }
        if (deft == null) {
            deft = (Filter)filters.values().iterator().next();
        }
    }
}

