/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.basic.AbstractBookMetaData;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.filter.FilterFactory;
import org.crosswire.jsword.book.sword.BookType;
import org.crosswire.jsword.book.sword.ConfigEntryTable;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.jdom.Document;

public final class SwordBookMetaData
extends AbstractBookMetaData {
    private static final Map ENCODING_JAVA = new HashMap();
    private ConfigEntryTable cet;
    private BookCategory type;

    public SwordBookMetaData(File file, String internal, URL bookRootPath) throws IOException {
        this.cet = new ConfigEntryTable(internal);
        this.cet.load(file);
        this.setLibrary(bookRootPath);
        this.buildProperties();
    }

    public SwordBookMetaData(byte[] buffer, String internal) throws IOException {
        this.cet = new ConfigEntryTable(internal);
        this.cet.load(buffer);
        this.buildProperties();
    }

    public boolean isQuestionable() {
        return this.cet.isQuestionable();
    }

    public boolean isSupported() {
        return this.cet.isSupported() && this.cet.getBookType().isSupported(this);
    }

    public boolean isEnciphered() {
        return this.cet.isEnciphered();
    }

    public boolean isLocked() {
        return this.cet.isLocked();
    }

    public boolean unlock(String unlockKey) {
        return this.cet.unlock(unlockKey);
    }

    public String getUnlockKey() {
        return this.cet.getUnlockKey();
    }

    public String getName() {
        return this.getProperty(ConfigEntryType.DESCRIPTION);
    }

    public String getBookCharset() {
        return (String)ENCODING_JAVA.get(this.getProperty(ConfigEntryType.ENCODING));
    }

    public BookType getBookType() {
        return this.cet.getBookType();
    }

    public Filter getFilter() {
        String sourcetype = this.getProperty(ConfigEntryType.SOURCE_TYPE);
        return FilterFactory.getFilter(sourcetype);
    }

    public String getConfPath() {
        return "mods.d/" + this.getInitials().toLowerCase(Locale.ENGLISH) + ".conf";
    }

    public void setLibrary(URL library) {
        this.cet.add(ConfigEntryType.LIBRARY_URL, library.toExternalForm());
        super.setLibrary(library);
        String datapath = this.getProperty(ConfigEntryType.DATA_PATH);
        datapath = datapath.substring(0, datapath.lastIndexOf(47));
        URL location = NetUtil.lengthenURL((URL)library, (String)datapath);
        this.cet.add(ConfigEntryType.LOCATION_URL, location.toExternalForm());
        super.setLocation(location);
    }

    public BookCategory getBookCategory() {
        if (this.type == null) {
            this.type = BookCategory.fromString(this.getProperty(ConfigEntryType.CATEGORY));
            if (this.type == BookCategory.OTHER) {
                this.type = this.getBookType().getBookCategory();
            }
        }
        return this.type;
    }

    public Document toOSIS() {
        return new Document(this.cet.toOSIS());
    }

    public String getInitials() {
        return this.getProperty(ConfigEntryType.INITIALS);
    }

    public String getProperty(ConfigEntryType entry) {
        Object obj = this.cet.getValue(entry);
        return obj != null ? obj.toString() : null;
    }

    public boolean isLeftToRight() {
        String dir = this.getProperty(ConfigEntryType.DIRECTION);
        return dir == null || dir.equals(ConfigEntryType.DIRECTION.getDefault());
    }

    public boolean hasFeature(FeatureType feature) {
        return this.cet.match(ConfigEntryType.FEATURE, feature.toString());
    }

    private void buildProperties() {
        Iterator iter = this.cet.getKeys().iterator();
        while (iter.hasNext()) {
            ConfigEntryType key = (ConfigEntryType)iter.next();
            Object value = this.cet.getValue(key);
            if (value == null) continue;
            if (value instanceof List) {
                List list = (List)value;
                StringBuffer combined = new StringBuffer();
                boolean appendSeparator = false;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    String element = (String)it.next();
                    if (appendSeparator) {
                        combined.append('\n');
                    }
                    combined.append(element);
                    appendSeparator = true;
                }
                value = combined.toString();
            }
            this.putProperty(key.toString(), value.toString());
        }
    }

    static {
        ENCODING_JAVA.put("Latin-1", "WINDOWS-1252");
        ENCODING_JAVA.put("UTF-8", "UTF-8");
    }
}

