/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.Msg;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.PassageUtil;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.BibleInfo;

public final class Verse
implements Key,
Serializable {
    static final long serialVersionUID = -4033921076023185171L;
    private static final int BOOK = 0;
    private static final int CHAPTER = 1;
    private static final int VERSE = 2;
    public static final String VERSE_OSIS_DELIM = ".";
    public static final String VERSE_PREF_DELIM1 = " ";
    public static final String VERSE_PREF_DELIM2 = ":";
    public static final Verse DEFAULT;
    private transient Key parent;
    private transient int book;
    private transient int chapter;
    private transient int verse;
    private transient String originalName;
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Verse() {
        this.originalName = null;
        this.book = Verse.DEFAULT.book;
        this.chapter = Verse.DEFAULT.chapter;
        this.verse = Verse.DEFAULT.verse;
    }

    Verse(String original, int book, int chapter, int verse) throws NoSuchVerseException {
        this.originalName = original;
        this.set(book, chapter, verse);
    }

    public Verse(int book, int chapter, int verse) throws NoSuchVerseException {
        this(null, book, chapter, verse);
    }

    public Verse(int book, int chapter, int verse, boolean patch_up) {
        if (!patch_up) {
            throw new IllegalArgumentException(Msg.ERROR_PATCH.toString());
        }
        this.originalName = null;
        this.setAndPatch(book, chapter, verse);
    }

    public Verse(int ordinal) throws NoSuchVerseException {
        this.originalName = null;
        this.set(ordinal);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        try {
            if (PassageUtil.isPersistentNaming() && this.originalName != null) {
                return this.originalName;
            }
            if (BibleInfo.chaptersInBook(this.book) == 1) {
                return BibleInfo.getBookName(this.book) + VERSE_PREF_DELIM1 + this.verse;
            }
            return BibleInfo.getBookName(this.book) + VERSE_PREF_DELIM1 + this.chapter + VERSE_PREF_DELIM2 + this.verse;
        }
        catch (NoSuchKeyException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return "!Error!";
        }
    }

    public String getName(Key base) {
        if (!(base instanceof Verse)) {
            return this.getName();
        }
        try {
            if (PassageUtil.isPersistentNaming() && this.originalName != null) {
                return this.originalName;
            }
            Verse verseBase = (Verse)base;
            if (BibleInfo.chaptersInBook(this.book) == 1) {
                if (verseBase.book != this.book) {
                    return BibleInfo.getBookName(this.book) + VERSE_PREF_DELIM1 + this.verse;
                }
                return String.valueOf(this.verse);
            }
            if (verseBase.book != this.book) {
                return BibleInfo.getBookName(this.book) + VERSE_PREF_DELIM1 + this.chapter + VERSE_PREF_DELIM2 + this.verse;
            }
            if (verseBase.chapter != this.chapter) {
                return this.chapter + VERSE_PREF_DELIM2 + this.verse;
            }
            return String.valueOf(this.verse);
        }
        catch (NoSuchKeyException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return "!Error!";
        }
    }

    public String getRootName() {
        try {
            return BibleInfo.getBookName(this.book);
        }
        catch (NoSuchKeyException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return "!Error!";
        }
    }

    public String getOsisRef() {
        try {
            return BibleInfo.getOSISName(this.book) + VERSE_OSIS_DELIM + this.chapter + VERSE_OSIS_DELIM + this.verse;
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return "!Error!";
        }
    }

    public String getOsisID() {
        return this.getOsisRef();
    }

    public Object clone() {
        Verse copy;
        block2: {
            copy = null;
            try {
                copy = (Verse)super.clone();
                copy.book = this.book;
                copy.chapter = this.chapter;
                copy.verse = this.verse;
                copy.originalName = this.originalName;
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Verse v = (Verse)obj;
        if (v.getBook() != this.getBook()) {
            return false;
        }
        if (v.getChapter() != this.getChapter()) {
            return false;
        }
        return v.getVerse() == this.getVerse();
    }

    public int hashCode() {
        return this.getOrdinal();
    }

    public int compareTo(Object obj) {
        int thisStart;
        Verse that = null;
        that = obj instanceof Verse ? (Verse)obj : ((VerseRange)obj).getStart();
        int thatStart = that.getOrdinal();
        if (thatStart > (thisStart = this.getOrdinal())) {
            return -1;
        }
        if (thatStart < thisStart) {
            return 1;
        }
        return 0;
    }

    public boolean adjacentTo(Verse that) {
        return Math.abs(that.getOrdinal() - this.getOrdinal()) == 1;
    }

    public int subtract(Verse that) {
        return this.getOrdinal() - that.getOrdinal();
    }

    public Verse subtract(int n) {
        try {
            int new_ordinal = Math.max(this.getOrdinal() - n, 1);
            return new Verse(new_ordinal);
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return DEFAULT;
        }
    }

    public Verse add(int extra) {
        try {
            int new_ordinal = Math.min(this.getOrdinal() + extra, BibleInfo.versesInBible());
            return new Verse(new_ordinal);
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return DEFAULT;
        }
    }

    public int getBook() {
        return this.book;
    }

    public int getChapter() {
        return this.chapter;
    }

    public int getVerse() {
        return this.verse;
    }

    public boolean isStartOfChapter() {
        return this.verse == 1;
    }

    public boolean isEndOfChapter() {
        try {
            return this.verse == BibleInfo.versesInChapter(this.book, this.chapter);
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return true;
        }
    }

    public boolean isStartOfBook() {
        return this.verse == 1 && this.chapter == 1;
    }

    public boolean isEndOfBook() {
        try {
            return this.verse == BibleInfo.versesInChapter(this.book, this.chapter) && this.chapter == BibleInfo.chaptersInBook(this.book);
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return true;
        }
    }

    public boolean isSameChapter(Verse that) {
        return this.book == that.book && this.chapter == that.chapter;
    }

    public boolean isSameBook(Verse that) {
        return this.book == that.book;
    }

    public int[] getRefArray() {
        return new int[]{this.book, this.chapter, this.verse};
    }

    public int getOrdinal() {
        try {
            return BibleInfo.verseOrdinal(this.book, this.chapter, this.verse);
        }
        catch (NoSuchVerseException ex) {
            log.error("ref=" + this.book + ", " + this.chapter + ", " + this.verse);
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return 1;
        }
    }

    public static Verse max(Verse a, Verse b) {
        if (a.compareTo(b) == -1) {
            return b;
        }
        return a;
    }

    public static Verse min(Verse a, Verse b) {
        if (a.compareTo(b) == 1) {
            return b;
        }
        return a;
    }

    public Verse[] toVerseArray() {
        return new Verse[]{this};
    }

    public Verse getLastVerseInBook() {
        try {
            int lastchap = BibleInfo.chaptersInBook(this.book);
            int lastverse = BibleInfo.versesInChapter(this.book, lastchap);
            return new Verse(this.book, lastchap, lastverse);
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return DEFAULT;
        }
    }

    public Verse getLastVerseInChapter() {
        try {
            int lastverse = BibleInfo.versesInChapter(this.book, this.chapter);
            return new Verse(this.book, this.chapter, lastverse);
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return DEFAULT;
        }
    }

    public Verse getFirstVerseInBook() {
        try {
            return new Verse(this.book, 1, 1);
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return DEFAULT;
        }
    }

    public Verse getFirstVerseInChapter() {
        try {
            return new Verse(this.book, this.chapter, 1);
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return DEFAULT;
        }
    }

    public Key getParent() {
        return this.parent;
    }

    public void setParent(Key parent) {
        this.parent = parent;
    }

    protected static int parseInt(String text) throws NoSuchVerseException {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            throw new NoSuchVerseException((MsgBase)Msg.VERSE_PARSE, new Object[]{text});
        }
    }

    private void setAndPatch(int book, int chapter, int verse) {
        int[] ref = new int[]{book, chapter, verse};
        BibleInfo.patch(ref);
        this.book = ref[0];
        this.chapter = ref[1];
        this.verse = ref[2];
    }

    private void set(int book, int chapter, int verse) throws NoSuchVerseException {
        BibleInfo.validate(book, chapter, verse);
        this.book = book;
        this.chapter = chapter;
        this.verse = verse;
    }

    private void set(int ordinal) throws NoSuchVerseException {
        int[] ref = BibleInfo.decodeOrdinal(ordinal);
        this.book = ref[0];
        this.chapter = ref[1];
        this.verse = ref[2];
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.getOrdinal());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.set(in.readInt());
        }
        catch (NoSuchVerseException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public boolean canHaveChildren() {
        return false;
    }

    public int getChildCount() {
        return 0;
    }

    public int getCardinality() {
        return 1;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean contains(Key key) {
        return false;
    }

    public Iterator iterator() {
        return new VerseIterator();
    }

    public void addAll(Key key) {
        throw new UnsupportedOperationException();
    }

    public void removeAll(Key key) {
        throw new UnsupportedOperationException();
    }

    public void retainAll(Key key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
    }

    public Key get(int index) {
        return null;
    }

    public int indexOf(Key that) {
        return -1;
    }

    public void blur(int by, RestrictionType restrict) {
        throw new UnsupportedOperationException();
    }

    static {
        $assertionsDisabled = !Verse.class.desiredAssertionStatus();
        DEFAULT = new Verse(1, 1, 1, true);
        log = Logger.getLogger((Class)Verse.class);
    }

    class VerseIterator
    implements Iterator {
        private boolean done;

        VerseIterator() {
        }

        public boolean hasNext() {
            return !this.done;
        }

        public Object next() {
            if (this.done) {
                throw new NoSuchElementException();
            }
            this.done = true;
            return Verse.this;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

