/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.util.HttpURLConnection;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.Msg;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;

public class WebResource {
    private URL url;
    private HttpClient client;

    public WebResource(URL theURL) {
        this(theURL, null);
    }

    public WebResource(URL theURL, String theProxyHost) {
        this(theURL, theProxyHost, null);
    }

    public WebResource(URL theURL, String theProxyHost, Integer theProxyPort) {
        this.url = theURL;
        this.client = new HttpClient();
        HostConfiguration config = this.client.getHostConfiguration();
        config.setHost(new HttpHost(theURL.getHost(), theURL.getPort()));
        if (theProxyHost != null && theProxyHost.length() > 0) {
            config.setProxyHost(new ProxyHost(theProxyHost, theProxyPort == null ? -1 : theProxyPort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        HeadMethod method = new HeadMethod(this.url.getPath());
        try {
            int status = this.client.executeMethod((HttpMethod)method);
            if (status == 200) {
                int n = new HttpURLConnection((HttpMethod)method, this.url).getContentLength();
                return n;
            }
            String reason = HttpStatus.getStatusText((int)status);
            Reporter.informUser((Object)this, (MsgBase)Msg.MISSING_FILE, new Object[]{reason + ':' + this.url.getFile()});
        }
        catch (IOException e) {
            int n = 0;
            return n;
        }
        finally {
            method.releaseConnection();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified() {
        HeadMethod method = new HeadMethod(this.url.getPath());
        try {
            if (this.client.executeMethod((HttpMethod)method) == 200) {
                long l = new HttpURLConnection((HttpMethod)method, this.url).getLastModified();
                return l;
            }
        }
        catch (IOException e) {
            long l = new Date().getTime();
            return l;
        }
        finally {
            method.releaseConnection();
        }
        return new Date().getTime();
    }

    public void copy(URL dest) throws LucidException {
        InputStream in = null;
        OutputStream out = null;
        GetMethod method = new GetMethod(this.url.getPath());
        try {
            if (this.client.executeMethod((HttpMethod)method) == 200) {
                in = method.getResponseBodyAsStream();
                out = NetUtil.getOutputStream(dest);
                byte[] buf = new byte[4096];
                int count = in.read(buf);
                while (-1 != count) {
                    out.write(buf, 0, count);
                    count = in.read(buf);
                }
            }
        }
        catch (IOException e) {
            try {
                throw new LucidException((MsgBase)Msg.MISSING_FILE, (Throwable)e);
            }
            catch (Throwable throwable) {
                method.releaseConnection();
                IOUtil.close(in);
                IOUtil.close(out);
                throw throwable;
            }
        }
        method.releaseConnection();
        IOUtil.close(in);
        IOUtil.close(out);
    }
}

