/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.event.ListDataListener;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookList;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;

public class BooksListModel
extends AbstractListModel {
    private transient BookList bookList;
    private transient BookFilter filter;
    private transient CustomListDataListener listener = new CustomListDataListener();
    protected List books;
    private static final Logger log = Logger.getLogger((Class)BooksListModel.class);
    private static final long serialVersionUID = 3257568408165036595L;

    public BooksListModel() {
        this(null);
    }

    public BooksListModel(BookFilter filter) {
        this(filter, (BookList)Books.installed());
    }

    public BooksListModel(BookFilter filter, BookList bookList) {
        this.filter = filter;
        this.bookList = bookList;
        this.cacheData();
    }

    public synchronized int getSize() {
        return this.books.size();
    }

    public synchronized Object getElementAt(int index) {
        if (index > this.books.size()) {
            log.error("trying to get book at " + index + " when there are only " + this.books.size() + " known books.");
            return null;
        }
        return this.books.get(index);
    }

    public synchronized int getIndexOf(Object test) {
        return this.books.indexOf(test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(BookFilter filter) {
        BooksListModel booksListModel = this;
        synchronized (booksListModel) {
            this.filter = filter;
        }
        this.cacheData();
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void addListDataListener(ListDataListener li) {
        if (this.listenerList.getListenerCount() == 0) {
            this.bookList.addBooksListener((BooksListener)this.listener);
        }
        super.addListDataListener(li);
    }

    public void removeListDataListener(ListDataListener li) {
        super.removeListDataListener(li);
        if (this.listenerList.getListenerCount() == 0) {
            this.bookList.removeBooksListener((BooksListener)this.listener);
        }
    }

    protected final synchronized void cacheData() {
        this.books = new ArrayList();
        this.books.addAll(this.bookList.getBooks(this.filter));
        Collections.sort(this.books);
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        super.fireContentsChanged(source, index0, index1);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.listener = new CustomListDataListener();
        this.filter = null;
        this.bookList = Books.installed();
        is.defaultReadObject();
    }

    class CustomListDataListener
    implements BooksListener {
        CustomListDataListener() {
        }

        public void bookAdded(BooksEvent ev) {
            int oldsize = BooksListModel.this.getSize();
            BooksListModel.this.cacheData();
            BooksListModel.this.fireContentsChanged(ev.getSource(), 0, oldsize);
        }

        public void bookRemoved(BooksEvent ev) {
            int oldsize = BooksListModel.this.getSize();
            BooksListModel.this.cacheData();
            BooksListModel.this.fireContentsChanged(ev.getSource(), 0, oldsize);
        }
    }
}

