/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.crosswire.common.util.Filter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.Msg;

public class BookSet
extends ArrayList
implements Set {
    private static final long serialVersionUID = 3258688806185154867L;

    public BookSet() {
    }

    public BookSet(Collection books) {
        this();
        this.addAll(books);
    }

    public Set getGroups() {
        TreeSet results = new TreeSet();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Book book = (Book)iter.next();
            results.addAll(book.getProperties().keySet());
        }
        return results;
    }

    public Set getGroup(String key) {
        TreeSet<String> results = new TreeSet<String>();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Book book = (Book)iter.next();
            String property = book.getProperty(key);
            String propertyValue = property == null ? Msg.BOOK_METADATA_SET_OTHER.toString() : property;
            results.add(propertyValue);
        }
        return results;
    }

    public BookSet filter(String key, String value) {
        return this.filter(new GroupFilter(key, value));
    }

    public void add(int index, Object element) {
        this.add(element);
    }

    public final boolean add(Object book) {
        int pos = Collections.binarySearch(this, book);
        if (pos < 0) {
            super.add(-pos - 1, book);
            return true;
        }
        return false;
    }

    public final boolean addAll(Collection c) {
        boolean added = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Book book = (Book)iter.next();
            if (!this.add(book)) continue;
            added = true;
        }
        return added;
    }

    public final boolean addAll(int index, Collection c) {
        return this.addAll(c);
    }

    public Object set(int index, Object element) {
        Book item = (Book)this.remove(index);
        this.add(element);
        return item;
    }

    public BookSet filter(Filter filter) {
        BookSet listSet = (BookSet)this.clone();
        Iterator iter = listSet.iterator();
        while (iter.hasNext()) {
            Book obj = (Book)iter.next();
            if (filter.test((Object)obj)) continue;
            iter.remove();
        }
        return listSet;
    }

    private static final class GroupFilter
    implements Filter {
        private String key;
        private String value;

        public GroupFilter(String aKey, String aValue) {
            this.key = aKey;
            this.value = aValue;
        }

        public boolean test(Object obj) {
            Book book = (Book)obj;
            String property = book.getProperty(this.key);
            return property != null && property.equals(this.value);
        }
    }
}

