/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.util.OSType;

public final class Project {
    public static final String DIR_NETCACHE = "netcache";
    public static final String DIR_PROJECT = ".jsword";
    public static final String DIR_PROJECT_ALT = "JSword";
    private static final String PROPERTY_JSWORD_HOME = "jsword.home";
    private URL home;
    private static final Logger log = Logger.getLogger((Class)Project.class);
    private static Project instance = new Project();

    public static Project instance() {
        return instance;
    }

    private Project() {
        CWClassLoader.setHome((URL)this.getUserProjectDir());
        try {
            URL urlcache = this.getTempScratchSpace(DIR_NETCACHE, true);
            File filecache = new File(urlcache.getFile());
            NetUtil.setURLCacheDir((File)filecache);
        }
        catch (IOException ex) {
            log.warn("Failed to get directory for NetUtil.setURLCacheDir()", (Throwable)ex);
        }
    }

    public URL getUserProjectDir(String hiddenFolderName, String visibleFolderName) {
        return OSType.getOSType().getUserAreaFolder(hiddenFolderName, visibleFolderName);
    }

    public URL getUserProjectDir() {
        String jswordhome;
        if (this.home == null && (jswordhome = System.getProperty(PROPERTY_JSWORD_HOME)) != null) {
            try {
                this.home = new URL("file", null, jswordhome);
                if (!NetUtil.canWrite((URL)this.home)) {
                    this.home = null;
                }
            }
            catch (MalformedURLException e) {
                this.home = null;
            }
        }
        if (this.home == null) {
            URL path = this.getUserProjectDir(DIR_PROJECT, DIR_PROJECT_ALT);
            URL oldPath = this.getDeprecatedUserProjectDir();
            this.home = this.migrateUserProjectDir(oldPath, path);
        }
        return this.home;
    }

    public URL getDeprecatedUserProjectDir() {
        return OSType.DEFAULT.getUserAreaFolder(DIR_PROJECT, DIR_PROJECT_ALT);
    }

    private URL migrateUserProjectDir(URL oldPath, URL newPath) {
        if (oldPath.toExternalForm().equals(newPath.toExternalForm())) {
            return newPath;
        }
        if (NetUtil.isDirectory((URL)oldPath)) {
            File oldDir = new File(oldPath.getFile());
            File newDir = new File(newPath.getFile());
            oldDir.renameTo(newDir);
            if (NetUtil.isDirectory((URL)newPath)) {
                return newPath;
            }
            return oldPath;
        }
        return newPath;
    }

    public URL getWritablePropertiesURL(String subject) {
        return NetUtil.lengthenURL((URL)this.getUserProjectDir(), (String)(subject + ".properties"));
    }

    public URL getTempScratchSpace(String subject, boolean create) throws IOException {
        URL temp = NetUtil.lengthenURL((URL)this.getUserProjectDir(), (String)subject);
        if (create && !NetUtil.isDirectory((URL)temp)) {
            NetUtil.makeDirectory((URL)temp);
        }
        return temp;
    }
}

