/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.Config;
import org.crosswire.common.config.ConfigEvent;
import org.crosswire.common.config.ConfigListener;
import org.crosswire.common.config.swing.ButtonPaneListener;
import org.crosswire.common.config.swing.ConfigEditor;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.config.swing.FieldMap;
import org.crosswire.common.swing.FormPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.Logger;

public abstract class AbstractConfigEditor
extends JPanel
implements ConfigEditor,
ButtonPaneListener {
    private static final Logger log = Logger.getLogger((Class)AbstractConfigEditor.class);
    protected int cards;
    protected ActionListener al;
    protected Config config;
    protected JDialog dialog;
    protected Map decks = new HashMap();
    protected Map fields = new HashMap();
    protected static final ImageIcon TASK_ICON_LARGE = GuiUtil.getIcon("toolbarButtonGraphics/general/Preferences24.gif");
    protected static final ImageIcon TASK_ICON_SMALL = GuiUtil.getIcon("toolbarButtonGraphics/general/Preferences16.gif");

    public void construct(Config aConfig) {
        this.config = aConfig;
        this.initializeGUI();
        this.config.addConfigListener(new ConfigListener(){

            public void choiceAdded(ConfigEvent ev) {
                AbstractConfigEditor.this.addChoice(ev.getChoice());
                AbstractConfigEditor.this.updateTree();
            }

            public void choiceRemoved(ConfigEvent ev) {
                AbstractConfigEditor.this.removeChoice(ev.getChoice());
                AbstractConfigEditor.this.updateTree();
            }
        });
        Iterator it = this.config.iterator();
        while (it.hasNext()) {
            Choice model = (Choice)it.next();
            this.addChoice(model);
        }
        this.updateTree();
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void showDialog(Component parent, ActionListener newal) {
        this.al = newal;
        if (this.dialog == null) {
            this.dialog = new JDialog((JFrame)SwingUtilities.getRoot(parent));
            this.dialog.getContentPane().add(this);
        }
        this.localToScreen();
        this.dialog.setTitle(this.config.getTitle());
        this.dialog.setSize(800, 500);
        this.dialog.pack();
        GuiUtil.centerWindow(this.dialog);
        this.dialog.setModal(true);
        this.dialog.setVisible(true);
    }

    protected abstract void initializeGUI();

    protected abstract void updateTree();

    public void okPressed(ActionEvent ev) {
        this.screenToLocal();
        this.al.actionPerformed(ev);
        this.hideDialog();
    }

    public void cancelPressed(ActionEvent ev) {
        this.hideDialog();
    }

    public void applyPressed(ActionEvent ev) {
        this.screenToLocal();
        this.al.actionPerformed(ev);
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    protected void addChoice(Choice model) {
        if (model.isHidden()) {
            return;
        }
        String key = model.getKey();
        String path = Config.getPath((String)model.getFullPath());
        Field field = FieldMap.getField(model);
        this.fields.put(key, field);
        FormPane card = (FormPane)this.decks.get(path);
        if (card == null) {
            card = new FormPane();
            this.decks.put(path, card);
            ++this.cards;
        }
        JComponent comp = field.getComponent();
        String name = Config.getLeaf((String)model.getFullPath()) + ':';
        card.addEntry(name, model.getHelpText(), comp);
        String value = this.config.getLocal(key);
        field.setValue(value);
    }

    protected void removeChoice(Choice model) {
        String key = model.getKey();
        String path = Config.getPath((String)model.getFullPath());
        Field field = (Field)this.fields.get(key);
        if (field != null) {
            this.fields.remove(field);
            FormPane card = (FormPane)this.decks.get(path);
            String name = Config.getLeaf((String)model.getFullPath()) + ':';
            card.removeEntry(name);
            if (card.isEmpty()) {
                this.decks.remove(card);
            }
        }
    }

    protected void hideDialog() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    protected void screenToLocal() {
        Iterator it = this.config.iterator();
        while (it.hasNext()) {
            Choice choice = (Choice)it.next();
            if (choice.isHidden()) continue;
            String key = choice.getKey();
            Field field = (Field)this.fields.get(key);
            String value = field.getValue();
            if (value == null) {
                log.error("null value from key=" + key);
            }
            this.config.setLocal(key, value);
        }
    }

    protected void localToScreen() {
        Iterator it = this.config.iterator();
        while (it.hasNext()) {
            Choice choice = (Choice)it.next();
            if (choice.isHidden()) continue;
            String key = choice.getKey();
            Field field = (Field)this.fields.get(key);
            String value = this.config.getLocal(key);
            if (field == null) {
                log.error("Null field from key=" + key + ", skipping setting value=" + value);
                continue;
            }
            field.setValue(value);
        }
    }
}

