/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.basic.AbstractBook;
import org.crosswire.jsword.book.filter.FilterException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.ReadOnlyKeyList;

public class SwordGenBook
extends AbstractBook {
    private Key global;
    private boolean active;
    private Map map;
    private Key set;
    private AbstractBackend backend;
    private SwordBookMetaData sbmd;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected SwordGenBook(SwordBookMetaData sbmd, AbstractBackend backend) {
        super(sbmd);
        this.sbmd = sbmd;
        this.backend = backend;
        this.map = null;
        this.set = null;
        this.global = null;
        this.active = false;
    }

    public final void activate(Lock lock) {
        super.activate(lock);
        this.set = this.backend.readIndex();
        this.map = new HashMap();
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            Key key = (Key)iter.next();
            this.map.put(key.getName(), key);
        }
        this.global = new ReadOnlyKeyList(this.set, false);
        this.active = true;
    }

    public final void deactivate(Lock lock) {
        super.deactivate(lock);
        this.map = null;
        this.set = null;
        this.global = null;
        Activator.deactivate((Activatable)this.backend);
        this.active = false;
    }

    public Iterator getOsisIterator(Key key, boolean allowEmpty) throws BookException {
        this.checkActive();
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.backend == null) {
            throw new AssertionError();
        }
        try {
            ArrayList content = new ArrayList();
            String txt = this.backend.getRawText(key);
            List osisContent = this.sbmd.getFilter().toOSIS(this, key, txt);
            content.addAll(osisContent);
            return content.iterator();
        }
        catch (FilterException ex) {
            throw new BookException((MsgBase)Msg.FILTER_FAIL, (Throwable)((Object)ex));
        }
    }

    public String getRawText(Key key) throws BookException {
        this.checkActive();
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.backend == null) {
            throw new AssertionError();
        }
        return this.backend.getRawText(key);
    }

    public boolean isWritable() {
        return this.backend.isWritable();
    }

    public void setRawText(Key key, String rawData) throws BookException {
        throw new BookException(Msg.DRIVER_READONLY);
    }

    public void setAliasKey(Key alias, Key source) throws BookException {
        throw new BookException(Msg.DRIVER_READONLY);
    }

    public Key getGlobalKeyList() {
        this.checkActive();
        return this.global;
    }

    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    public Key getKey(String text) throws NoSuchKeyException {
        String keyName;
        this.checkActive();
        Key key = (Key)this.map.get(text);
        if (key != null) {
            return key;
        }
        Iterator iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            keyName = (String)iter.next();
            if (!keyName.equalsIgnoreCase(text)) continue;
            return (Key)this.map.get(keyName);
        }
        iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            keyName = (String)iter.next();
            if (!keyName.startsWith(text)) continue;
            return (Key)this.map.get(keyName);
        }
        iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            keyName = (String)iter.next();
            if (keyName.indexOf(text) == -1) continue;
            return (Key)this.map.get(keyName);
        }
        throw new NoSuchKeyException((MsgBase)Msg.NO_KEY, new Object[]{text, this.getInitials()});
    }

    public Key createEmptyKeyList() {
        return new DefaultKeyList();
    }

    private void checkActive() {
        if (!this.active) {
            Activator.activate((Activatable)this);
        }
    }

    static {
        $assertionsDisabled = !SwordGenBook.class.desiredAssertionStatus();
    }
}

