/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.passage.Key;

public final class SwordUtil {
    private static final Logger log = Logger.getLogger((Class)SwordUtil.class);

    private SwordUtil() {
    }

    protected static byte[] readRAF(RandomAccessFile raf, long offset, int theSize) throws IOException {
        raf.seek(offset);
        return SwordUtil.readNextRAF(raf, theSize);
    }

    protected static byte[] readNextRAF(RandomAccessFile raf, int theSize) throws IOException {
        int size;
        long offset = raf.getFilePointer();
        if (offset + (long)(size = theSize) > raf.length()) {
            DataPolice.report("Need to reduce size to avoid EOFException. offset=" + offset + " size=" + size + " but raf.length=" + raf.length());
            size = (int)(raf.length() - offset);
        }
        if (size < 1) {
            DataPolice.report("Nothing to read at offset = " + offset + " returning empty because size=" + size);
            return new byte[0];
        }
        byte[] read = new byte[size];
        raf.readFully(read);
        return read;
    }

    protected static byte[] readUntilRAF(RandomAccessFile raf, int offset, byte stopByte) throws IOException {
        raf.seek(offset);
        return SwordUtil.readUntilRAF(raf, stopByte);
    }

    protected static byte[] readUntilRAF(RandomAccessFile raf, byte stopByte) throws IOException {
        long offset = raf.getFilePointer();
        int size = 0;
        byte nextByte = -1;
        do {
            nextByte = raf.read();
            ++size;
        } while (nextByte != -1 && nextByte != stopByte);
        return SwordUtil.readRAF(raf, offset, size);
    }

    protected static int decodeLittleEndian32(byte[] data, int offset) {
        int byte1 = data[0 + offset] & 0xFF;
        int byte2 = (data[1 + offset] & 0xFF) << 8;
        int byte3 = (data[2 + offset] & 0xFF) << 16;
        int byte4 = (data[3 + offset] & 0xFF) << 24;
        return byte4 | byte3 | byte2 | byte1;
    }

    protected static int decodeLittleEndian16(byte[] data, int offset) {
        int byte1 = data[0 + offset] & 0xFF;
        int byte2 = (data[1 + offset] & 0xFF) << 8;
        return byte2 | byte1;
    }

    protected static int findByte(byte[] data, byte sought) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != sought) continue;
            return i;
        }
        return -1;
    }

    public static String decode(Key key, byte[] data, String charset) {
        return SwordUtil.decode(key, data, data.length, charset);
    }

    public static String decode(Key key, byte[] data, int length, String charset) {
        if ("WINDOWS-1252".equals(charset)) {
            SwordUtil.clean1252(key, data, length);
        }
        String txt = "";
        try {
            txt = new String(data, 0, length, charset);
        }
        catch (UnsupportedEncodingException ex) {
            log.error(key + ": Encoding: " + charset + " not supported", (Throwable)ex);
            txt = new String(data, 0, length);
        }
        return txt;
    }

    public static void clean1252(Key key, byte[] data) {
        SwordUtil.clean1252(key, data, data.length);
    }

    public static void clean1252(Key key, byte[] data, int length) {
        for (int i = 0; i < length; ++i) {
            int c = data[i] & 0xFF;
            if ((c < 0 || c >= 32 || c == 9 || c == 10 || c == 13) && c != 129 && c != 141 && c != 143 && c != 144 && c != 157) continue;
            data[i] = 32;
            DataPolice.report(key.getName() + " has bad character 0x" + Integer.toString(c, 16) + " at position " + i + " in input.");
        }
    }
}

