/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import java.io.IOException;
import org.crosswire.common.xml.XMLFeatureSet;
import org.crosswire.common.xml.XMLHandlerAdapter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLProcess {
    private static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    private static final String DECLARATION_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/declaration-handler";
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static final String DEFAULT_HANDLER_NAME = "org.crosswire.common.xml.XMLHandlerAdapter";
    private String parserName = "org.apache.xerces.parsers.SAXParser";
    private XMLReader parser;
    private String adapterName = "org.crosswire.common.xml.XMLHandlerAdapter";
    private XMLHandlerAdapter adapter;
    private XMLFeatureSet features = new XMLFeatureSet();

    public XMLFeatureSet getFeatures() {
        return this.features;
    }

    public static void main(String[] argv) {
        XMLProcess checker = new XMLProcess();
        if (argv.length == 0) {
            checker.usage();
            System.exit(1);
        }
        String arg = null;
        for (int i = 0; i < argv.length; ++i) {
            String option;
            arg = argv[i];
            if (arg.charAt(0) != '-' || !"h".equals(option = arg.substring(1))) continue;
            checker.usage();
            System.exit(0);
        }
        checker.initialize(argv);
        checker.parse(arg);
    }

    private void initialize(String[] argv) {
        int i = 0;
        for (i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.charAt(0) != '-') continue;
            String option = arg.substring(1);
            if ("p".equals(option)) {
                if (++i == argv.length) {
                    System.err.println("error: Missing argument to -p option.");
                }
                this.parserName = argv[i];
                this.createParser();
                continue;
            }
            if (!"a".equals(option)) continue;
            if (++i == argv.length) {
                System.err.println("error: Missing argument to -a option.");
            }
            this.adapterName = argv[i];
            this.createAdapter();
        }
        this.features.setFeatureStates(argv);
    }

    private void bind() {
        this.createParser();
        this.createAdapter();
        this.setHandlers();
        this.features.setFeatures(this.parser);
    }

    private void createParser() {
        if (this.parser != null) {
            return;
        }
        try {
            this.parser = XMLReaderFactory.createXMLReader(this.parserName);
        }
        catch (SAXException e) {
            System.err.println("error: Unable to instantiate parser (" + this.parserName + ")");
        }
    }

    private void createAdapter() {
        if (this.adapter != null) {
            return;
        }
        try {
            this.adapter = (XMLHandlerAdapter)Class.forName(this.adapterName).newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.println("error: Unable to instantiate XMLHandlerAdpater (" + this.adapterName + ")");
        }
        catch (InstantiationException e) {
            System.err.println("error: Unable to instantiate XMLHandlerAdpater (" + this.adapterName + ")");
        }
        catch (IllegalAccessException e) {
            System.err.println("error: Unable to instantiate XMLHandlerAdpater (" + this.adapterName + ")");
        }
    }

    private void setHandlers() {
        this.parser.setDTDHandler(this.adapter);
        this.parser.setErrorHandler(this.adapter);
        this.parser.setContentHandler(this.adapter);
        try {
            this.parser.setProperty(DECLARATION_HANDLER_PROPERTY_ID, this.adapter);
        }
        catch (SAXException e) {
            e.printStackTrace(System.err);
        }
        try {
            this.parser.setProperty(LEXICAL_HANDLER_PROPERTY_ID, this.adapter);
        }
        catch (SAXException e) {
            e.printStackTrace(System.err);
        }
    }

    public void parse(String xmlFile) {
        this.bind();
        try {
            System.out.println("Parsing with the following:");
            this.printActual();
            this.parser.parse(xmlFile);
            System.out.println("Done: no problems found.");
        }
        catch (SAXException e) {
            System.err.println("error: Parse error occurred - " + e.getMessage());
            Exception nested = e.getException();
            if (nested != null) {
                nested.printStackTrace(System.err);
            } else {
                e.printStackTrace(System.err);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void usage() {
        System.err.println("usage: java org.crosswire.common.xml.XMLProcess (options) uri");
        System.err.println();
        System.err.println("options:");
        this.printUsage();
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        this.printDefaults();
    }

    public void printUsage() {
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -a name     Select XMLHandlerAdapter by name.");
        this.features.printUsage();
    }

    public void printDefaults() {
        System.err.println("Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.println("Handler:    org.crosswire.common.xml.XMLHandlerAdapter");
        System.err.println(new XMLFeatureSet().toString());
    }

    public void printActual() {
        System.err.println("Parser:     " + this.parserName);
        System.err.println("Handler:    " + this.adapterName);
        System.err.println(new XMLFeatureSet().toString());
    }
}

