/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import org.crosswire.bibledesktop.desktop.Msg;
import org.crosswire.bibledesktop.display.URIEvent;
import org.crosswire.bibledesktop.display.URIEventListener;
import org.crosswire.common.progress.swing.JobsProgressBar;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.OSType;

public class StatusBar
extends JComponent
implements MouseListener,
URIEventListener {
    private JobsProgressBar panelProgress = new JobsProgressBar(true);
    protected JLabel labelMessage = new JLabel();
    private static final long serialVersionUID = 3546920264718955568L;

    public StatusBar() {
        this.initialize();
    }

    private void initialize() {
        this.labelMessage.setText(Msg.STATUS_DEFAULT.toString());
        Font font = this.panelProgress.getFont();
        this.panelProgress.setFont(font.deriveFont(6.0f));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        JSeparator separator = new JSeparator(1);
        int finalPadX = 0;
        int finalPadY = 0;
        if (OSType.MAC.equals((Object)OSType.getOSType())) {
            finalPadX = 20;
            finalPadY = 5;
        }
        this.add((Component)this.labelMessage, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)separator, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 22, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.panelProgress, new GridBagConstraints(2, 0, 1, 1, 0.7, 0.0, 22, 1, new Insets(0, 0, 0, 0), finalPadX, finalPadY));
        GuiUtil.applyDefaultOrientation((Component)this);
    }

    public void activateURI(URIEvent ev) {
    }

    public void enterURI(URIEvent ev) {
        String protocol = ev.getScheme();
        String uri = ev.getURI();
        if (protocol.length() == 0) {
            this.labelMessage.setText(uri);
        } else {
            this.labelMessage.setText(protocol + "://" + uri);
        }
    }

    public void leaveURI(URIEvent ev) {
        this.labelMessage.setText(Msg.STATUS_DEFAULT.toString());
    }

    public void setText(String txt) {
        if (txt == null) {
            this.labelMessage.setText(Msg.STATUS_DEFAULT.toString());
        } else {
            this.labelMessage.setText(txt);
        }
    }

    public void mouseEntered(MouseEvent ev) {
        Object value;
        AbstractButton button;
        Action action;
        if (ev.getSource() instanceof AbstractButton && (action = (button = (AbstractButton)ev.getSource()).getAction()) != null && (value = action.getValue("LongDescription")) != null) {
            this.labelMessage.setText(value.toString());
        }
    }

    public void mouseExited(MouseEvent ev) {
        this.labelMessage.setText(Msg.STATUS_DEFAULT.toString());
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mousePressed(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent ev) {
    }
}

