/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.crosswire.common.swing.GuiUtil;

public class FormPane
extends JPanel {
    private static final String SUFFIX_COMP = "_comp";
    private static final String SUFFIX_LABEL = "_label";
    private static final long serialVersionUID = 3258135738867790641L;
    private JPanel inner;
    protected Hashtable comps = new Hashtable();

    public FormPane() {
        this.setLayout(new BorderLayout());
        this.inner = new JPanel(new GridBagLayout());
        this.add((Component)this.inner, "North");
        this.setBorder(BorderFactory.createEmptyBorder());
        this.inner.setBorder(BorderFactory.createEmptyBorder());
        GuiUtil.applyDefaultOrientation(this);
    }

    public void addEntry(String prompt, String tooltip, Component comp) {
        JLabel label = new JLabel(prompt);
        label.setToolTipText(tooltip);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 22;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        this.inner.add((Component)label, c);
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.inner.add(comp, c);
        this.comps.put(prompt + SUFFIX_LABEL, label);
        this.comps.put(prompt + SUFFIX_COMP, comp);
    }

    public void removeEntry(String prompt) {
        JLabel label = (JLabel)this.comps.get(prompt + SUFFIX_LABEL);
        Component comp = (Component)this.comps.get(prompt + SUFFIX_COMP);
        this.inner.remove(label);
        this.inner.remove(comp);
        this.comps.remove(prompt + SUFFIX_LABEL);
        this.comps.remove(prompt + SUFFIX_COMP);
    }

    public boolean isEmpty() {
        return this.comps.size() == 0;
    }

    public String[] getFieldNames() {
        int count = this.getComponentCount() / 2;
        String[] list = new String[count];
        for (int i = 0; i < count; ++i) {
            JLabel label = (JLabel)this.getComponent(i * 2);
            list[i] = label.getText();
        }
        return list;
    }

    public String[] getFieldValues() {
        int count = this.getComponentCount() / 2;
        String[] list = new String[count];
        for (int i = 0; i < count; ++i) {
            Component comp = this.getComponent(i * 2 + 1);
            list[i] = GuiUtil.getText(comp);
        }
        return list;
    }
}

