/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.util.Enumeration;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.crosswire.common.swing.CWOptionPane;
import org.crosswire.common.swing.GuiConvert;
import org.crosswire.common.swing.Msg;
import org.crosswire.common.swing.plaf.MetalLFCustoms;
import org.crosswire.common.swing.plaf.OtherLFCustoms;
import org.crosswire.common.swing.plaf.WindowsLFCustoms;
import org.crosswire.common.util.ClassUtil;

public final class LookAndFeelUtil {
    private static Class currentLAF;
    private static Class defaultLAF;
    private static String font;
    static final /* synthetic */ boolean $assertionsDisabled;

    private LookAndFeelUtil() {
    }

    public static void initialize() {
    }

    public static Class getLookAndFeel() {
        if (currentLAF == null) {
            return defaultLAF;
        }
        return currentLAF;
    }

    public static void setLookAndFeel(Class newLaFClass) throws InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        LookAndFeel laf = (LookAndFeel)newLaFClass.newInstance();
        if (currentLAF != null && !currentLAF.equals(newLaFClass)) {
            CWOptionPane.showMessageDialog(null, (Object)Msg.PLAF_CHANGE);
        } else {
            UIManager.setLookAndFeel(laf);
        }
        currentLAF = newLaFClass;
    }

    public static String getFont() {
        return font;
    }

    public static FontUIResource toFontUIResource() {
        return new FontUIResource(GuiConvert.string2Font(font));
    }

    public static void setFont(String font) {
        LookAndFeelUtil.font = font;
        LookAndFeelUtil.setUIFont(LookAndFeelUtil.toFontUIResource());
    }

    public static void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    private static void customizeBDLookandFeel() {
        String currentLF = UIManager.getLookAndFeel().getClass().getName();
        if (currentLF.indexOf("MetalLookAndFeel") != -1) {
            new MetalLFCustoms().initUIDefaults();
        } else if (currentLF.indexOf("WindowsLookAndFeel") != -1) {
            new WindowsLFCustoms().initUIDefaults();
        } else {
            new OtherLFCustoms().initUIDefaults();
        }
    }

    static {
        block9: {
            $assertionsDisabled = !LookAndFeelUtil.class.desiredAssertionStatus();
            font = "Dialog-PLAIN-12";
            defaultLAF = MetalLookAndFeel.class;
            String systemLAF = UIManager.getSystemLookAndFeelClassName();
            try {
                if (systemLAF.indexOf("WindowsLookAndFeel") != -1 || systemLAF.indexOf("AquaLookAndfeel") != -1) {
                    UIManager.setLookAndFeel(systemLAF);
                    defaultLAF = ClassUtil.forName((String)systemLAF);
                }
            }
            catch (ClassNotFoundException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (InstantiationException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (IllegalAccessException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (UnsupportedLookAndFeelException e) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        LookAndFeelUtil.customizeBDLookandFeel();
    }
}

