/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.GuiUtil;

public class CWOptionPane
extends JOptionPane {
    static ActionFactory actions = new ActionFactory(CWOptionPane.class, null);
    private static final long serialVersionUID = -1870422750863765033L;

    public CWOptionPane() {
        this("CWOptionPane message", -1, -1, null, null, null);
    }

    public CWOptionPane(Object message) {
        this(message, -1, -1, null, null, null);
    }

    public CWOptionPane(Object message, int messageType) {
        this(message, messageType, -1, null, null, null);
    }

    public CWOptionPane(Object message, int messageType, int optionType) {
        this(message, messageType, optionType, null, null, null);
    }

    public CWOptionPane(Object message, int messageType, int optionType, Icon icon) {
        this(message, messageType, optionType, icon, null, null);
    }

    public CWOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options) {
        this(message, messageType, optionType, icon, options, null);
        GuiUtil.applyDefaultOrientation(this);
    }

    public CWOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options, Object initialValue) {
        super(message, messageType, optionType, icon, CWOptionPane.fixOptions(options, optionType, messageType), initialValue);
    }

    public static String showInputDialog(Object message) throws HeadlessException {
        return CWOptionPane.showInputDialog(null, message);
    }

    public static String showInputDialog(Object message, Object initialSelectionValue) {
        return CWOptionPane.showInputDialog(null, message, initialSelectionValue);
    }

    public static String showInputDialog(Component parentComponent, Object message) throws HeadlessException {
        return CWOptionPane.showInputDialog(parentComponent, message, "?", 3);
    }

    public static String showInputDialog(Component parentComponent, Object message, Object initialSelectionValue) {
        return (String)CWOptionPane.showInputDialog(parentComponent, message, "?", 3, null, null, initialSelectionValue);
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        return (String)CWOptionPane.showInputDialog(parentComponent, message, title, messageType, null, null, null);
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) throws HeadlessException {
        CWOptionPane pane = new CWOptionPane(message, messageType, 2, icon, null, null);
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        GuiUtil.applyDefaultOrientation(pane);
        int style = CWOptionPane.styleFromMessageType(messageType);
        JDialog dialog = pane.createDialog(parentComponent, title, style);
        pane.selectInitialValue();
        dialog.setVisible(true);
        dialog.dispose();
        Object value = pane.getInputValue();
        if (value == UNINITIALIZED_VALUE) {
            return null;
        }
        return value;
    }

    public static void showMessageDialog(Component parentComponent, Object message) throws HeadlessException {
        CWOptionPane.showOptionDialog(parentComponent, message, "?", -1, 1, null, null, null);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        CWOptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, null, null, null);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) throws HeadlessException {
        CWOptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, icon, null, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message) throws HeadlessException {
        return CWOptionPane.showOptionDialog(parentComponent, message, "?", 1, 3, null, null, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) throws HeadlessException {
        return CWOptionPane.showOptionDialog(parentComponent, message, title, optionType, 3, null, null, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) throws HeadlessException {
        return CWOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, null, null, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) throws HeadlessException {
        return CWOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, null, null);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) throws HeadlessException {
        CWOptionPane pane = new CWOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        GuiUtil.applyDefaultOrientation(pane);
        int style = CWOptionPane.styleFromMessageType(messageType);
        JDialog dialog = pane.createDialog(parentComponent, title, style);
        pane.selectInitialValue();
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        Object[] opts = pane.getOptions();
        if (opts == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        if (CWOptionPane.getActionName("Yes").equals(selectedValue)) {
            return 0;
        }
        if (CWOptionPane.getActionName("No").equals(selectedValue)) {
            return 1;
        }
        if (CWOptionPane.getActionName("OK").equals(selectedValue)) {
            return 0;
        }
        if (CWOptionPane.getActionName("CANCEL").equals(selectedValue)) {
            return 2;
        }
        int maxCounter = opts.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!opts[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    private JDialog createDialog(Component parentComponent, String title, int style) throws HeadlessException {
        boolean supportsWindowDecorations;
        Window window = GuiUtil.getWindow(parentComponent);
        final JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        dialog.setResizable(false);
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(style);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.addWindowListener(new WindowAdapter(){
            private boolean gotFocus;

            public void windowClosing(WindowEvent we) {
                CWOptionPane.this.setValue(null);
            }

            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    CWOptionPane.this.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        });
        dialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent ce) {
                CWOptionPane.this.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == CWOptionPane.this && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    dialog.setVisible(false);
                }
            }
        });
        GuiUtil.applyDefaultOrientation(dialog);
        return dialog;
    }

    private static int styleFromMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }

    private static String getActionName(String key) {
        return actions.getAction(key).getValue("Name").toString();
    }

    private static Object[] fixOptions(Object[] options, int optionType, int messageType) {
        Object[] opts = options;
        if (options == null) {
            opts = optionType == 0 ? new Object[]{CWOptionPane.getActionName("Yes"), CWOptionPane.getActionName("No")} : (optionType == 2 ? new Object[]{CWOptionPane.getActionName("OK"), CWOptionPane.getActionName("Cancel")} : (optionType == 1 && messageType != 1 ? new Object[]{CWOptionPane.getActionName("Yes"), CWOptionPane.getActionName("No"), CWOptionPane.getActionName("Cancel")} : new Object[]{CWOptionPane.getActionName("OK")}));
        }
        return opts;
    }
}

