/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopFilter;
import org.crosswire.jsword.book.Book;

public abstract class AbstractBookAnalyzer
extends Analyzer {
    protected Book book;
    protected Set stopSet;
    protected boolean doStopWords;
    protected boolean doStemming;
    protected String naturalLanguage;

    public AbstractBookAnalyzer() {
        this(null);
    }

    public AbstractBookAnalyzer(Book book) {
        this.book = book;
        this.doStopWords = false;
        this.doStemming = true;
        this.naturalLanguage = null;
    }

    public void setBook(Book newBook) {
        this.book = newBook;
    }

    public Book getBook() {
        return this.book;
    }

    public void setDoStopWords(boolean doIt) {
        this.doStopWords = doIt;
    }

    public boolean getDoStopWords() {
        return this.doStopWords;
    }

    public void setStopWords(String[] stopWords) {
        this.stopSet = StopFilter.makeStopSet((String[])stopWords);
    }

    public void setDoStemming(boolean stemming) {
        this.doStemming = stemming;
    }

    public void setNaturalLanguage(String lang) {
        this.naturalLanguage = lang;
    }

    public String getNaturalLanguage() {
        return this.naturalLanguage;
    }
}

