/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.index.lucene.IndexMetadata;
import org.crosswire.jsword.index.lucene.analysis.AbstractBookAnalyzer;
import org.crosswire.jsword.index.lucene.analysis.AnalyzerFactory;
import org.crosswire.jsword.index.lucene.analysis.KeyAnalyzer;
import org.crosswire.jsword.index.lucene.analysis.StrongsNumberAnalyzer;
import org.crosswire.jsword.index.lucene.analysis.XRefAnalyzer;

public class LuceneAnalyzer
extends Analyzer {
    private PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)new SimpleAnalyzer());

    public LuceneAnalyzer(Book book) {
        if (IndexMetadata.instance().getInstalledIndexVersion() > 1.1f) {
            AbstractBookAnalyzer myNaturalLanguageAnalyzer = AnalyzerFactory.getInstance().createAnalyzer(book);
            this.analyzer.addAnalyzer("content", (Analyzer)myNaturalLanguageAnalyzer);
        }
        this.analyzer.addAnalyzer("key", (Analyzer)new KeyAnalyzer());
        this.analyzer.addAnalyzer("strong", (Analyzer)new StrongsNumberAnalyzer());
        this.analyzer.addAnalyzer("xref", (Analyzer)new XRefAnalyzer());
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return this.analyzer.tokenStream(fieldName, reader);
    }
}

