#!/usr/bin/perl

# Diatheke/CGI 2.0 by Chris Little <chrislit@gotjesus.org>
# Copyright 1999 by Chris Little
# Licensed under GNU General Public License (GPL)
# see accompanying LICENSE file for license details

$diatheke = "/usr/bin/diatheke";  # location of diatheke command line program
$defaultfontface = "Arial, Helvetica, sans-serif"; # default font name

print "Content-type: text/html\n\n";

if ($ENV{HTTP_COOKIE}) {
    split(/=/,$ENV{HTTP_COOKIE});  #  @_ contains results
    $defversion = $_[1];
}
else {
    $defversion = 'KJV';
}

$hostname = $ENV{'REMOTE_ADDR'};
@values = split(/\&/,$ENV{'QUERY_STRING'});
$n = 0;
$arg = "-";
foreach $i (@values) {
    ($varname, $mydata) = split(/=/,$i);
    if ($varname ne "Submit" && $varname ne "lookup") {
	if ($varname eq "verse") {
	    $verse = $mydata;
	    $verse =~ tr/+/ /;
	    $verse =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	}
	elsif ($varname eq "search") {
	    $search = $mydata;
	}
	elsif ($varname eq "strongs") {
	    $arg .= "n";
	}
	elsif ($varname eq "footnotes") {
	    $arg .= "f";
	}
	elsif ($mydata eq "on" || $mydata eq "ON") {
	    $versions[$n] = $varname;
	    $n++;
	}
    }
}
print "<html>\n<title>Diatheke Interlinear Bible</title>\n<meta http-equiv=\"Content-Type\" content=\"text/html\; charset=iso-8859-1\">\n</head>\n\n<body bgcolor=\"\#FFFFFF\"><font face=\"$defaultfontface\">\n";

for ($i = 0; $i < $n; $i++) {

    if ($search eq "on") {

	$line = `$diatheke -s $versions[$i] \"$verse\" 2> /dev/null`;

    }
    else {
	if ($versions[$i] eq "MHC" || $versions[$i] eq "RWP" || $versions[$i] eq "DTN" || $versions[$i] eq "Family" || $versions[$i] eq "Geneva" || $versions[$i] eq "JFB" || $versions[$i] eq "PNT" || $versions[$i] eq "TSK") {
	    $arg .= "c";
	    $line = `$diatheke $arg $versions[$i] \"$verse\" gbf 50 2> /dev/null`;
	}
	elsif ($versions[$i] eq "Vines" || $versions[$i] eq "Naves" || $versions[$i] eq "Eastons" || $versions[$i] eq "StrongsGreek" || $versions[$i] eq "StrongsHebrew" || $versions[$i] eq "Thayer" || $versions[$i] eq "BDB" || $versions[$i] eq "Hitchcocks" || $versions[$i] eq "ISBE" || $versions[$i] eq "Smiths") {
	    $arg .= "d";
	    $line = `$diatheke $arg $versions[$i] \"$verse\" gbf 50 2> /dev/null`;
	}
	else {
	    $arg .= "b";
	    $line = `$diatheke $arg $versions[$i] \"$verse\" gbf 50 2> /dev/null`;
	}
    }
    chomp($line);

# Parse and link to Strong's references if present
    
    $line =~ s/\n/<br>/g;
    
    $line =~ s/<FI>/<i>/g;
    $line =~ s/<Fi>/<\/i>/g;
    $line =~ s/<CM>//g;
    $line =~ s/<FNgreek>/<FNBSTGreek>/g;
    $line =~ s/<FNhebrew>/<FNBSTHebrew>/g;
    $line =~ s/<FN([^>]+)>/<\/font><font face=\"$1\" size=+1>/g;
    $line =~ s/<Fn>/<\/font><font face=\"$defaultfontface\">/g;
    $line =~ s/<RF>/\(Footnote: /g;
    $line =~ s/<Rf>/\)/g;		    
    
    $line =~ s/<W\w*H([0-9]+)>+/<a href=\"diatheke.pl?verse=$1&StrongsHebrew=on\">&lt;$1&gt;\<\/a\>/g;
    $line =~ s/<W\w*G([0-9]+)>+/<a href=\"diatheke.pl?verse=$1&Submit=Submit&StrongsGreek=on\">&lt;$1&gt;\<\/a\>/g;
    
    if ($versions[$i] eq "StrongsHebrew") {
	$line =~ s/(see HEBREW for )([0-9]+)/<a href=\"diatheke.pl?verse=$2&StrongsHebrew=on\">$1$2\<\/a\>/g;
    }
    elsif($versions[$i] eq "StrongsGreek") {
	$line =~ s/(see GREEK for )([0-9]+)/<a href=\"diatheke.pl?verse=$2&StrongsGreek=on\">$1$2\<\/a\>/g;
    }
    elsif ($versions[$i] eq "BDB") {
	$line =~ s/([0-9][0-9][0-9][0-9]+)/<a href=\"diatheke.pl?verse=$1&BDB=on\">$1\<\/a\>/g;
    }
    elsif($versions[$i] eq "Thayer") {
	$line =~ s/([0-9][0-9][0-9][0-9]+)/<a href=\"diatheke.pl?verse=$1&Thayer=on\">$1\<\/a\>/g;
    }
    elsif($versions[$i] eq "MHC" || $versions[$i] eq "RWP" || $versions[$i] eq "DTN" || $versions[$i] eq "Family" || $versions[$i] eq "Geneva" || $versions[$i] eq "JFB" || $versions[$i] eq "PNT" || $versions[$i] eq "TSK" || $versions[$i] eq "Vines" || $versions[$i] eq "Naves" || $versions[$i] eq "Eastons" || $versions[$i] eq "Hitchcocks" || $versions[$i] eq "ISBE" || $versions[$i] eq "Smiths"|| $versions[$i] eq "Gill") {
	$book = $verse;
	$book =~ s/^([A-Za-z0-9]+) [0-9]+:[0-9]+.*/$1/;
	$chapter = $verse;
	$chapter =~ s/[A-Za-z0-9]+ ([0-9]+):[0-9]+.*/$1/;
	
	$line =~ s/\#*([1-9]*[A-Z][a-z]+\.*) ([0-9]+):([0-9]+-*,*[0-9]*)\|*/<a href=\"diatheke.pl?search=off&verse=$1+$2%3A$3&Submit=Submit&$defversion=on\">$1 $2:$3\<\/a\>/g;
	$line =~ s/\#([0-9]+):([0-9]+-*,*[0-9]*)\|*/<a href=\"diatheke.pl?search=off&verse=$book+$1%3A$2&Submit=Submit&$defversion=on\">$book $1:$2\<\/a\>/g;
	$line =~ s/\#([0-9]+-*,*[0-9]*)\|*/<a href=\"diatheke.pl?search=off&verse=$book+$chapter%3A$1&Submit=Submit&$defversion=on\">$book $chapter:$1\<\/a\>/g;
    }
    if ($search eq "on") {
	$line =~ s/([0-9]*[A-Za-z]+) ([0-9]+):([0-9]+)/<a href=\"diatheke.pl?search=off&verse=$1+$2%3A$3&Submit=Submit&$versions[$i]=on\">$1 $2:$3\<\/a\>/g;
    }


    if ($versions[$i] eq "JFB") {
	$line =~ s/(http:[^ ]+) /<a href="$1">$1<\/a>/g;
    }

    print "$line <br><br>\n";
}


print "</font></body></html>";
`rm /tmp/diatheke.$hostname`;

