/**********************************************************************
** Copyright (C) 2001 Trolltech AS.  All rights reserved.
**
** This file is part of the Qtopia Environment.
**
** Licensees holding valid Qtopia Developer license may use this
** file in accordance with the Qtopia Developer License Agreement
** provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
** THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE.
**
** email sales@trolltech.com for information about Qtopia License
** Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/
#ifndef QPSWORD_H
#define QPSWORD_H
#include "mainfrm.h"
//#include "qswtextview.h"
#include "qswdisplay.h"
#include <qtimer.h>
#include <vector>
#include <string>

class SWMgr;
class SWModule;
class TreeKeyIdx;



class QPSword : public MainForm { 
    Q_OBJECT

	SWMgr *mgr;
    	SWModule *currentText;
    	SWModule *currentLD;

    	QPopupMenu *modsPopup;
    	QPopupMenu *optionsPopup;
    	QPopupMenu *bookmarkPopup;
    	QPopupMenu *autoScrollPopup;
	QString	strongsHebrewLex;
	QString	strongsGreekLex;
	vector<string> bookmarks;
	bool zeroSubs;

protected:
	void jumpToVerse(int verse);
	bool gbKeyLoaded;
	void loadGBKey();
	void fillTreeTOC(TreeKeyIdx treeKey, QListView *tree, QListViewItem *parent);

public:
    QPSword( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~QPSword();

	void showTextContextMenu();
	QSWDisplay *currentDisplay;

private slots:
	void lookup();
	void showLD();
	void showSearch();
	void doSearch();
	void searchResultClick(const QString &);
	void showBook();
	void showBookKey();
	void showAbout();
	void showLocator();
	void refreshLD();
	void refreshText();
	void chooseModule(int);
	void toggleOption(int);
	void gotoBookmark(int);
	void startAutoScroll(int);
	void clearAllBookmarks();
	void addBookmark();
	void gbSelChanged(QListViewItem *);
};
#endif // EXAMPLE_H
