#include "qswdisplay.h"
#include <qtimer.h>

#include "qpsword.h"


void QSWDisplay::showContextMenu() {
		((QPSword *)topLevelWidget())->showTextContextMenu();
		((QPSword *)topLevelWidget())->currentDisplay = this;
}

QSWDisplay::QSWDisplay( QWidget *p, const char *name ) : QTextBrowser(p, name),
			menuTimer( this ), scrollTimer(this) {
		connect( &menuTimer, SIGNAL( timeout() ), SLOT( showContextMenuSlot() ) );
		connect( &scrollTimer, SIGNAL( timeout() ), SLOT( tickScrollDown() ) );
}



/*
void QSWDisplay::tickScrollDown() {
	int stepFactor = 1+(int)((autoScrollRate-1)/4);

	scrollBy( 0, stepFactor );
	scrollTimer.start( 300-(((((autoScrollRate-1)%4))*80)), TRUE );
}
*/

void QSWDisplay::tickScrollDown() {
	int stepFactor = autoScrollRate - 4;
	int interval = 60;
	if (stepFactor < 1) {
		interval = 300-((autoScrollRate-1)*80);
		stepFactor = 1;
	}

	scrollBy( 0, stepFactor );
	scrollTimer.start( interval, TRUE );
}

void QSWDisplay::startAutoScroll(int rate) {
	autoScrollRate = rate;
	scrollTimer.start( 700, TRUE );
}

void QSWDisplay::showContextMenuSlot() {
	if (hasSelectedText()) {
		if (selOnClick != selectedText()) {
			menuTimer.start( 750, TRUE );
			if (hasSelectedText())
				selOnClick = selectedText();
			else selOnClick = "";
			return;
		}
	}
	showContextMenu();
}

void QSWDisplay::viewportMousePressEvent( QMouseEvent* e )
{
    if( scrollTimer.isActive() )
	scrollTimer.stop();
    menuTimer.start( 750, TRUE );
    if (hasSelectedText())
        selOnClick = selectedText();
    else selOnClick = "";
    QTextBrowser::viewportMousePressEvent(e);
}

void QSWDisplay::viewportMouseReleaseEvent( QMouseEvent* e )
{
    cancelMenuTimer();
    QTextBrowser::viewportMouseReleaseEvent(e);
}

void QSWDisplay::cancelMenuTimer()
{
    if( scrollTimer.isActive() )
	scrollTimer.stop();

    if( menuTimer.isActive() )
	menuTimer.stop();
}

void QSWDisplay::highlighted ( const QString & href ) {
}

