#ifndef QSWDISPLAY_H
#define QSWDISPLAY_H

#include <qtextbrowser.h>
#include <qtimer.h>

class QSWDisplay : public QTextBrowser {
    Q_OBJECT
    QTimer      menuTimer;
    QTimer      scrollTimer;
    QString     selOnClick;

protected:
	virtual void showContextMenu();
	int autoScrollRate;
public:
	QSWDisplay( QWidget *p, const char *name );
	void startAutoScroll(int rate);

protected slots:
	void showContextMenuSlot();
	void tickScrollDown();

protected:
	virtual void viewportMousePressEvent( QMouseEvent* e );
	virtual void viewportMouseReleaseEvent( QMouseEvent* e );
	virtual void cancelMenuTimer();
	virtual void highlighted ( const QString & href );

};
#endif // EXAMPLE_H
