#!/usr/bin/perl

use utf8;
use Encode;
use Unicode::Normalize;

opendir (DIR, ".");
@xlits = grep /\.txt$/, readdir (DIR);

foreach $file (@xlits) {

    open (INF, "<:encoding(utf8)", $file);
    $file =~ s/\.txt$/.xml/;
    $file =~ s/\_/\-/g;
    open (OUTF, ">:encoding(utf8)", "$file");
    
    print OUTF "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE supplementalData SYSTEM \"http://www.unicode.org/cldr/dtd/1.6/ldmlSupplemental.dtd\">\n<supplementalData>\n<transforms>\n";
    
    $file =~ /^(.+?)\-(.+?)(\-(.+?))?\./;
    $source = $1;
    $target = $2;
    $variant = $4;
    
    print OUTF "<transform source=\"$source\" target=\"$target\" direction=\"both\" ";
    print "Creating $source-$target";
    if ($variant ne "") {
	print OUTF "variant=\"$variant\" ";
	print "\/$variant";
    }
    print OUTF "draft=\"provisional\">\n";
    print "\n";

    while (<INF>) {
	$line = $_;
	$line =~ s/^\x{FEFF}//;
	$line =~ s/[\t\r\n ]*$//;
	$line =~ s/^[\t\r\n ]*//;
	if ($line !~ /^[\t\r\n ]*$/) {

	    $line =~ s/([^\\])<>/$1↔/g;
	    $line =~ s/([^\\])>/$1→/g;
	    $line =~ s/([^\\])</$1←/g;

	    $line =~ s/&/&amp;/g;
	    $line =~ s/</&lt;/g;
	    $line =~ s/>/&gt;/g;

	    $line = NFD($line);

	    if ($line =~ /^\#/) {
		print OUTF "<comment>$line<\/comment>\n";
	    }
	    else {
		$line =~ s/\\u([0-9A-Fa-f]{1,6})/chr(hex($1))/eg;
		print OUTF "<tRule>$line<\/tRule>\n";
	    }
	}
    }

    print OUTF "</transform>\n</transforms>\n</supplementalData>\n";

    close (OUTF);
    close (INF);
}
