#ifndef SWMGR_H
#define SWMGR_H

#include <string>
#include <map>
#include <swmodule.h>
#include <swconfig.h>
#include <swlog.h>
#include <gbfrtf.h>
#include <rwprtf.h>

using namespace std;

typedef map <string, SWModule *, less<string> > ModMap;

class SWMgr {
private:
	SWConfig *myconfig;

	void SWMgr::CreateMods();
	void SWMgr::DeleteMods();
	SWFilter *gbftortf;
	SWFilter *rwptortf;

protected:
	virtual char AddModToConfig(int conffd, const char *fname);

public:
	
	SWConfig *config;
	ModMap Modules;

	SWMgr(SWConfig *iconfig = 0, bool autoload = true);
	~SWMgr();
	void InstallScan(const char *dir);
	void Load();
};
#endif
