/******************************************************************************
 *  swlstkey.cpp - code for base class 'SWListKey'.  SWListKey is the basis for all
 *				types of keys that have lists of specified indexes
 *				(e.g. a list of verses, place, etc.)
 */

#include <utilfuns.h>
#include <string.h>
#include <stdlib.h>
#include <swkey.h>
#include <swlstkey.h>

/******************************************************************************
 * SWListKey Constructor - initializes instance of SWListKey
 *
 * ENT:	ikey - text key
 */

SWListKey::SWListKey(const char *ikey): SWKey(ikey)
{
	arraymax = 0;
	ClearList();
}


/******************************************************************************
 * SWListKey Destructor - cleans up instance of SWListKey
 */

SWListKey::~SWListKey()
{
	ClearList();
}


/******************************************************************************
 * SWListKey::ClearList	- Clears out elements of list
 */

void SWListKey::ClearList()
{
	int loop;

	if (arraymax) {
		for (loop = 0; loop < arraycnt; loop++)
			delete [] array[loop];

		free(array);
	}
	arraymax  = 0;
	arraycnt  = 0;
	arraypos  = 0;
	array     = 0;
}


/******************************************************************************
 * SWListKey::operator = Equates this SWListKey to another SWListKey object
 *
 * ENT:	ikey - other SWListKey object
 */

SWListKey &SWListKey::operator =(SWListKey &ikey)
{
	ClearList();

	SWKey::operator =(ikey);

	for (ikey.SetToElement(0); !ikey.Error(); ikey++)
		*this << ikey;

	SetToElement(0);
	return *this;
}


/******************************************************************************
 * SWListKey::operator << - Adds an element to the list
 */

SWListKey &SWListKey::operator <<(SWKey &ikey)
{
	if (++arraycnt > arraymax) {
		array = (char **) ((array) ? realloc(array, (arraycnt + 32) * sizeof(char *)) : calloc(arraycnt + 32, sizeof(char *)));
		arraymax = arraycnt + 32;
	}

	array[arraycnt-1] = new char[ strlen(ikey) + 1 ];
	strcpy(array[arraycnt-1], ikey);

	return *this;
}



/******************************************************************************
 * SWListKey::operator =(POSITION)	- Positions this key
 *
 * ENT:	p	- position
 *
 * RET:	*this
 */

SWKey &SWListKey::operator =(POSITION p)
{
	switch (p) {
	case 1:	// GCC won't compile P_TOP
		SetToElement(0);
		break;
	case 2:	// GCC won't compile P_BOTTOM
		SetToElement(arraycnt-1);
		break;
	}
	return SWKey::operator=(p);
}


/******************************************************************************
 * SWListKey::operator += - Increments a number of elements
 */

SWKey &SWListKey::operator +=(int increment)
{
	SetToElement(arraypos+increment);
	return *this;
}


/******************************************************************************
 * SWListKey::operator -= - Decrements a number of elements
 */

SWKey &SWListKey::operator -=(int decrement)
{
	SetToElement(arraypos-decrement);
	return *this;
}


/******************************************************************************
 * SWListKey::Count	- Returns number of elements in list
 */

int SWListKey::Count()
{
	return arraycnt;
}


/******************************************************************************
 * SWListKey::SetToElement	- Sets key to element number
 *
 * ENT:	ielement	- element number to set to
 *
 * RET:	error status
 */

char SWListKey::SetToElement(int ielement)
{
	arraypos = ielement;
	if (arraypos >= arraycnt) {
		arraypos = arraycnt - 1;
		error = KEYERR_OUTOFBOUNDS;
	}
	else {
		if (arraypos < 0) {
			arraypos = 0;
			error = KEYERR_OUTOFBOUNDS;
		}
		else {
			error = 0;
			*this = array[arraypos];
		}
	}
	return error;
}
