/******************************************************************************
 *  rawstr.h   - code for class 'RawStr'- a module that reads raw text
 *				files:  ot and nt using indexs ??.bks ??.cps ??.vss
 *				and provides lookup and parsing functions based on
 *				class StrKey
 */

#ifndef RAWSTR_H
#define RAWSTR_H

class RawStr {
	static int instance;	// number of instantiated RawStr objects or derivitives
	int idxfd;
	int datfd;
	char *path;
	long lastoff;

protected:
	void getidxbuf(long ioffset, char **buf);
	void findoffset(const char *key, long *start, short *end);
	void preptext(char *buf);
	void gettext(long start, short size, char * idxbuf, char *buf);
public:
	char nl;
	RawStr(const char *ipath);
	virtual ~RawStr();
};

#endif
