/******************************************************************************
 *	swordapi.cpp	- This file contains an api usable by non-C++ windows
 *					environments
 */

#define  STRICT
#include <windows.h>
#pragma hdrstop

#include <string.h>
#include <stdio.h>

#include <rawtext.h>
#include <rawcom.h>
#include <rawld.h>
#include <strkey.h>
#include <swlstkey.h>
#include <versekey.h>
#include <swmgr.h>

#include "swordapi.h"


SWMgr mainmgr;

// Just a function to check to see if DLL is getting called correctly
void _export PASCAL YoYo(int x, int y)
{
	char buf[4096];

	sprintf(buf, "p1: %d; p2: %d", x, y);
	MessageBox(GetFocus(), buf, "Yo", MB_OK);
}


int _export PASCAL NewModule(char FAR *type, void *iparams)
{
	SWModule *rval;

	if (!type || !iparams)
		return 0;

	struct rawtextparams {
		char FAR *dir;
		char FAR *name;
		char FAR *desc;
	} *params = (struct rawtextparams *)iparams;

	struct rawcomparams {
		char FAR *dir;
		char FAR *name;
		char FAR *desc;
	};

	struct rawldparams {
		char FAR *dirfile;
		char FAR *name;
		char FAR *desc;
	};

	if (!stricmp(type, "RawText")) {
		rval = new RawText(((struct rawtextparams *)params)->dir,
					    ((struct rawtextparams *)params)->name,
					    ((struct rawtextparams *)params)->desc);
	}
	if (!stricmp(type, "RawCom")) {
		rval = new RawCom (((struct rawcomparams *)params)->dir,
					    ((struct rawcomparams *)params)->name,
					    ((struct rawcomparams *)params)->desc);
	}
	if (!stricmp(type, "RawLD")) {
		rval = new RawLD  (((struct rawldparams *)params)->dirfile,
					    ((struct rawldparams *)params)->name,
					    ((struct rawldparams *)params)->desc);
	}

	return (int)rval;
}


void _export PASCAL DeleteModule(SWModule FAR *hmod)
{
	if (hmod)
		delete hmod;
}


char _export PASCAL ModSetKeyText(SWModule FAR *mod, char FAR *key)
{
	return mod->SetKey(key);
}


char _export PASCAL ModSetKeyKey(SWModule FAR *mod, SWKey FAR *key)
{
	return mod->SetKey(*key);
}


int _export PASCAL ModGetTextLen(SWModule FAR *mod)
{
	return strlen((char *)*mod);
}


void _export PASCAL ModGetText(SWModule FAR *mod, char FAR *buf, int size)
{
	memset(buf, 0, size);
	strncpy(buf, (char *)*mod, size - 1);
}


void _export PASCAL ModGetKeyText(SWModule FAR *mod, char FAR *buf, int size)
{
	memset(buf, 0, size);
	strncpy(buf, (char *)(SWKey)*mod, size - 1);
}


int _export PASCAL ModGetKey(SWModule FAR *mod)
{
	SWKey *retval;

	retval = &((SWKey)*mod);
	return (int) retval;
}


void _export PASCAL ModInc(SWModule FAR *mod)
{
	(*mod)++;
}


void _export PASCAL ModDec(SWModule FAR *mod)
{
	(*mod)--;
}


int _export PASCAL ModSearch(SWModule FAR *mod, char FAR *stext)
{
	SWListKey *retval;

	retval = &(mod->Search(stext));
	return (int) retval;
}


int _export PASCAL ModError(SWModule FAR *mod)
{
	return (int)mod->Error();
}


/******************************************************************************
 * Key routines
 */

int _export PASCAL NewKey(char FAR *type)
{
	SWKey *rval = 0;

	if (!type)
		return 0;

	if (!stricmp(type, "VerseKey")) {
		rval = new VerseKey();
	}
	if (!stricmp(type, "StrKey")) {
		rval = new StrKey();
	}
	if (!stricmp(type, "SWListKey")) {
		rval = new SWListKey();
	}
	return (int)rval;
}


void _export PASCAL DeleteKey(SWKey FAR *hkey)
{
	if (hkey)
		delete hkey;
}


void _export PASCAL KeySetPersist(SWKey *hkey, int ipersist)
{
	hkey->Persist((char)ipersist);
}


int _export PASCAL KeyGetPersist(SWKey *hkey)
{
	return hkey->Persist();
}


int _export PASCAL KeyError(SWKey *hkey)
{
	return (int)hkey->Error();
}


void _export PASCAL KeyGetText(SWKey FAR *hkey, char FAR *buf, int size)
{
	memset(buf, 0, size);
	strncpy(buf, (char *)*hkey, size - 1);
}


void _export PASCAL KeySetText(SWKey FAR *hkey, char FAR *buf)
{
	(*hkey) = buf;
}


void _export PASCAL KeySetKey(SWKey FAR *hkey, SWKey FAR *skey)
{
	(*hkey) = (*skey);
}

void _export PASCAL KeyInc(SWKey FAR *hkey)
{
	(*hkey)++;
}


void _export PASCAL KeyDec(SWKey FAR *hkey)
{
	(*hkey)--;
}



//-------- VerseKey specifics ----------------

int _export PASCAL VerseKeyGetTestament(VerseKey *hkey)
{
	return (int)hkey->Testament();
}


int _export PASCAL VerseKeyGetBook(VerseKey *hkey)
{
	return (int)hkey->Book();
}


int _export PASCAL VerseKeyGetChapter(VerseKey *hkey)
{
	return (int)hkey->Chapter();
}


int _export PASCAL VerseKeyGetVerse(VerseKey *hkey)
{
	return (int)hkey->Verse();
}


void _export PASCAL VerseKeySetTestament(VerseKey *hkey, int val)
{
	hkey->Testament(val);
}


void _export PASCAL VerseKeySetBook(VerseKey *hkey, int val)
{
	hkey->Book(val);
}


void _export PASCAL VerseKeySetChapter(VerseKey *hkey, int val)
{
	hkey->Chapter(val);
}


void _export PASCAL VerseKeySetVerse(VerseKey *hkey, int val)
{
	hkey->Verse(val);
}


void _export PASCAL VerseKeyNormalize(VerseKey *hkey)
{
	hkey->Normalize();
}


void _export PASCAL VerseKeySetAutoNormalize(VerseKey *hkey, int val)
{
	hkey->AutoNormalize(val);
}


int _export PASCAL VerseKeyGetAutoNormalize(VerseKey *hkey)
{
	return hkey->AutoNormalize();
}


// Turn off warning: Parameter '' is never used
#pragma argsused

#if defined(__FLAT__)
BOOL WINAPI DllEntryPoint( HINSTANCE hinstDll,
					  DWORD fdwRreason,
					  LPVOID plvReserved)
{
#else /* not flat model  */
int FAR PASCAL LibMain( HINSTANCE hInstance,
				    WORD wDataSegment,
				    WORD wHeapSize,
				    LPSTR lpszCmdLine )

// The startup code for the DLL initializes the local heap(if there is one)
// with a call to LocalInit which locks the data segment.
{
    if ( wHeapSize != 0 )
	   UnlockData( 0 );
#endif /* ! __FLAT__ */
    return 1;   // Indicate that the DLL was initialized successfully.
}

// Turn off warning: Parameter '' is never used
#pragma argsused

int FAR PASCAL WEP ( int bSystemExit )
{
    return 1;
}

