/******************************************************************************
 *  rawverse.h   - code for class 'RawVerse'- a module that reads raw text
 *				files:  ot and nt using indexs ??.bks ??.cps ??.vss
 *				and provides lookup and parsing functions based on
 *				class VerseKey
 */

#ifndef RAWVERSE_H
#define RAWVERSE_H

#include <filemgr.h>

class RawVerse {
	static int instance;	// number of instantiated RawVerse objects or derivitives
	FileDesc *idxfp[2];
	FileDesc *textfp[2];
	char *path;

protected:
	void findoffset(char testmt, long idxoff, long *start, unsigned short *end);
	void preptext(char *buf);
	void gettext(char testmt, long start, unsigned short size, char *buf);
	
public:
	char nl;
	RawVerse(const char *ipath);
	virtual ~RawVerse();
};


#endif
