/******************************************************************************
 *  swlstkey.h   - code for base class 'swlstkey'.  swlstkey is the basis for all
 *	        types of keys for indexing into modules (e.g. verse, word,
 *		place, etc.)
 */

#ifndef SWLSTKEY_H
#define SWLSTKEY_H

#include <swkey.h>

class SWListKey: public SWKey {
protected:
	int arraypos;
	int arraymax;
	int arraycnt;
	char **array;
public:
	SWListKey(const char *ikey = 0);
	virtual ~SWListKey();

	virtual void ClearList();	// delete all elements
	virtual int Count();
	virtual void Remove();	// remove current element
	virtual char SetToElement(int);
	virtual SWListKey &operator <<(SWKey &); // add to list
	virtual SWListKey &operator =(SWListKey &ikey);
	virtual SWKey &operator =(const char *ikey){ return SWKey::operator =(ikey); }
	virtual SWKey &operator =(SWKey &ikey){ return SWKey::operator =(ikey); }
	virtual SWKey &operator =(POSITION);
	virtual SWKey &operator -=(int decrement);
	virtual SWKey &operator +=(int increment);
};


#endif
