//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include <swdisprtf.h>
//---------------------------------------------------------------------------
static inline SWDispRTF *ValidCtrCheck()
{
	return new SWDispRTF(NULL);
}
//---------------------------------------------------------------------------
__fastcall SWDispRTF::SWDispRTF(TComponent* Owner)
	: TRichEdit(Owner)
{

	RTFHeader     = defRTFHeader;
	RTFHeadMargin = defRTFHeadMargin;
	RTFTrailer    = defRTFTrailer;

	RTFChapterMarkPre  = defRTFChapterMarkPre;
	RTFChapterMarkPost = defRTFChapterMarkPost;

	RTFVerseMarkPre  = defRTFVerseMarkPre;
	RTFVerseMarkPost = defRTFVerseMarkPost;

	RTFVersePre  = defRTFVersePre;
	RTFVersePost = defRTFVersePost;
	
	RTFStream = new TMemoryStream();
	
	ExpandNewLine = true;	 
}

__fastcall SWDispRTF::~SWDispRTF()
{
	if (RTFStream)
		delete RTFStream;
}


void __fastcall SWDispRTF::Loaded(void)
{
	TRichEdit::Loaded();
	
	if (RTFHeader == "")
		RTFHeader = defRTFHeader;
	if (RTFTrailer == "")
		RTFTrailer = defRTFTrailer;

	if (RTFChapterMarkPre == "")
		RTFChapterMarkPre = defRTFChapterMarkPre;
	if (RTFChapterMarkPost == "")
		RTFChapterMarkPost = defRTFChapterMarkPost;

	if (RTFVerseMarkPre == "")
		RTFVerseMarkPre = defRTFVerseMarkPre;
	if (RTFVerseMarkPost == "")
		RTFVerseMarkPost = defRTFVerseMarkPost;

	if (RTFVersePre == "")
		RTFVersePre = defRTFVersePre;
	if (RTFVersePost == "")
		RTFVersePost = defRTFVersePost;
}


int __fastcall SWDispRTF::GetMySelStart()
{
	CHARRANGE cr;
	
	SendMessage(Handle, EM_EXGETSEL, 0, (long)&cr);
	return cr.cpMin;
}


void __fastcall SWDispRTF::SetMySelStart(int iselstart)
{
	CHARRANGE cr;
	
	cr.cpMin = iselstart;
	cr.cpMax = iselstart;
	SendMessage(Handle, EM_EXSETSEL, 0, (long)&cr);
}


char SWDispRTF::Display(SWModule &Module)
{
	System::AnsiString newtext, tmptext;

	newtext = RTFHeader;
	newtext = newtext + RTFHeadMargin;
	Module.Error(); // clear error;
	newtext = newtext + "\\pard \\nowidctlpar \\cf0 ";
	(char *)Module;	// force key to snap to entry before pulling out the text of the key
	newtext = newtext + RTFVerseMarkPre + Module.KeyText() + RTFVerseMarkPost;
	tmptext = "";
	for (char *loop = (char *)Module; *loop; loop++) {
		if ((*loop == '\n') && (ExpandNewLine))
			tmptext += "\\par ";
		else	tmptext += *loop;
	}
	newtext = newtext + RTFVersePre + " " + tmptext + RTFVersePost;
	newtext = newtext + RTFTrailer;
	RTFStream->Clear();
	RTFStream->WriteBuffer(newtext.c_str(), newtext.Length());
	RTFStream->Position = 0;
	Lines->LoadFromStream(RTFStream);
	return 0;
}

/*
void SWDispRTF::SetModule(SWText *imodule)
{
	FModule = imodule;
}


SWText *SWDispRTF::GetModule()
{
	return FModule;
}
*/

//---------------------------------------------------------------------------
namespace Swdisprtf
{
	void __fastcall Register()
	{
		TComponentClass classes[1] = {__classid(SWDispRTF)};
		RegisterComponents("SWORD", classes, 0);
	}
}
//---------------------------------------------------------------------------
 