/****************************************************************************** 
 *  versekey.h - code for class 'versekey'- a standard Biblical verse key
 */


#ifndef VERSEKEY_H
#define VERSEKEY_H

#include <swkey.h>
#include <swmacs.h>
#include <swlstkey.h>

struct sbook {
	char *name;		// Name of book
	unsigned char chapmax;	// Maximum chapters in book
	int *versemax;		// Array[chapmax] of maximum verses in chapters
};

struct abbrev {
	char *ab;
	int book;
};

class VerseKey : public SWKey {
	static long *offsets[2][2];
	static int offsize[2][2];
	static int instance;	// number of instantiated VerseKey objects or derivitives
	static struct sbook otbooks[];
	static struct sbook ntbooks[];
	static struct abbrev abbrevs[];
	static long otbks[];
	static long otcps[];
	static long ntbks[];
	static long ntcps[];
	static int vm[];
	static SWListKey internalListKey;
	static int getBookAbbrev(char *abbr);
	char testament;		// 0 - Old; 1 - New
	char book;
	int chapter;
	int verse;
	char autonorm;		// flag for auto normalization
	char headings;		// flag for headings on/off

	void initstatics();	// initialize and allocate books array
	void freshtext() const;	// refresh keytext based on testament|book|chapter|verse
	virtual char parse();	// Parse a character array into testament|book|chapter|verse
	int findindex(long *array, int size, long value);	// finds the index of a given value
public:
	static const char BMAX[2];
	static struct sbook *books[2];

	VerseKey(const char *ikey = 0);
	VerseKey(const SWKey *ikey);
	virtual ~VerseKey();

	virtual operator const char*() const;
	virtual SWKey &operator =(const char * ikey) {SWKey &retval = SWKey::operator =(ikey); parse(); return retval; }
	virtual SWKey &operator =(const SWKey &ikey);
	virtual SWKey &operator =(POSITION);
	virtual SWKey &operator -=(int decrement);
	virtual SWKey &operator +=(int increment);
/*
	virtual VerseKey &operator ++(int) { return *this += 1; }
	virtual VerseKey &operator --(int) { return *this -= 1; }
*/

	virtual char Testament() const;
	virtual char Book() const;
	virtual int  Chapter() const;
	virtual int  Verse() const;
	virtual char Testament(char itestament);
	virtual char Book(char ibook);
	virtual int  Chapter(int ichapter);
	virtual int  Verse(int iverse);
	virtual void Normalize(char autocheck = 0);
	virtual char AutoNormalize(char iautonorm = MAXPOS(char));
	virtual char Headings(char iheadings = MAXPOS(char));
	virtual long Index(long iindex = MAXPOS(long));

	static SWListKey &ParseVerseList(char *buf, const char *defaultKey = "Genesis 1:1");

	virtual bool operator ==(const SWKey &ikey);
	virtual bool operator  >(const SWKey &ikey);
	virtual bool operator  <(const SWKey &ikey);
};


#endif
