#ifndef FILEMGR_H
#define FILEMGR_H

class FileMgr;

class FileDesc {

friend class FileMgr;

	char *path;
	int mode;
	long offset;
	int fd;		// -77 closed;
	FileMgr *parent;
	FileDesc *next;
	
public:
	FileDesc(FileMgr *parent, char *path, int mode);
	~FileDesc();
	int getFd();
};

	
class FileMgr {

friend class FileDesc;

	FileDesc *files;
	int sysOpen(FileDesc *file);
public:
	
	FileMgr(int maxFiles = 35);
	~FileMgr();
	FileDesc *open(char *path, int mode);
	void close(FileDesc *);
	int maxFiles;

	static FileMgr systemFileMgr;
};
	
	


#endif
