/******************************************************************************
 *  swkey.h	- code for base class 'swkey'.  swkey is the basis for all
 *				types of keys for indexing into modules (e.g. verse, word,
 *				place, etc.)
 *
 * $Id: swkey.h,v 1.2 1998/12/27 01:41:59 troy Exp $
 *
 * Copyright 1998 CrossWire Bible Society (http://www.crosswire.org)
 *	CrossWire Bible Society
 *	P. O. Box 2528
 *	Tempe, AZ  85280-2528
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#ifndef SWKEY_H
#define SWKEY_H

#define KEYERR_OUTOFBOUNDS 1

// For use with = operator to position key.

class POSITION {
	char pos;
public:
	POSITION(char ipos) { pos = ipos; }
	operator char() { return pos; }
};

#define POS_TOP ((char)1)
#define POS_BOTTOM ((char)2)

#define TOP POSITION(1)
#define BOTTOM POSITION(2)

class SWKey {
protected:
	char *keytext;
	char persist;
	char error;
public:
	SWKey(const char *ikey = 0);
	virtual ~SWKey();


	char Persist() const;
	char Persist(char ikey);

	virtual char Error();
	virtual SWKey &operator =(const char *ikey);
	virtual SWKey &operator =(const SWKey &ikey);
	virtual operator const char*() const;

	virtual bool operator ==(const SWKey &ikey);
	virtual bool operator  >(const SWKey &ikey);
	virtual bool operator  <(const SWKey &ikey);
	virtual bool operator >=(const SWKey &ikey) { return ((*this > ikey) || (*this == ikey)); }
	virtual bool operator <=(const SWKey &ikey) { return ((*this < ikey) || (*this == ikey)); }
	virtual SWKey &operator =(POSITION);
	virtual SWKey &operator -=(int);
	virtual SWKey &operator +=(int);
	virtual SWKey &operator ++(int) { return *this += 1; }
	virtual SWKey &operator --(int) { return *this -= 1; }
};


#endif
