/******************************************************************************
 * swlstkey.h	- code for base class 'swlstkey'.  swlstkey is the basis for all
 *				types of keys for indexing into modules (e.g. verse, word,
 *				place, etc.)
 *
 * $Id: swlstkey.h,v 1.2 1998/12/27 01:41:59 troy Exp $
 *
 * Copyright 1998 CrossWire Bible Society (http://www.crosswire.org)
 *	CrossWire Bible Society
 *	P. O. Box 2528
 *	Tempe, AZ  85280-2528
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#ifndef SWLSTKEY_H
#define SWLSTKEY_H

#include <swkey.h>

class SWListKey: public SWKey {
protected:
	int arraypos;
	int arraymax;
	int arraycnt;
	char **array;
public:
	SWListKey(const char *ikey = 0);
	virtual ~SWListKey();

	virtual void ClearList();	// delete all elements
	virtual int Count();
	virtual void Remove();	// remove current element
	virtual char SetToElement(int);
	virtual SWListKey &operator <<(SWKey &); // add to list
	virtual SWListKey &operator =(SWListKey &ikey);
	virtual SWKey &operator =(const char *ikey){ return SWKey::operator =(ikey); }
	virtual SWKey &operator =(const SWKey &ikey){ return SWKey::operator =(ikey); }
	virtual SWKey &operator =(POSITION);
	virtual SWKey &operator -=(int decrement);
	virtual SWKey &operator +=(int increment);
};


#endif
