#ifndef TTREENODES_H
#define TTREENODES_H

#include <TTreeNode.h>
#include <TCustomTreeView.h>
#include <map>

static char * default_xpm[] = {
"1 1 2 1",
" 	c None",
".	c #FFFFFF",
"."};

/*
  TNodeCache = record
    CacheNode: TTreeNode;
    CacheIndex: Integer;
  end;
*/

typedef map <GtkTreeItem *, TTreeNode> TTreeNodeMap;

class TTreeNodes: public TPersistent {
friend class TTreeNode;
private:
//    FOwner: TCustomTreeView;
	TCustomTreeView *FOwner;
	TTreeNodeMap nodeCache;
//	function GetNode(ItemId: HTreeItem): TTreeNode;
/*
    FUpdateCount: Integer;
    FNodeCache: TNodeCache;
    procedure AddedNode(Value: TTreeNode);
    function GetHandle: HWND;
    function GetNodeFromIndex(Index: Integer): TTreeNode;
    procedure ReadData(Stream: TStream);
    procedure Repaint(Node: TTreeNode);
    procedure WriteData(Stream: TStream);
    procedure ClearCache;
  protected
    function AddItem(Parent, Target: HTreeItem; const Item: TTVItem;
      AddMode: TAddMode): HTreeItem;
    function InternalAddObject(Node: TTreeNode; const S: string;
      Ptr: Pointer; AddMode: TAddMode): TTreeNode;
    procedure DefineProperties(Filer: TFiler); override;
    function CreateItem(Node: TTreeNode): TTVItem;
    function GetCount: Integer;
    procedure SetItem(Index: Integer; Value: TTreeNode);
    procedure SetUpdateState(Updating: Boolean);
*/
	GtkTree *getSubTree(TTreeNode *node);
	GtkTreeItem *createTreeItem(GtkWidget *parent, const char *label);
public:
	TTreeNodes(TCustomTreeView *AOwner);
	virtual ~TTreeNodes();
//    procedure Clear;
	void Clear();
	TTreeNode *GetFirstNode();
	TTreeNode *GetNode(GtkTreeItem *subElement);
	GtkTreeItem *GetParentNode(GtkTreeItem *root, GtkTreeItem *subElement);
	TTreeNode *GetParentNode(TTreeNode *target);
	TTreeNode *AddChildFirst(TTreeNode *Node, const string S);
	TTreeNode *AddChild(TTreeNode *Node, const string S);
	TTreeNode *AddChildObject(TTreeNode *Node, const string S, void *Ptr);
/*
    function AddChildObjectFirst(Node: TTreeNode; const S: string;
      Ptr: Pointer): TTreeNode;
    function AddFirst(Node: TTreeNode; const S: string): TTreeNode;
    function Add(Node: TTreeNode; const S: string): TTreeNode;
    function AddObjectFirst(Node: TTreeNode; const S: string;
      Ptr: Pointer): TTreeNode;
    function AddObject(Node: TTreeNode; const S: string;
      Ptr: Pointer): TTreeNode;
    procedure Assign(Source: TPersistent); override;
    procedure BeginUpdate;
    procedure Delete(Node: TTreeNode);
    procedure EndUpdate;
    function Insert(Node: TTreeNode; const S: string): TTreeNode;
    function InsertObject(Node: TTreeNode; const S: string;
      Ptr: Pointer): TTreeNode;
    property Count: Integer read GetCount;
    property Handle: HWND read GetHandle;
    property Item[Index: Integer]: TTreeNode read GetNodeFromIndex; default;
    property Owner: TCustomTreeView read FOwner;
*/
};

#endif
