//---------------------------------------------------------------------------
#ifndef MainFrmH
#define MainFrmH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Dialogs.hpp>
#include <Menus.hpp>
#include <ExtCtrls.hpp>
#include <MPlayer.hpp>
#include <Graphics.hpp>
#include <ComCtrls.hpp>
#include <swmgr.h>
#include <ImgList.hpp>
#include <Buttons.hpp>
#include <NMFtp.hpp>
#include <NMHttp.hpp>
#include <Psock.hpp>


class VersionInfo {
	public:
	int major, minor, minor2, minor3;
	
	VersionInfo(const char *version);
	int compare(const VersionInfo &vi) const;
	bool operator>(const VersionInfo &vi) const {return (compare(vi) > 0);}
	bool operator<(const VersionInfo &vi) const {return (compare(vi) < 0);}
	bool operator==(const VersionInfo &vi) const {return (compare(vi) == 0);}
};
		

class InstallSourceTab : public TControl {
public:
	__fastcall InstallSourceTab(TComponent *Owner, const char *confEnt, const char *type);
	__fastcall ~InstallSourceTab();
	string Type;
	string Source;
	string Directory;
	string Caption;
	TTreeView *tree;
	SWMgr *mgr;
};


//---------------------------------------------------------------------------
class TMainForm : public TForm
{
	class TWebThread;
	friend class TWebThread;
__published:	// IDE-managed Components
	TMainMenu *MainMenu1;
	TMenuItem *File1;
	TMenuItem *Exit1;
	TMenuItem *Option1;
	TMenuItem *LocalPath1;
	TOpenDialog *localPathDlg;
	TPanel *Panel1;
	TMediaPlayer *MediaPlayer1;
	TImage *Image1;
	TPanel *pnlAvailable;
	TPanel *pnlInstalled;
	TSplitter *Splitter1;
	TPanel *Panel2;
	TPanel *Panel5;
	TPageControl *PageControl1;
	TTabSheet *TabSheet1;
	TTreeView *localTree;
	TPanel *Panel8;
	TPanel *Panel7;
	TPanel *Panel6;
	TTreeView *installTree;
	TTimer *Timer1;
	TLabel *Label1;
	TImageList *ImageList1;
	TPanel *Panel3;
	TImageList *ImageList2;
	TPanel *statusBar;
	TPanel *Panel4;
	TProgressBar *progressBar;
	TSpeedButton *SpeedButton2;
	TImage *Image2;
	TLabel *Label2;
	TMenuItem *ManageRemoteSources1;
	TSpeedButton *SpeedButton1;
	TSpeedButton *SpeedButton3;
	TSpeedButton *SpeedButton4;
	TSpeedButton *SpeedButton5;
	TSpeedButton *SpeedButton6;
	TSpeedButton *SpeedButton7;
	TMenuItem *View1;
	TMenuItem *LockedModules1;
	void __fastcall LocalPath1Click(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall Button5Click(TObject *Sender);
	void __fastcall localTreeDblClick(TObject *Sender);
	void __fastcall Button6Click(TObject *Sender);
	void __fastcall Image1Click(TObject *Sender);
	void __fastcall Button4Click(TObject *Sender);
	void __fastcall Button2Click(TObject *Sender);
	void __fastcall SpeedButton1Click(TObject *Sender);
	void __fastcall SpeedButton5Click(TObject *Sender);
	void __fastcall Exit1Click(TObject *Sender);
	void __fastcall FormShow(TObject *Sender);
	void __fastcall LockedModules1Click(TObject *Sender);

private:	// User declarations

	SWMgr *manager;
	SWConfig *installConf;
	const char *getLocalDir();
	void setLocalDir(const char *idir);
	void refreshPageControl();
	void addSource(InstallSourceTab *ist);
	void	fillAllSourceTrees();
	void deleteAllModules();
	
public:		// User declarations
	__fastcall TMainForm(TComponent* Owner);
	__fastcall ~TMainForm();
	void __fastcall RefreshRemoteSource(TObject *Sender);
	int selectAll(TTreeView *tree, bool sel);
	int removeModule(const char *modName);
	int installModule(const char *modName, InstallSourceTab *ist = 0);
	static int createParent(const char *pName);
	int createPathAndFile(const char *fName);
	int copyFile(const char *sourceFile, const char *targetFile);
	int copyFileToCWD(const char *sourceDir, const char *fName);
	int FTPCopy(InstallSourceTab *ist, const char *src, const char *dest, bool dirTransfer = false);
	SWMgr *localMgr;

protected:
	virtual void fillInstallTree();
	virtual void fillSourceTree(const char *sourceConf, TTreeView *tree);
};

//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
