//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "optionfrm.h"
#include <localemgr.h>
#include <list>
#include <string>
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TOptionsfrm *Optionsfrm;

const char *TOptionsfrm::defaultLocaleName = "en_us";
const char *TOptionsfrm::defaultLocaleDescription = "English (US)";
//---------------------------------------------------------------------------
__fastcall TOptionsfrm::TOptionsfrm(TComponent* Owner)
	: TForm(Owner)
{
}
//--------------------------------------------------------------------------- 
void __fastcall TOptionsfrm::ChooseColorbtnClick(TObject *Sender)
{
	ColorDialog1->Execute();
	CurrentVSColor->Brush->Color = ColorDialog1->Color;	
}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::FormCreate(TObject *Sender)
{
	list<string> locales;

	localeCB->Clear();
	localeCB->Items->AddObject(defaultLocaleDescription, (TObject *)defaultLocaleName);

	locales = LocaleMgr::systemLocaleMgr.getAvailableLocales();

	for (list<string>::iterator it = locales.begin(); it != locales.end(); it++) {
		const char *name       = LocaleMgr::systemLocaleMgr.getLocale(it->c_str())->getName();
		const char *description = LocaleMgr::systemLocaleMgr.getLocale(it->c_str())->getDescription();
		localeCB->Items->AddObject(description, (TObject *)name);
	}
	localeCB->ItemIndex = 0;
}
//---------------------------------------------------------------------------



