#ifndef TRxRichEditX_
#define TRxRichEditX_

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <RxRichEdit.hpp>
#include <ExtCtrls.hpp>
#include <swmodule.h>
#include <listkey.h>


struct RTF_FORMAT {
	AnsiString fontFace; 	// Font Name
	int chFontHeadSize;		// Chapter Name Heading Size
	int bkFontHeadSize; 	// Book Name Heading Size
	int bodyFontSize;		// Body Font Size
	int vsNumFontSize;		// VerseNumbering or Pre/Post-Fix Size
	bool prChHeadings;		// Print Heading
	bool prBookHeadings;	// Print Book Name
	bool prPreFix;			// Print Verse Prefix (James 1:19 KJV)
	bool prPostFix;		// Print Verse Postfix
	bool prVerseNum;		// Print Verse Number
	bool paragraph;		// Print Bible Text as a paragraph rather than seperate lines
	bool superVSNum;		// Verse Numbers superscripted
};

struct DISP_ATTRIBS {
	AnsiString fontName;	// Font Name (Type Dependant)
	int fontSize;			// Font Size (Type Dependant)
	bool markCurrentVerse;	// whether or not to mark current verse
	int backColor;		// Background Color (Type Dependant)
	int fontColor;		// Foreground Color (Type Dependant)
	int entryKeyColor;		// Verse Number Color (Should be type dependant but isn't yet)
	int currentVSColor;	// Current Verse Color
	int morphColor;		// MorphTags Color
	int strongsColor;		// Strongs Tags Color
	int lookupFieldColor;		// Lookup Key Fields color
};

/*
typedef struct {
	TCharRange chrg;
	PWideChar lpstrText;
} TTextRangeW;

*/
class TRxRichEditX : public TRxRichEdit {
private:
	AnsiString GetFormattedBible(SWModule* module);
	//AnsiString GetFormattedComm(SWModule* module);
	//AnsiString GetFormattedLD(SWModule* module);
	//AnsiString GetFormattedBook(SWModule* module);
	AnsiString ChapterHeading(SWModule* module, int nChapter);
	AnsiString BookHeading(SWModule* module, AnsiString name);
	AnsiString PrintEntry(SWModule* module, int nVerse);
	AnsiString PrintFix(SWModule* module);
	RTF_FORMAT format_ops;
	void buildRTFHeader();

public:
	static char platformID;
	static void TColorToRGB(const TColor& color, int& red, int& green, int& blue);

	AnsiString RTFHeader;
	AnsiString RTFHeadMargin;
	AnsiString RTFTrailer;

	AnsiString RTFChapterMarkPre;
	AnsiString RTFChapterMarkPost;

	AnsiString RTFHeadingPre;
	AnsiString RTFHeadingPost;

	AnsiString RTFVerseMarkPre;
	AnsiString RTFVerseMarkPost;

	AnsiString RTFVersePre;
	AnsiString RTFVersePost;
	DISP_ATTRIBS dispAttribs;

	TRxRichEditX(TWinControl *parent);
	int paintTo(HDC, TRect *size, int margin = 4);
	void fillWithVerses(SWModule *module, ListKey *verses, bool heading = true, bool verseNum = true, const char* type = "Default", bool stripNewlines = true);
	void fillWithRTFString(SWModule *module, const char *text, const char *type = "Default");
	void getDisplayPrefs(DISP_ATTRIBS *attribs, SWModule *module /*,const char *type = "Default"*/);
	void drawTo(HDC dc) { PaintControls(dc, 0); }
	void RenderModule(SWModule* module, RTF_FORMAT format);
	SWModule *module;
	AnsiString type;
	void recalcAppearance();
	AnsiString getType();
	static WideString Trim(WideString &src);
	WideString __fastcall GetText();
	long __fastcall TextLen();
	WideString __fastcall GetTextRange(int StartPos, int EndPos);
	WideString __fastcall WordAtCursor(void);
};

#endif  // TRxRichEditX_
