//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TModuleFonts.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "RxCombos"
#pragma resource "*.dfm"

TModuleFonts *ModuleFonts;
//---------------------------------------------------------------------------
__fastcall TModuleFonts::TModuleFonts(TComponent* Owner)
	: TForm(Owner)
{
	// Put in the RXLib Font combobox component
	cmbFontSel = new TFontComboBox(this);
	cmbFontSel->Parent = pnlFontComboBox;
	cmbFontSel->Align = alClient;
//    cmbFontSel->Font->Height = -15;
    cmbFontSel->ParentFont = true;
    cmbFontSel->UseFonts = true;
    cmbFontSel->ItemIndex = cmbFontSel->Items->IndexOf("Arial");
    cmbFontSel->OnChange = cmbFontSelChange;
}
//---------------------------------------------------------------------------
void __fastcall TModuleFonts::FormShow(TObject *Sender)
{
    FillList();
}
//---------------------------------------------------------------------------
void __fastcall TModuleFonts::viewAllClick(TObject *Sender)
{
    viewAll->Checked = true;
    viewUnicode->Checked = false;
	FillList();
}
//---------------------------------------------------------------------------
void __fastcall TModuleFonts::viewUnicodeClick(TObject *Sender)
{
   	viewUnicode->Checked = true;
    viewAll->Checked = false;
    FillList();
}
//---------------------------------------------------------------------------

void TModuleFonts::FillList()
{
	BibleCSMGR *manager;
	ModMap::iterator mods;
	TTreeNode *node;
	string nodeName;
    manager = Form1->mainmgr;

	installTree->Items->Clear();

	if (!manager->configPath)
		return;

	for (mods = manager->Modules.begin(); mods != manager->Modules.end(); mods++) {
		for (node = installTree->Items->GetFirstNode(); node; node = node->getNextSibling()) {
			if (!strcmp(node->Text.c_str(), mods->second->Type())) {
				break;
			}
		}
        if(mods->second->isUnicode() || viewAll->Checked){
			if (!node) {	// Add Section
				if (!strncmp(mods->second->Type(), "Bibl", 4))	// If Bibles, put first in list
					node = installTree->Items->AddChildFirst(0, mods->second->Type());
				else	node = installTree->Items->AddChild(0, mods->second->Type());
			}
			nodeName = "[";
			nodeName += mods->second->Name();
			nodeName += "] ";
			nodeName += mods->second->Description();
			node = installTree->Items->AddChildObject(node, nodeName.c_str(), mods->second->Name());
        }
    }
	//for (node = installTree->Items->GetFirstNode(); node; node = node->getNextSibling())
	//	node->Expand(true);
	node = installTree->Items->GetFirstNode();
	if (node)
		node->MakeVisible();

}
void __fastcall TModuleFonts::installTreeChange(TObject *Sender,
      TTreeNode *Node)
{
    TTreeNode* currNode = installTree->Selected;
	BibleCSMGR *manager;
	AnsiString modName, fontName, fontSize;
    ModMap::iterator it;
    manager = Form1->mainmgr;

    if(!currNode->HasChildren){
    	modName = currNode->Text.SubString(2, currNode->Text.Pos("]") - 2);
		it = manager->Modules.find(modName.c_str());
		fontName = (*it).second->getConfigEntry("Font");
		fontSize = (*it).second->getConfigEntry("FontSize");
	   cmbFontSel->ItemIndex = cmbFontSel->Items->IndexOf(fontName);
	   cmbSizeSel->ItemIndex = cmbSizeSel->Items->IndexOf(fontSize);
    }

}
//---------------------------------------------------------------------------

void __fastcall TModuleFonts::cmbFontSelChange(TObject *Sender)
{
    TTreeNode* currNode = installTree->Selected;
	BibleCSMGR *manager = Form1->mainmgr;
    manager->applyUserPrefs();
	AnsiString modName;
    ModMap::iterator it;
   	if(currNode && !currNode->HasChildren){
       	modName = currNode->Text.SubString(2, currNode->Text.Pos("]") - 2);
		manager->getUserPrefs()[modName.c_str()]["Font"] = cmbFontSel->Items->Strings[cmbFontSel->ItemIndex].c_str();
		currNode->Selected = true;
	}
    manager->applyUserPrefs();
}
//---------------------------------------------------------------------------

void __fastcall TModuleFonts::btnResetClick(TObject *Sender)
{
	BibleCSMGR *manager;
	SectionMap::iterator sit;
	ModMap::iterator it;
	manager = Form1->mainmgr;

	sit = manager->getUserPrefs().Sections.begin();
	while(sit != manager->getUserPrefs().Sections.end())
	{
		(*sit).second.erase("Font");
		(*sit).second.erase("FontSize");
		sit++;
	}
	manager->applyUserPrefs();
}
//---------------------------------------------------------------------------


void __fastcall TModuleFonts::cmbSizeSelChange(TObject *Sender)
{
	TTreeNode* currNode = installTree->Selected;
	BibleCSMGR *manager = Form1->mainmgr;
	manager->applyUserPrefs();
	AnsiString modName;
	ModMap::iterator it;
	if(currNode && !currNode->HasChildren){
		modName = currNode->Text.SubString(2, currNode->Text.Pos("]") - 2);
		manager->getUserPrefs()[modName.c_str()]["FontSize"] = cmbSizeSel->Items->Strings[cmbSizeSel->ItemIndex].c_str();
		currNode->Selected = true;
	}
	manager->applyUserPrefs();	
	installTree->Focused();
}
//---------------------------------------------------------------------------

