unit TntForms_Design;

interface

uses Windows, ExptIntf;

type
  TTntNewFormExpert = class(TIExpert)
  protected
    function ThisFormName: WideString; virtual; abstract;
  public
    function GetName: AnsiString; override;
    function GetAuthor: AnsiString; override;
    function GetComment: AnsiString; override;
    function GetPage: AnsiString; override;
    function GetGlyph: HICON; override;
    function GetStyle: TExpertStyle; override;
    function GetState: TExpertState; override;
    function GetIDString: AnsiString; override;
    function GetMenuText: AnsiString; override;
    procedure Execute; override;
  end;

procedure Register;

implementation

uses TntForms, DsgnIntf, EditIntf, ToolIntf;

type
  TTntNewTntFormExpert = class(TTntNewFormExpert)
  protected
    function ThisFormName: WideString; override;
  public
    function GetName: AnsiString; override;
  end;

procedure Register;
begin
  RegisterCustomModule(TTntForm{TNT-ALLOW TTntForm}, TCustomModule);
  RegisterLibraryExpert(TTntNewTntFormExpert.Create);
end;

{ TTntNewFormExpert }

function TTntNewFormExpert.GetName: AnsiString;
begin
  result := ThisFormName;
end;

function TTntNewFormExpert.GetAuthor: AnsiString;
begin
  result := 'Troy Wolbrink';
end;

function TTntNewFormExpert.GetComment: AnsiString;
begin
  result := 'Creates a new Unicode enabled TntForm';
end;

function TTntNewFormExpert.GetPage: AnsiString;
begin
  result := 'New';
end;

function TTntNewFormExpert.GetGlyph: HICON;
begin
  result := 0;
end;

function TTntNewFormExpert.GetStyle: TExpertStyle;
begin
  result := esForm;
end;

function TTntNewFormExpert.GetState: TExpertState;
begin
  result := [esEnabled];
end;

function TTntNewFormExpert.GetIDString: AnsiString;
begin
  result := 'Tnt.Create_'+ThisFormName+'.Wizard';
end;

function TTntNewFormExpert.GetMenuText: AnsiString;
begin
  result := '';
end;

procedure TTntNewFormExpert.Execute;
var
  ModuleName, FormName, FileName: AnsiString;
  ModIntf: TIModuleInterface;
begin
  ToolServices.GetNewModuleAndClassName(ThisFormName, ModuleName, FormName, FileName);
  ModIntf := ToolServices.CreateModuleEx(FileName, FormName, ThisFormName, '', nil, nil, [cmNewForm]);
  ModIntf.ShowSource;
  ModIntf.ShowForm;
  ModIntf.Release;
end;

{ TTntNewTntFormExpert }

function TTntNewTntFormExpert.ThisFormName: WideString;
begin
  result := TTntForm{TNT-ALLOW TTntForm}.ClassName;
  Delete(result, 1, 1); // drop the 'T'
end;

function TTntNewTntFormExpert.GetName: AnsiString;
begin
  result := ThisFormName + ' (Unicode)'
end;

end.
