// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Unicode.pas' rev: 5.00

#ifndef UnicodeHPP
#define UnicodeHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Unicode
{
//-- type declarations -------------------------------------------------------
typedef char UTF7;

typedef char UTF8;

typedef wchar_t UTF16;

typedef unsigned UTF32;

typedef unsigned *PUCS4;

typedef unsigned UCS4;

typedef wchar_t *PUCS2;

typedef wchar_t UCS2;

typedef unsigned *PCardinal;

#pragma option push -b-
enum Unicode__1 { sfCaseSensitive, sfIgnoreNonSpacing, sfSpaceCompress, sfWholeWordOnly };
#pragma option pop

typedef Set<Unicode__1, sfCaseSensitive, sfWholeWordOnly>  TSearchFlags;

class DELPHICLASS TSearchEngine;
class DELPHICLASS TWideStrings;
typedef void __fastcall (__closure *TConfirmConversionEvent)(TWideStrings* Sender, bool &Allowed);

class PASCALIMPLEMENTATION TWideStrings : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Classes::TStrings* FAnsiStrings;
	int FUpdateCount;
	unsigned FLanguage;
	bool FSaved;
	bool FSaveUnicode;
	TConfirmConversionEvent FOnConfirmConversion;
	WideString __fastcall GetCommaText();
	WideString __fastcall GetName(int Index);
	WideString __fastcall GetValue(const WideString Name);
	void __fastcall ReadData(Classes::TReader* Reader);
	void __fastcall SetCommaText(const WideString Value);
	void __fastcall SetValue(const WideString Name, const WideString Value);
	void __fastcall WriteData(Classes::TWriter* Writer);
	void __fastcall SetAnsiStrings(const Classes::TStrings* Value);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	void __fastcall Error(const WideString Msg, int Data);
	virtual WideString __fastcall Get(int Index) = 0 ;
	virtual int __fastcall GetCapacity(void);
	virtual int __fastcall GetCount(void) = 0 ;
	virtual System::TObject* __fastcall GetObject(int Index);
	virtual WideString __fastcall GetTextStr();
	virtual void __fastcall Put(int Index, const WideString S);
	virtual void __fastcall PutObject(int Index, System::TObject* AObject);
	virtual void __fastcall SetCapacity(int NewCapacity);
	virtual void __fastcall SetTextStr(const WideString Value);
	virtual void __fastcall SetUpdateState(bool Updating);
	virtual void __fastcall SetLanguage(unsigned Value);
	
public:
	__fastcall TWideStrings(void);
	__fastcall virtual ~TWideStrings(void);
	virtual int __fastcall Add(const WideString S);
	virtual int __fastcall AddObject(const WideString S, System::TObject* AObject);
	void __fastcall Append(const WideString S);
	virtual void __fastcall AddStrings(Classes::TStrings* Strings)/* overload */;
	virtual void __fastcall AddStrings(TWideStrings* Strings)/* overload */;
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall BeginUpdate(void);
	virtual void __fastcall Clear(void) = 0 ;
	virtual void __fastcall Delete(int Index) = 0 ;
	void __fastcall EndUpdate(void);
	bool __fastcall Equals(TWideStrings* Strings);
	virtual void __fastcall Exchange(int Index1, int Index2);
	virtual wchar_t * __fastcall GetText(void);
	virtual int __fastcall IndexOf(const WideString S);
	int __fastcall IndexOfName(const WideString Name);
	int __fastcall IndexOfObject(System::TObject* AObject);
	virtual void __fastcall Insert(int Index, const WideString S) = 0 ;
	void __fastcall InsertObject(int Index, const WideString S, System::TObject* AObject);
	virtual void __fastcall LoadFromFile(const WideString FileName);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	virtual void __fastcall Move(int CurIndex, int NewIndex);
	virtual void __fastcall SaveToFile(const WideString FileName);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	virtual void __fastcall SetText(wchar_t * Text);
	__property int Capacity = {read=GetCapacity, write=SetCapacity, nodefault};
	__property WideString CommaText = {read=GetCommaText, write=SetCommaText};
	__property int Count = {read=GetCount, nodefault};
	__property unsigned Language = {read=FLanguage, write=SetLanguage, nodefault};
	__property WideString Names[int Index] = {read=GetName};
	__property System::TObject* Objects[int Index] = {read=GetObject, write=PutObject};
	__property WideString Values[WideString Name] = {read=GetValue, write=SetValue};
	__property bool Saved = {read=FSaved, nodefault};
	__property bool SaveUnicode = {read=FSaveUnicode, write=FSaveUnicode, nodefault};
	__property WideString Strings[int Index] = {read=Get, write=Put/*, default*/};
	__property WideString Text = {read=GetTextStr, write=SetTextStr};
	__property TConfirmConversionEvent OnConfirmConversion = {read=FOnConfirmConversion, write=FOnConfirmConversion
		};
	
__published:
	__property Classes::TStrings* AnsiStrings = {read=FAnsiStrings, write=SetAnsiStrings, stored=false}
		;
};


class PASCALIMPLEMENTATION TSearchEngine : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TList* FResults;
	TWideStrings* FOwner;
	
protected:
	virtual int __fastcall GetCount(void);
	
public:
	__fastcall virtual TSearchEngine(TWideStrings* AOwner);
	__fastcall virtual ~TSearchEngine(void);
	virtual void __fastcall AddResult(unsigned Start, unsigned Stop);
	virtual void __fastcall Clear(void);
	virtual void __fastcall ClearResults(void);
	virtual void __fastcall DeleteResult(unsigned Index);
	virtual void __fastcall FindPrepare(const WideString Pattern, TSearchFlags Options) = 0 /* overload */
		;
	virtual void __fastcall FindPrepare(const wchar_t * Pattern, unsigned PatternLength, TSearchFlags Options
		) = 0 /* overload */;
	virtual bool __fastcall FindFirst(const WideString Text, unsigned &Start, unsigned &Stop) = 0 /* overload */
		;
	virtual bool __fastcall FindFirst(const wchar_t * Text, unsigned TextLen, unsigned &Start, unsigned 
		&Stop) = 0 /* overload */;
	virtual bool __fastcall FindAll(const WideString Text) = 0 /* overload */;
	virtual bool __fastcall FindAll(const wchar_t * Text, unsigned TextLen) = 0 /* overload */;
	virtual void __fastcall GetResult(unsigned Index, int &Start, int &Stop);
	__property int Count = {read=GetCount, nodefault};
};


struct TUTBMChar
{
	unsigned LoCase;
	unsigned UpCase;
	unsigned TitleCase;
} ;

typedef TUTBMChar *PUTBMChar;

struct TUTBMSkip;
typedef TUTBMSkip *PUTBMSkip;

struct TUTBMSkip
{
	TUTBMChar *BMChar;
	int SkipValues;
} ;

class DELPHICLASS TUTBMSearch;
class PASCALIMPLEMENTATION TUTBMSearch : public TSearchEngine 
{
	typedef TSearchEngine inherited;
	
private:
	TSearchFlags FFlags;
	TUTBMChar *FPattern;
	unsigned FPatternUsed;
	unsigned FPatternSize;
	unsigned FPatternLength;
	TUTBMSkip *FSkipValues;
	int FSkipsUsed;
	unsigned FMD4;
	
protected:
	void __fastcall ClearPattern(void);
	void __fastcall Compile(wchar_t * Pattern, int PatternLength, TSearchFlags Flags);
	bool __fastcall Find(wchar_t * Text, unsigned TextLen, unsigned &MatchStart, unsigned &MatchEnd);
	unsigned __fastcall GetSkipValue(wchar_t * TextStart, wchar_t * TextEnd);
	bool __fastcall Match(wchar_t * Text, wchar_t * Start, wchar_t * Stop, unsigned &MatchStart, unsigned 
		&MatchEnd);
	
public:
	__fastcall virtual TUTBMSearch(TWideStrings* AOwner);
	__fastcall virtual ~TUTBMSearch(void);
	virtual void __fastcall Clear(void);
	virtual void __fastcall FindPrepare(const WideString Pattern, TSearchFlags Options)/* overload */;
	virtual void __fastcall FindPrepare(const wchar_t * Pattern, unsigned PatternLength, TSearchFlags Options
		)/* overload */;
	virtual bool __fastcall FindFirst(const WideString Text, unsigned &Start, unsigned &Stop)/* overload */
		;
	virtual bool __fastcall FindFirst(const wchar_t * Text, unsigned TextLen, unsigned &Start, unsigned 
		&Stop)/* overload */;
	virtual bool __fastcall FindAll(const WideString Text)/* overload */;
	virtual bool __fastcall FindAll(const wchar_t * Text, unsigned TextLen)/* overload */;
};


struct TRange
{
	unsigned MinCode;
	unsigned MaxCode;
} ;

typedef TRange *PRange;

typedef DynamicArray<TRange >  Unicode__4;

struct TCClass
{
	DynamicArray<TRange >  Ranges;
	int RangesUsed;
} ;

struct TSymbol
{
	unsigned Chr;
	TCClass CCL;
} ;

struct TElement
{
	bool OnStack;
	unsigned AType;
	unsigned LHS;
	unsigned RHS;
} ;

struct TStateList;
typedef TStateList *PStateList;

typedef DynamicArray<unsigned >  Unicode__5;

struct TStateList
{
	DynamicArray<unsigned >  List;
	int ListUsed;
} ;

struct TSymbolTableEntry
{
	unsigned ID;
	unsigned AType;
	unsigned Mods;
	unsigned Props;
	TSymbol Symbol;
	TStateList States;
} ;

typedef TSymbolTableEntry *PSymbolTableEntry;

struct TState;
typedef TState *PState;

typedef DynamicArray<TElement >  Unicode__6;

struct TState
{
	unsigned ID;
	bool Accepting;
	TStateList StateList;
	DynamicArray<TElement >  Transitions;
	int TransitionsUsed;
} ;

typedef DynamicArray<TState >  Unicode__7;

struct TStateTable
{
	DynamicArray<TState >  States;
	int StatesUsed;
} ;

struct TEquivalent
{
	unsigned Left;
	unsigned Right;
} ;

typedef DynamicArray<TElement >  Unicode__8;

struct TExpressionList
{
	DynamicArray<TElement >  Expressions;
	int ExpressionsUsed;
} ;

typedef DynamicArray<TSymbolTableEntry >  Unicode__9;

struct TSymbolTable
{
	DynamicArray<TSymbolTableEntry >  Symbols;
	int SymbolsUsed;
} ;

typedef DynamicArray<TEquivalent >  Unicode__01;

struct TEquivalentList
{
	DynamicArray<TEquivalent >  Equivalents;
	int EquivalentsUsed;
} ;

struct TUREBuffer;
typedef TUREBuffer *PUREBuffer;

struct TUREBuffer
{
	bool Reducing;
	int Error;
	unsigned Flags;
	TStateList Stack;
	TSymbolTable SymbolTable;
	TExpressionList ExpressionList;
	TStateTable States;
	TEquivalentList EquivalentList;
} ;

struct TTransition
{
	unsigned Symbol;
	unsigned NextState;
} ;

struct TDFAState;
typedef TDFAState *PDFAState;

struct TDFAState
{
	bool Accepting;
	int NumberTransitions;
	int StartTransition;
} ;

typedef DynamicArray<TDFAState >  Unicode__11;

struct TDFAStates
{
	DynamicArray<TDFAState >  States;
	int StatesUsed;
} ;

typedef DynamicArray<TTransition >  Unicode__21;

struct TTransitions
{
	DynamicArray<TTransition >  Transitions;
	int TransitionsUsed;
} ;

struct TDFA
{
	unsigned Flags;
	TSymbolTable SymbolTable;
	TDFAStates StateList;
	TTransitions TransitionList;
} ;

class DELPHICLASS TURESearch;
class PASCALIMPLEMENTATION TURESearch : public TSearchEngine 
{
	typedef TSearchEngine inherited;
	
private:
	TUREBuffer FUREBuffer;
	TDFA FDFA;
	
protected:
	void __fastcall AddEquivalentPair(unsigned L, unsigned R);
	void __fastcall AddRange(TCClass &CCL, const TRange &Range);
	unsigned __fastcall AddState(const unsigned * NewStates, const int NewStates_Size);
	void __fastcall AddSymbolState(unsigned Symbol, unsigned State);
	unsigned __fastcall BuildCharacterClass(wchar_t * CP, unsigned Limit, PSymbolTableEntry Symbol);
	void __fastcall CCLSetup(PSymbolTableEntry Symbol, unsigned Mask);
	void __fastcall ClearUREBuffer(void);
	unsigned __fastcall CompileSymbol(wchar_t * S, unsigned Limit, PSymbolTableEntry Symbol);
	void __fastcall CompileURE(wchar_t * RE, unsigned RELength, bool Casefold);
	void __fastcall CollectPendingOperations(unsigned &State);
	unsigned __fastcall ConvertRE2NFA(wchar_t * RE, unsigned RELength);
	bool __fastcall ExecuteURE(unsigned Flags, wchar_t * Text, unsigned TextLen, unsigned &MatchStart, 
		unsigned &MatchEnd);
	void __fastcall ClearDFA(void);
	void __fastcall HexDigitSetup(PSymbolTableEntry Symbol, unsigned Mask);
	unsigned __fastcall MakeExpression(unsigned AType, unsigned LHS, unsigned RHS);
	unsigned __fastcall MakeHexNumber(wchar_t * NP, unsigned Limit, unsigned &Number);
	unsigned __fastcall MakeSymbol(wchar_t * S, unsigned Limit, unsigned &Consumed);
	bool __fastcall MatchesProperties(unsigned Props, unsigned C);
	void __fastcall MergeEquivalents(void);
	unsigned __fastcall ParsePropertyList(wchar_t * Properties, unsigned Limit, unsigned &Mask);
	unsigned __fastcall Peek(void);
	unsigned __fastcall Pop(void);
	unsigned __fastcall PosixCCL(wchar_t * CP, unsigned Limit, PSymbolTableEntry Symbol);
	unsigned __fastcall ProbeLowSurrogate(wchar_t * LeftState, unsigned Limit, unsigned &Code);
	void __fastcall Push(unsigned V);
	void __fastcall Reduce(unsigned Start);
	void __fastcall SpaceSetup(PSymbolTableEntry Symbol, unsigned Mask);
	bool __fastcall SymbolsAreDifferent(PSymbolTableEntry A, PSymbolTableEntry B);
	
public:
	__fastcall virtual TURESearch(TWideStrings* AOwner);
	__fastcall virtual ~TURESearch(void);
	virtual void __fastcall Clear(void);
	virtual void __fastcall FindPrepare(const WideString Pattern, TSearchFlags Options)/* overload */;
	virtual void __fastcall FindPrepare(const wchar_t * Pattern, unsigned PatternLength, TSearchFlags Options
		)/* overload */;
	virtual bool __fastcall FindFirst(const WideString Text, unsigned &Start, unsigned &Stop)/* overload */
		;
	virtual bool __fastcall FindFirst(const wchar_t * Text, unsigned TextLen, unsigned &Start, unsigned 
		&Stop)/* overload */;
	virtual bool __fastcall FindAll(const WideString Text)/* overload */;
	virtual bool __fastcall FindAll(const wchar_t * Text, unsigned TextLen)/* overload */;
};


typedef TStrings TAnsiStrings;
;

struct TWideStringItem
{
	WideString FString;
	System::TObject* FObject;
} ;

typedef DynamicArray<TWideStringItem >  TWideStringItemList;

class DELPHICLASS TWideStringList;
class PASCALIMPLEMENTATION TWideStringList : public TWideStrings 
{
	typedef TWideStrings inherited;
	
private:
	DynamicArray<TWideStringItem >  FList;
	int FCount;
	bool FSorted;
	Classes::TDuplicates FDuplicates;
	Classes::TNotifyEvent FOnChange;
	Classes::TNotifyEvent FOnChanging;
	void __fastcall ExchangeItems(int Index1, int Index2);
	void __fastcall Grow(void);
	void __fastcall QuickSort(int L, int R);
	void __fastcall InsertItem(int Index, const WideString S);
	void __fastcall SetSorted(bool Value);
	
protected:
	virtual void __fastcall Changed(void);
	virtual void __fastcall Changing(void);
	virtual WideString __fastcall Get(int Index);
	virtual int __fastcall GetCapacity(void);
	virtual int __fastcall GetCount(void);
	virtual System::TObject* __fastcall GetObject(int Index);
	virtual void __fastcall Put(int Index, const WideString S);
	virtual void __fastcall PutObject(int Index, System::TObject* AObject);
	virtual void __fastcall SetCapacity(int NewCapacity);
	virtual void __fastcall SetUpdateState(bool Updating);
	virtual void __fastcall SetLanguage(unsigned Value);
	
public:
	__fastcall virtual ~TWideStringList(void);
	virtual int __fastcall Add(const WideString S);
	virtual void __fastcall Clear(void);
	virtual void __fastcall Delete(int Index);
	virtual void __fastcall Exchange(int Index1, int Index2);
	virtual bool __fastcall Find(const WideString S, int &Index);
	virtual int __fastcall IndexOf(const WideString S);
	virtual void __fastcall Insert(int Index, const WideString S);
	virtual void __fastcall Sort(void);
	__property Classes::TDuplicates Duplicates = {read=FDuplicates, write=FDuplicates, nodefault};
	__property bool Sorted = {read=FSorted, write=SetSorted, nodefault};
	__property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
	__property Classes::TNotifyEvent OnChanging = {read=FOnChanging, write=FOnChanging};
public:
	#pragma option push -w-inl
	/* TWideStrings.Create */ inline __fastcall TWideStringList(void) : TWideStrings() { }
	#pragma option pop
	
};


struct TUNumber
{
	int Numerator;
	int Denominator;
} ;

//-- var, const, procedure ---------------------------------------------------
static const wchar_t WideNull = wchar_t(0x0);
static const wchar_t Tabulator = wchar_t(0x9);
static const wchar_t Space = wchar_t(0x20);
static const wchar_t LF = wchar_t(0xa);
static const wchar_t LineFeed = wchar_t(0xa);
static const wchar_t VerticalTab = wchar_t(0xb);
static const wchar_t FormFeed = wchar_t(0xc);
static const wchar_t CR = wchar_t(0xd);
static const wchar_t CarriageReturn = wchar_t(0xd);
extern PACKAGE WideString CRLF;
static const wchar_t LineSeparator = wchar_t(0x2028);
static const wchar_t ParagraphSeparator = wchar_t(0x2029);
static const wchar_t BOM_LSB_FIRST = wchar_t(0xfeff);
static const wchar_t BOM_MSB_FIRST = wchar_t(0xfffe);
extern PACKAGE unsigned ReplacementCharacter;
extern PACKAGE unsigned MaximumUCS2;
extern PACKAGE unsigned MaximumUTF16;
extern PACKAGE unsigned MaximumUCS4;
extern PACKAGE unsigned SurrogateHighStart;
extern PACKAGE unsigned SurrogateHighEnd;
extern PACKAGE unsigned SurrogateLowStart;
extern PACKAGE unsigned SurrogateLowEnd;
extern PACKAGE unsigned __fastcall UnicodeToUpper(unsigned Code);
extern PACKAGE unsigned __fastcall UnicodeToLower(unsigned Code);
extern PACKAGE unsigned __fastcall UnicodeToTitle(unsigned Code);
extern PACKAGE TUNumber __fastcall UnicodeGetNumber(unsigned Code);
extern PACKAGE int __fastcall UnicodeGetDigit(unsigned Code);
extern PACKAGE unsigned __fastcall StrLenW(wchar_t * Str);
extern PACKAGE wchar_t * __fastcall StrEndW(wchar_t * Str);
extern PACKAGE wchar_t * __fastcall StrMoveW(wchar_t * Dest, wchar_t * Source, unsigned Count);
extern PACKAGE wchar_t * __fastcall StrCopyW(wchar_t * Dest, wchar_t * Source);
extern PACKAGE wchar_t * __fastcall StrECopyW(wchar_t * Dest, wchar_t * Source);
extern PACKAGE wchar_t * __fastcall StrLCopyW(wchar_t * Dest, wchar_t * Source, unsigned MaxLen);
extern PACKAGE wchar_t * __fastcall StrPCopyW(wchar_t * Dest, const WideString Source);
extern PACKAGE wchar_t * __fastcall StrPLCopyW(wchar_t * Dest, const WideString Source, unsigned MaxLen
	);
extern PACKAGE wchar_t * __fastcall StrCatW(wchar_t * Dest, wchar_t * Source);
extern PACKAGE wchar_t * __fastcall StrLCatW(wchar_t * Dest, wchar_t * Source, unsigned MaxLen);
extern PACKAGE int __fastcall StrCompW(wchar_t * Str1, wchar_t * Str2);
extern PACKAGE int __fastcall StrICompW(wchar_t * Str1, wchar_t * Str2);
extern PACKAGE int __fastcall StrLCompW(wchar_t * Str1, wchar_t * Str2, unsigned MaxLen);
extern PACKAGE int __fastcall StrLICompW(wchar_t * Str1, wchar_t * Str2, unsigned MaxLen);
extern PACKAGE int __fastcall StrNScanW(wchar_t * S1, wchar_t * S2);
extern PACKAGE int __fastcall StrRNScanW(wchar_t * S1, wchar_t * S2);
extern PACKAGE wchar_t * __fastcall StrScanW(wchar_t * Str, wchar_t Chr)/* overload */;
extern PACKAGE wchar_t * __fastcall StrScanW(wchar_t * Str, wchar_t Chr, unsigned StrLen)/* overload */
	;
extern PACKAGE wchar_t * __fastcall StrRScanW(wchar_t * Str, wchar_t Chr);
extern PACKAGE wchar_t * __fastcall StrPosW(wchar_t * Str, wchar_t * SubStr);
extern PACKAGE wchar_t * __fastcall StrUpperW(wchar_t * Str);
extern PACKAGE wchar_t * __fastcall StrLowerW(wchar_t * Str);
extern PACKAGE wchar_t * __fastcall StrTitleW(wchar_t * Str);
extern PACKAGE wchar_t * __fastcall StrAllocW(unsigned Size);
extern PACKAGE unsigned __fastcall StrBufSizeW(wchar_t * Str);
extern PACKAGE wchar_t * __fastcall StrNewW(wchar_t * Str);
extern PACKAGE void __fastcall StrDisposeW(wchar_t * Str);
extern PACKAGE void __fastcall StrSwapByteOrder(wchar_t * Str);
extern PACKAGE WideString __fastcall WideAdjustLineBreaks(const WideString S);
extern PACKAGE WideString __fastcall WideQuotedStr(const WideString S, wchar_t Quote);
extern PACKAGE WideString __fastcall WideExtractQuotedStr(wchar_t * &Src, wchar_t Quote);
extern PACKAGE WideString __fastcall WideStringOfChar(wchar_t C, unsigned Count);
extern PACKAGE WideString __fastcall WideTrim(const WideString S);
extern PACKAGE WideString __fastcall WideTrimLeft(const WideString S);
extern PACKAGE WideString __fastcall WideTrimRight(const WideString S);
extern PACKAGE int __fastcall WideCharPos(const WideString S, const wchar_t Ch, const int Index);
extern PACKAGE WideString __fastcall WideCompose(const WideString S);
extern PACKAGE WideString __fastcall WideComposeHangul(WideString Source);
extern PACKAGE WideString __fastcall WideDecompose(const WideString S);
extern PACKAGE wchar_t __fastcall WideLoCase(wchar_t C);
extern PACKAGE WideString __fastcall WideLowerCase(const WideString S);
extern PACKAGE wchar_t __fastcall WideTitleCaseChar(wchar_t C);
extern PACKAGE WideString __fastcall WideTitleCaseString(const WideString S);
extern PACKAGE wchar_t __fastcall WideUpCase(wchar_t C);
extern PACKAGE WideString __fastcall WideUpperCase(const WideString S);
extern PACKAGE bool __fastcall UnicodeIsAlpha(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsDigit(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsAlphaNum(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsControl(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsSpace(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsWhiteSpace(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsBlank(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsPunctuation(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsGraph(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsPrintable(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsUpper(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsLower(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsTitle(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsHexDigit(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsIsoControl(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsFormatControl(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsSymbol(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsNumber(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsNonSpacing(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsOpenPunctuation(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsClosePunctuation(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsInitialPunctuation(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsFinalPunctuation(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsComposite(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsQuotationMark(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsSymmetric(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsMirroring(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsNonBreaking(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsRTL(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsLTR(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsStrong(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsWeak(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsNeutral(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsSeparator(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsMark(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsModifier(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsLetterNumber(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsConnectionPunctuation(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsDash(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsMath(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsCurrency(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsModifierSymbol(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsNonSpacingMark(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsSpacingMark(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsEnclosing(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsPrivate(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsSurrogate(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsLineSeparator(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsParagraphSeparator(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsIdenifierStart(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsIdentifierPart(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsDefined(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsUndefined(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsHan(unsigned C);
extern PACKAGE bool __fastcall UnicodeIsHangul(unsigned C);
extern PACKAGE int __fastcall CodePageFromLocale(unsigned Language);
extern PACKAGE Word __fastcall KeyboardCodePage(void);
extern PACKAGE wchar_t __fastcall KeyUnicode(char C);
extern PACKAGE unsigned __fastcall CodeBlockFromChar(const wchar_t C);
extern PACKAGE WideString __fastcall CodePageToWideString(AnsiString A, Word CodePage);
extern PACKAGE AnsiString __fastcall WideStringToUTF8(WideString S);
extern PACKAGE WideString __fastcall UTF8ToWideString(AnsiString S);

}	/* namespace Unicode */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Unicode;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Unicode
