//---------------------------------------------------------------------------
#include "BibleCSMGR.h"
#include <swconfig.h>
#include <markupfiltmgr.h>
#ifdef _ICU_
//#include <utf8arshaping.h>
#include <utf8bidireorder.h>
#include <utf8transliterator.h>
#endif
//---------------------------------------------------------------------------
BibleCSMGR::BibleCSMGR(TModInstFrm *iModInstFrm) : SWMgr(0, 0, false, new MarkupFilterMgr(FMT_RTF, ENC_RTF))
{
#ifdef _ICU_
//        arshaping = new UTF8arShaping();
	bidireorder = new UTF8BiDiReorder();
//	   transliterator = new UTF8Transliterator();
#endif
	ModInstFrm = iModInstFrm;
	userPrefs = 0;
	Load();

	OSVERSIONINFO osvi;
	memset(&osvi, 0, sizeof(OSVERSIONINFO));
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&osvi);
	platformID = osvi.dwPlatformId;
}


BibleCSMGR::~BibleCSMGR()
{
#ifdef _ICU_
//        if (arshaping)
//                delete arshaping;
	   if (bidireorder)
			 delete bidireorder;
//	   if (transliterator)
//			 delete transliterator;
#endif
	if (userPrefs) {
		userPrefs->Save();
		delete userPrefs;
	}
}


void BibleCSMGR::AddRenderFilters(SWModule *module, ConfigEntMap &section)
{
	string lang;
	ConfigEntMap::iterator entry;

	lang = ((entry = section.find("Lang")) != section.end()) ? (*entry).second : (string)"en";

	   if (module->Direction() == DIRECTION_RTL) {
#ifdef _ICU_
//                if (!strnicmp(lang.c_str(), "ar", 2)) {
//                        module->AddRenderFilter(arshaping);
//                }
			 if (platformID == WIN9X || (strnicmp(lang.c_str(), "he", 2) && strnicmp(lang.c_str(), "ar", 2))) {
				    module->AddRenderFilter(bidireorder);

			 }
#endif
	   }
	   SWMgr::AddRenderFilters(module, section);
}


char BibleCSMGR::AddModToConfig(int conffd, const char *fname)
{
	SWConfig modconf(fname);
	SectionMap::iterator section;
	AnsiString abouttext = "";
	int logflag;
	TMemoryStream *RTFStream = new TMemoryStream();
	char retval;

	section = modconf.Sections.begin();

	ModInstFrm->ModText->Caption = "";
	ModInstFrm->ModText->Caption = ModInstFrm->ModText->Caption + "Found new module [ " + (*(*section).second.find("Description")).second.c_str() + " ]. Installing...";

	abouttext = abouttext + "{\\fs20\\cf0 " + (*(*section).second.find("About")).second.c_str() + " }";
	RTFStream->Clear();
	RTFStream->WriteBuffer(abouttext.c_str(), abouttext.Length());
	RTFStream->Position = 0;
	ModInstFrm->AboutText->Lines->LoadFromStream(RTFStream);
	delete RTFStream;

	ModInstFrm->ShowModal();

	logflag = SWLog::systemlog->getLogLevel();
	SWLog::systemlog->setLogLevel(0);
	retval = SWMgr::AddModToConfig(conffd, fname);
	SWLog::systemlog->setLogLevel(logflag);

	return retval;
}

signed char BibleCSMGR::Load () {
	signed char retval = SWMgr::Load();
#ifdef _ICU_
//	optionFilters.insert(FilterMap::value_type("UTF8Transliterator", transliterator));
//	options.push_back(transliterator->getOptionName());
#endif
	userPrefs = new SWConfig("./userprefs.conf");
	applyUserPrefs();
	return retval;
};

void BibleCSMGR::applyUserPrefs() {
	(*config) += (*userPrefs);
}

void BibleCSMGR::AddGlobalOptions (SWModule * module, ConfigEntMap & section,
							ConfigEntMap::iterator start,
							ConfigEntMap::iterator end) {

	   SWMgr::AddGlobalOptions(module, section, start, end);
#ifdef _ICU_
//	   module->AddOptionFilter(transliterator);
#endif
};

/*	maybe force a section for each module and set a per module userConfig. "But not like this.  Not like this."
void BibleCSMGR::AddLocalOptions(SWModule *module, ConfigEntMap &section, ConfigEntMap::iterator start, ConfigEntMap::iterator end)
{
	userPrefs[module->Name()]["Font"];
}
*/
