//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include <localemgr.h>
#include <list>
#include <string>
#include <dirent.h>
#include <io.h>
#include <dir.h>
#include "TModuleFonts.h"
#include "optionfrm.h"
#include "mainfrm.h"


//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TOptionsfrm *Optionsfrm;

const char *TOptionsfrm::defaultLocaleName = "en_us";
const char *TOptionsfrm::defaultLocaleDescription = "English (US)";
//---------------------------------------------------------------------------
__fastcall TOptionsfrm::TOptionsfrm(TComponent* Owner)
	: TForm(Owner)
{
	FontDialogText = new TFontSelFrm(this);
	FontDialogComment = new TFontSelFrm(this);
	FontDialogLD = new TFontSelFrm(this);
	FontDialogPopup = new TFontSelFrm(this);
	FontDialogSearch = new TFontSelFrm(this);
}
//--------------------------------------------------------------------------- 
void __fastcall TOptionsfrm::btnCurrVerseClick(TObject *Sender)
{
	ColorDialogVS->Execute();
	shpCurrVSClr->Brush->Color = ColorDialogVS->Color;
	UpdatePreview();
}
//---------------------------------------------------------------------------

//DONE -oDavid 1 -cOptions: add per module font size selection
//DONE 1 -cOptions: add 'general' dictionary besides strongs for lookups of words
//TODO 1 -cOptions: add Individual Modules per module 'general' dictionary selection and support so different dictionaries can be chosen for, say: Chinese and KJV and Thai, etc.

void __fastcall TOptionsfrm::FormCreate(TObject *Sender)
{
	list<string> locales;

	localeCB->Clear();
	localeCB->Items->AddObject(defaultLocaleDescription, (TObject *)defaultLocaleName);

	locales = LocaleMgr::systemLocaleMgr.getAvailableLocales();

	for (list<string>::iterator it = locales.begin(); it != locales.end(); it++) {
		const char *name       = LocaleMgr::systemLocaleMgr.getLocale(it->c_str())->getName();
		const char *description = LocaleMgr::systemLocaleMgr.getLocale(it->c_str())->getDescription();
		localeCB->Items->AddObject(description, (TObject *)name);
	}
	localeCB->ItemIndex = 0;
}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::FormShow(TObject *Sender)
{
	PageControl1->ActivePage = TabSheet1;
	FindSchemeNames();
	cmbTextSelect->ItemIndex = 0;
	UpdatePreview();
}



void __fastcall TOptionsfrm::btnFontClick(TObject *Sender)
{

	TFontSelFrm* tempFrm = new TFontSelFrm(this);
	switch (cmbTextSelect->ItemIndex)
	{
	case 0:
		CopyFontDlg(tempFrm, FontDialogText);
		if(FontDialogText->ShowModal() == mrOk){
			CopyFontDlg(FontDialogComment, FontDialogText);
			CopyFontDlg(FontDialogLD, FontDialogText);
			CopyFontDlg(FontDialogPopup, FontDialogText);
			UpdatePreview();
		}else CopyFontDlg(FontDialogText, tempFrm);
		break;
	case 1:
		CopyFontDlg(tempFrm, FontDialogText);
		if(FontDialogText->ShowModal() == mrOk)
			UpdatePreview();
		else CopyFontDlg(FontDialogText, tempFrm);
		break;
	case 2:
		CopyFontDlg(tempFrm, FontDialogComment);
		if(FontDialogComment->ShowModal() == mrOk)
			UpdatePreview();
		else CopyFontDlg(FontDialogComment, tempFrm);
		break;
	case 3:
		CopyFontDlg(tempFrm, FontDialogLD);
		if(FontDialogLD->ShowModal() == mrOk)
			UpdatePreview();
		else	CopyFontDlg(FontDialogLD, tempFrm);
		break;
	case 4:
		CopyFontDlg(tempFrm, FontDialogPopup);
		if(FontDialogPopup->ShowModal() == mrOk)
			UpdatePreview();
		else	CopyFontDlg(FontDialogPopup, tempFrm);
		break;
	case 5:
		CopyFontDlg(tempFrm, FontDialogSearch);
		if(FontDialogSearch->ShowModal() == mrOk)
			UpdatePreview();
		else	CopyFontDlg(FontDialogSearch, tempFrm);
		break;
	}
	delete tempFrm;
}
//---------------------------------------------------------------------------

void __fastcall TOptionsfrm::shpCurrVSClrMouseDown(TObject *Sender,
	 TMouseButton Button, TShiftState Shift, int X, int Y)
{
	btnCurrVerseClick(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TOptionsfrm::btnNumClrClick(TObject *Sender)
{
	ColorDialogVerseNum->Execute();
	shpNumClr->Brush->Color = ColorDialogVerseNum->Color;
	UpdatePreview();

}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::btnFieldClrClick(TObject *Sender)
{
	ColorDialogField->Execute();
	shpFieldClr->Brush->Color = ColorDialogField->Color;
	UpdatePreview();
}
//---------------------------------------------------------------------------

// DONE 1 -oDavid -cOptions: add new category, Search Results
void __fastcall TOptionsfrm::cmbTextSelectChange(TObject *Sender)
{
  UpdatePreview();
}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::cmbSchemeSelectChange(TObject *Sender)
{
	AnsiString tempName = ExtractFilePath(Application->ExeName) + COLOR_DIR + cmbSchemeSelect->Text + COLOR_EXT;
	SWConfig schemesconf(tempName.c_str());
	LoadDispSettings(&schemesconf);
	UpdatePreview();
}
//---------------------------------------------------------------------------

// TODO 1 -cOptions: Change preview to use RxRichEditX, so we're consistent with look and feel of real control
void TOptionsfrm::UpdatePreview()
{
	char buffTemp[512], buffFinal[512], font[64];
	char* verse = "Why, my beloved brothers, let every man be swift to hear, slow to speak, slow to wrath";
	int vsColorRed, vsColorGreen, vsColorBlue,  numColorRed, numColorGreen, numColorBlue;
	int fontSize;
	TMemoryStream * RTFStream = new TMemoryStream;

	strcpy(buffFinal, "{\\rtf1\\ansi");

	switch (cmbTextSelect->ItemIndex)
	{
	case 2:	// Commentary Windows
		TRxRichEditX::TColorToRGB(FontDialogComment->Font->Color, vsColorRed, vsColorGreen, vsColorBlue);
		TRxRichEditX::TColorToRGB(ColorDialogVerseNum->Color, numColorRed, numColorGreen, numColorBlue);
		strcpy(font, FontDialogComment->Font->Name.c_str());
		fontSize =  FontDialogComment->Font->Size;
		RTFPreview->Color = FontDialogComment->BackColor;
		break;
	case 3:	// Lexicon/Dictionary Windows
		TRxRichEditX::TColorToRGB(FontDialogLD->Font->Color, vsColorRed, vsColorGreen, vsColorBlue);
		TRxRichEditX::TColorToRGB(ColorDialogVerseNum->Color, numColorRed, numColorGreen, numColorBlue);
		strcpy(font, FontDialogLD->Font->Name.c_str());
		fontSize =  FontDialogLD->Font->Size;
		RTFPreview->Color = FontDialogLD->BackColor;
		break;
	case 4:	// Popup Windows
		TRxRichEditX::TColorToRGB(FontDialogPopup->Font->Color, vsColorRed, vsColorGreen, vsColorBlue);
		TRxRichEditX::TColorToRGB(ColorDialogVerseNum->Color, numColorRed, numColorGreen, numColorBlue);
		strcpy(font, FontDialogPopup->Font->Name.c_str());
		fontSize =  FontDialogPopup->Font->Size;
		RTFPreview->Color = FontDialogPopup->BackColor;
		break;
	case 5:	// Search Result Windows
		TRxRichEditX::TColorToRGB(FontDialogSearch->Font->Color, vsColorRed, vsColorGreen, vsColorBlue);
		TRxRichEditX::TColorToRGB(ColorDialogVerseNum->Color, numColorRed, numColorGreen, numColorBlue);
		strcpy(font, FontDialogSearch->Font->Name.c_str());
		fontSize =  FontDialogSearch->Font->Size;
		RTFPreview->Color = FontDialogSearch->BackColor;
		break;
	default: 	// Bible Windows
		TRxRichEditX::TColorToRGB(FontDialogText->Font->Color, vsColorRed, vsColorGreen, vsColorBlue);
		TRxRichEditX::TColorToRGB(ColorDialogVerseNum->Color, numColorRed, numColorGreen, numColorBlue);
		strcpy(font, FontDialogText->Font->Name.c_str());
		fontSize =  FontDialogText->Font->Size;
		RTFPreview->Color = FontDialogText->BackColor;
	}

	// This is a strange way to deal with font size but I can't think of a different way to do it.
	// So for now I will use the current system.
	fontSize -= 12;
	sprintf(buffTemp, "{\\fonttbl{\\f0\\fdecor\\fprq2 %s;}}" , font);
	strcat(buffFinal, buffTemp);
	sprintf(buffTemp, "{\\colortbl;\\red%d\\green%d\\blue%d;\\red%d\\green%d\\blue%d;}" , vsColorRed, vsColorGreen, vsColorBlue,  numColorRed, numColorGreen, numColorBlue);
	strcat(buffFinal, buffTemp);

	sprintf(buffTemp, "\\pard \\qc\\nowidctlpar{\\f1\\fs%d\\cf1\\b Chapter 1 ", (30 + fontSize));
	strcat(buffFinal, buffTemp);
	sprintf(buffTemp, "\\par\\fs%d\\par}", (10 + fontSize));
	strcat(buffFinal, buffTemp);

	sprintf(buffTemp, "{\\fs%d\\cf2\\super 19}", (10 + fontSize));
	strcat(buffFinal, buffTemp);

	sprintf(buffTemp, "\\ql\\nowidctlpar \\cf1\\f0\\fs%d ", (24 + fontSize));
	strcat(buffFinal, buffTemp);
	strcat(buffFinal, verse);

	strcat(buffFinal, " }");

	RTFStream->WriteBuffer(buffFinal, 512);
	RTFStream->Position = 0;
	RTFPreview->Lines->LoadFromStream(RTFStream);
	GetCurrentScheme();
}

TOptionsfrm::CopyFontDlg(TFontSelFrm* lhs, const TFontSelFrm* rhs)
{
	lhs->BackColor = rhs->BackColor;
	lhs->Font->Color = rhs->Font->Color;
	lhs->Font->Size = rhs->Font->Size;
	lhs->Font->Name = rhs->Font->Name;
}

void __fastcall TOptionsfrm::btnSaveScheme(TObject *Sender)
{
	TPoint menup, point;
	point.x = 0;
	point.y = btnSave->Height;
	menup = btnSave->ClientToScreen(point);
	SavePopup->Popup(menup.x, menup.y);
}
//---------------------------------------------------------------------------

void __fastcall TOptionsfrm::SaveSchemeClick(TObject *Sender)
{

	ConfigEntMap emap;
	 AnsiString strName = cmbSchemeSelect->Text;
	 if(strName != "" 	&& !strName.Pos("/") 	&& !strName.Pos("\\")
		&& !strName.Pos(":") 	&& !strName.Pos("*")
		&& !strName.Pos("?")	&& !strName.Pos("\"")
		&& !strName.Pos("<")	&& !strName.Pos(">")
		&& !strName.Pos("|")) {

		AnsiString strName =  COLOR_DIR + cmbSchemeSelect->Text + COLOR_EXT;
		SWConfig schemeconf(strName.c_str());

		emap = schemeconf.Sections["Appearance"];
		emap.erase("AutoVSColor"); emap.insert(ConfigEntMap::value_type("AutoVSColor", IntToStr((AutoVSColor->Checked)?1:0).c_str()));
		emap.erase("CurrentVSColor"); emap.insert(ConfigEntMap::value_type("CurrentVSColor", IntToStr(shpCurrVSClr->Brush->Color).c_str()));
		emap.erase("VSNumberColor"); emap.insert(ConfigEntMap::value_type("VSNumberColor", IntToStr(ColorDialogVerseNum->Color).c_str()));
		emap.erase("FieldColor"); emap.insert(ConfigEntMap::value_type("FieldColor", IntToStr(ColorDialogField->Color).c_str()));
		emap.erase("StrongsColor"); emap.insert(ConfigEntMap::value_type("StrongsColor", IntToStr(ColorDialogStrongs->Color).c_str()));
		emap.erase("MorphColor"); emap.insert(ConfigEntMap::value_type("MorphColor", IntToStr(ColorDialogMorph->Color).c_str()));

		emap.erase("TextBackColor"); emap.insert(ConfigEntMap::value_type("TextBackColor", IntToStr(FontDialogText->BackColor).c_str()));
		emap.erase("CommentBackColor"); emap.insert(ConfigEntMap::value_type("CommentBackColor", IntToStr(FontDialogComment->BackColor).c_str()));
		emap.erase("LDBackColor"); emap.insert(ConfigEntMap::value_type("LDBackColor", IntToStr(FontDialogLD->BackColor).c_str()));
		emap.erase("PopupBackColor"); emap.insert(ConfigEntMap::value_type("PopupBackColor", IntToStr(FontDialogPopup->BackColor).c_str()));
		emap.erase("SearchBackColor"); emap.insert(ConfigEntMap::value_type("SearchBackColor", IntToStr(FontDialogSearch->BackColor).c_str()));

		emap.erase("TextFontName"); emap.insert(ConfigEntMap::value_type("TextFontName", (FontDialogText->Font->Name).c_str()));
		emap.erase("CommentFontName"); emap.insert(ConfigEntMap::value_type("CommentFontName", (FontDialogComment->Font->Name).c_str()));
		emap.erase("LDFontName"); emap.insert(ConfigEntMap::value_type("LDFontName", (FontDialogLD->Font->Name).c_str()));
		emap.erase("PopupFontName"); emap.insert(ConfigEntMap::value_type("PopupFontName", (FontDialogPopup->Font->Name).c_str()));
		emap.erase("SearchFontName"); emap.insert(ConfigEntMap::value_type("SearchFontName", (FontDialogSearch->Font->Name).c_str()));

		emap.erase("TextFontSize"); emap.insert(ConfigEntMap::value_type("TextFontSize", IntToStr(FontDialogText->Font->Size).c_str()));
		emap.erase("CommentFontSize"); emap.insert(ConfigEntMap::value_type("CommentFontSize", IntToStr(FontDialogComment->Font->Size).c_str()));
		emap.erase("LDFontSize"); emap.insert(ConfigEntMap::value_type("LDFontSize", IntToStr(FontDialogLD->Font->Size).c_str()));
		emap.erase("PopupFontSize"); emap.insert(ConfigEntMap::value_type("PopupFontSize", IntToStr(FontDialogPopup->Font->Size).c_str()));
		emap.erase("SearchFontSize"); emap.insert(ConfigEntMap::value_type("SearchFontSize", IntToStr(FontDialogSearch->Font->Size).c_str()));
		
		emap.erase("TextFontColor"); emap.insert(ConfigEntMap::value_type("TextFontColor", IntToStr(FontDialogText->Font->Color).c_str()));
		emap.erase("CommentFontColor"); emap.insert(ConfigEntMap::value_type("CommentFontColor", IntToStr(FontDialogComment->Font->Color).c_str()));
		emap.erase("LDFontColor"); emap.insert(ConfigEntMap::value_type("LDFontColor", IntToStr(FontDialogLD->Font->Color).c_str()));
		emap.erase("PopupFontColor"); emap.insert(ConfigEntMap::value_type("PopupFontColor", IntToStr(FontDialogPopup->Font->Color).c_str()));
		emap.erase("SearchFontColor"); emap.insert(ConfigEntMap::value_type("SearchFontColor", IntToStr(FontDialogSearch->Font->Color).c_str()));
		
		schemeconf.Sections["Appearance"] = emap;
		schemeconf.Save();
	}else{
		Application->MessageBox("Scheme name missing or invalid.","Oops", MB_OK);
	}
	SetCurrentDir(ExtractFilePath(Application->ExeName));
	FindSchemeNames();
}
//---------------------------------------------------------------------------


void TOptionsfrm::FindSchemeNames()
{
	DIR *dir;
	struct dirent *ent;
	string conffile;
	AnsiString strName;
	AnsiString strPath = COLOR_DIR;

	TStringList *schemeNames = new TStringList;
	cmbSchemeSelect->Clear();

	if (access(strPath.c_str(), 0)) {		// directory does not exist
		_mkdir(strPath.c_str());
	}

	if (dir = opendir(strPath.c_str())) {
		rewinddir(dir);
		while ((ent = readdir(dir))) {
			if ((strcmp(ent->d_name, "."))&& (strcmp(ent->d_name, "..")) && !strcmp(ExtractFileExt(ent->d_name).c_str(), COLOR_EXT.c_str())) {
				strName = ent->d_name;
				schemeNames->Add(strName.SubString(1, strName.Length() - 4).c_str());
			}
		}
		closedir(dir);
		cmbSchemeSelect->Items = schemeNames;
	}
	delete schemeNames;
}

void __fastcall TOptionsfrm::ExportClick(TObject *Sender)
{
     AnsiString name = cmbSchemeSelect->Text;
	AnsiString newFileName;
    	AnsiString exName;
    	AnsiString subdir = ExtractFilePath(Application->ExeName) + COLOR_DIR;
     if(name != ""){
     	SaveSchDlg->FileName = name;
  		if(SaveSchDlg->Execute()){
        		exName = subdir + name + COLOR_EXT;
        		newFileName = SaveSchDlg->FileName.c_str();
	   		if(!CopyFileA(exName.c_str(), newFileName.c_str(),1))
	            	Application->MessageBox("Export Failed." , "Oops", MB_OK);
     	}
     }else{
       Application->MessageBox("No Scheme Selected to Export. Please Select a Scheme and Retry" , "Oops", MB_OK);
     }
	SetCurrentDir(ExtractFilePath(Application->ExeName));
}
//---------------------------------------------------------------------------

void __fastcall TOptionsfrm::ImportClick(TObject *Sender)
{
	AnsiString newFileName;
	AnsiString exName, newPath;
	AnsiString subdir = ExtractFilePath(Application->ExeName) + COLOR_DIR;
	if(OpenSchDlg->Execute()){
	   exName = OpenSchDlg->FileName.c_str();
	   newFileName = ExtractFileName(exName);
	   newPath = subdir + newFileName;
	   if(!CopyFileA(exName.c_str(), newPath.c_str(),1))
		  MessageBox(this, "Import Failed." , "Oops", MB_OK);
	}
	SetCurrentDir(ExtractFilePath(Application->ExeName));
	FindSchemeNames();
}
//---------------------------------------------------------------------------

void __fastcall TOptionsfrm::DeleteClick(TObject *Sender)
{
	AnsiString name = cmbSchemeSelect->Text;
	AnsiString fullName = ExtractFilePath(Application->ExeName) + COLOR_DIR + name + COLOR_EXT;
	if(name != ""){
	  DeleteFile(fullName);
	}else{
	  Application->MessageBox("No Scheme Selected to Delete. Please Select a Scheme and Retry" , "Oops", MB_OK);
	}
	SetCurrentDir(ExtractFilePath(Application->ExeName));
	FindSchemeNames();
}
//---------------------------------------------------------------------------


void TOptionsfrm::GetCurrentScheme()
{
	
	AnsiString tempName;
	SWConfig *schemesconf;
	SectionMap::iterator sit, oit;

	SWConfig *optionsconf = dynamic_cast<TForm1*>(Application->MainForm)->optionsconf;
	for(int count = 0; count < cmbSchemeSelect->Items->Count; count++)
	{
		tempName = ExtractFilePath(Application->ExeName) + COLOR_DIR + cmbSchemeSelect->Items->Strings[count] + COLOR_EXT;
		schemesconf = new SWConfig(tempName.c_str());
		if(	schemesconf->Sections["Appearance"]["CurrentVSColor"] == optionsconf->Sections["Appearance"]["CurrentVSColor"] &&
			schemesconf->Sections["Appearance"]["VSNumberColor"] == optionsconf->Sections["Appearance"]["VSNumberColor"] &&
			schemesconf->Sections["Appearance"]["StrongsColor"] == optionsconf->Sections["Appearance"]["StrongsColor"] &&
			schemesconf->Sections["Appearance"]["MorphColor"] == optionsconf->Sections["Appearance"]["MorphColor"] &&
			schemesconf->Sections["Appearance"]["FieldColor"] == optionsconf->Sections["Appearance"]["FieldColor"] &&
			
			schemesconf->Sections["Appearance"]["TextBackColor"] == optionsconf->Sections["Appearance"]["TextBackColor"] &&
			schemesconf->Sections["Appearance"]["CommentBackColor"] == optionsconf->Sections["Appearance"]["CommentBackColor"] &&
			schemesconf->Sections["Appearance"]["LDBackColor"] == optionsconf->Sections["Appearance"]["LDBackColor"] &&
			schemesconf->Sections["Appearance"]["PopupBackColor"] == optionsconf->Sections["Appearance"]["PopupBackColor"] &&

			schemesconf->Sections["Appearance"]["TextFontName"] == optionsconf->Sections["Appearance"]["TextFontName"] &&
			schemesconf->Sections["Appearance"]["CommentFontName"] == optionsconf->Sections["Appearance"]["CommentFontName"] &&
			schemesconf->Sections["Appearance"]["LDFontName"] == optionsconf->Sections["Appearance"]["LDFontName"] &&
			schemesconf->Sections["Appearance"]["PopupFontName"] == optionsconf->Sections["Appearance"]["PopupFontName"] &&

			schemesconf->Sections["Appearance"]["TextFontSize"] == optionsconf->Sections["Appearance"]["TextFontSize"] &&
			schemesconf->Sections["Appearance"]["CommentFontSize"] == optionsconf->Sections["Appearance"]["CommentFontSize"] &&
			schemesconf->Sections["Appearance"]["LDFontSize"] == optionsconf->Sections["Appearance"]["LDFontSize"] &&
			schemesconf->Sections["Appearance"]["PopupFontSize"] == optionsconf->Sections["Appearance"]["PopupFontSize"] &&

			schemesconf->Sections["Appearance"]["TextFontColor"] == optionsconf->Sections["Appearance"]["TextFontColor"] &&
			schemesconf->Sections["Appearance"]["CommentFontColor"] == optionsconf->Sections["Appearance"]["CommentFontColor"] &&
			schemesconf->Sections["Appearance"]["LDFontColor"] == optionsconf->Sections["Appearance"]["LDFontColor"] &&
			schemesconf->Sections["Appearance"]["PopupFontColor"] == optionsconf->Sections["Appearance"]["PopupFontColor"]){			cmbSchemeSelect->ItemIndex = count;
				count = cmbSchemeSelect->Items->Count; // Basically we are done and can move on :)
		}
	delete schemesconf;
	}
}



void __fastcall TOptionsfrm::btnModFontsClick(TObject *Sender)
{
	TModuleFonts *pDlg = new TModuleFonts(this);
	pDlg->ShowModal();
	delete pDlg;
}
//---------------------------------------------------------------------------



// DONE 1  -cOptions: add hint verselist preview toggle

void __fastcall TOptionsfrm::HintPopupsClick(TObject *Sender)
{
 	// If we turn off HintPopups we have to turn off HintStrongs
    // because HintStrongs will not work if hints are off
	HintStrongs->Enabled = HintPopups->Checked;
	HintWords->Enabled   = HintPopups->Checked;
	HintVLists->Enabled  = HintPopups->Checked;
}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::btnStrongClrClick(TObject *Sender)
{
	ColorDialogStrongs->Execute();
	shpStrongClr->Brush->Color = ColorDialogStrongs->Color;
	UpdatePreview();

}
//---------------------------------------------------------------------------

void __fastcall TOptionsfrm::btnMorphClrClick(TObject *Sender)
{
	ColorDialogMorph->Execute();
	shpMorphClr->Brush->Color = ColorDialogMorph->Color;
	UpdatePreview();
}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::shpFieldClrMouseDown(TObject *Sender,
		TMouseButton Button, TShiftState Shift, int X, int Y)
{
	btnFieldClrClick(Sender);
}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::shpStrongClrMouseDown(TObject *Sender,
		TMouseButton Button, TShiftState Shift, int X, int Y)
{
	btnStrongClrClick(Sender);
}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::shpMorphClrMouseDown(TObject *Sender,
		TMouseButton Button, TShiftState Shift, int X, int Y)
{
	btnMorphClrClick(Sender);
}
//---------------------------------------------------------------------------




void TOptionsfrm::LoadDispSettings(SWConfig* config) {
	SectionMap::iterator sit;
	   string tmpval;

	if((tmpval = config->Sections["Appearance"]["AutoVSColor"]) == "0"){
		AutoVSColor->Checked = false;
	}
	else {
		AutoVSColor->Checked =  true;
	}
	
	if((tmpval = config->Sections["Appearance"]["CurrentVSColor"]) != ""){
		shpCurrVSClr->Brush->Color =  TColor(atoi(tmpval.c_str()));
		ColorDialogVS->Color = shpCurrVSClr->Brush->Color;
	}
	else {
		shpCurrVSClr->Brush->Color =  TColor(clBlue);
		ColorDialogVS->Color = clBlue;
	}
	
	if((tmpval = config->Sections["Appearance"]["StrongsColor"]) != ""){
		shpStrongClr->Brush->Color =  TColor(atoi(tmpval.c_str()));
		ColorDialogStrongs->Color = shpStrongClr->Brush->Color;
	}
	else {
		shpStrongClr->Brush->Color =  TColor(16711935);  // Magenta
		ColorDialogStrongs->Color = shpStrongClr->Brush->Color; 		
	}

	if((tmpval = config->Sections["Appearance"]["MorphColor"]) != ""){
		shpMorphClr->Brush->Color =  TColor(atoi(tmpval.c_str()));
		ColorDialogMorph->Color = shpMorphClr->Brush->Color;
	}
	else {
		shpMorphClr->Brush->Color =  TColor(60534); // Light Green
		ColorDialogMorph->Color = shpMorphClr->Brush->Color; 		
	}
	
	if((tmpval = config->Sections["Appearance"]["VSNumberColor"]) != ""){
		shpNumClr->Brush->Color =  TColor(atoi(tmpval.c_str()));
		ColorDialogVerseNum->Color = shpNumClr->Brush->Color;
	}
	else {
		shpNumClr->Brush->Color =  clBlue;
		ColorDialogVerseNum->Color = shpNumClr->Brush->Color; 		
	}

	if((tmpval = config->Sections["Appearance"]["FieldColor"]) != ""){
		shpFieldClr->Brush->Color =  TColor(atoi(tmpval.c_str()));
		ColorDialogField->Color = shpFieldClr->Brush->Color;
	}
	else {
		shpFieldClr->Brush->Color =  clAqua; 
		ColorDialogField->Color = shpFieldClr->Brush->Color; 		
	}

	if((tmpval = config->Sections["Appearance"]["VSNumberColor"]) != ""){
		shpCurrVSClr->Brush->Color =  TColor(atoi(tmpval.c_str()));
		ColorDialogVerseNum->Color = shpCurrVSClr->Brush->Color;
	}
	else {
		shpCurrVSClr->Brush->Color =  clBlue; 
		ColorDialogVerseNum->Color = shpCurrVSClr->Brush->Color; 		
	}

		//****	Font BackColor		****//
	if((tmpval = config->Sections["Appearance"]["TextBackColor"]) != "")
		FontDialogText->BackColor = TColor(atoi(tmpval.c_str()));
	else FontDialogText->BackColor = clWhite;

	if((tmpval = config->Sections["Appearance"]["CommentBackColor"]) != "")
		FontDialogComment->BackColor = TColor(atoi(tmpval.c_str()));
	else FontDialogComment->BackColor = clWhite;

	if((tmpval = config->Sections["Appearance"]["LDBackColor"]) != "")
		FontDialogLD->BackColor = TColor(atoi(tmpval.c_str()));
	else FontDialogLD->BackColor = clWhite;

	if((tmpval = config->Sections["Appearance"]["PopupBackColor"]) != "")
		FontDialogPopup->BackColor = TColor(atoi(tmpval.c_str()));
	else FontDialogPopup->BackColor = clWhite;

	if((tmpval = config->Sections["Appearance"]["SearchBackColor"]) != "")
		FontDialogSearch->BackColor = TColor(atoi(tmpval.c_str()));
	else FontDialogSearch->BackColor = clWhite;

		//****	Font Face Name 	****//
	if((tmpval = config->Sections["Appearance"]["TextFontName"]) != "")
		FontDialogText->Font->Name =  tmpval.c_str();
	else FontDialogText->Font->Name = "Times New Roman";
	
	if((tmpval = config->Sections["Appearance"]["CommentFontName"]) != "")
		FontDialogComment->Font->Name =  tmpval.c_str();
	else FontDialogComment->Font->Name = "Times New Roman";

	if((tmpval = config->Sections["Appearance"]["LDFontName"]) != "")
		FontDialogLD->Font->Name =  tmpval.c_str();
	else FontDialogLD->Font->Name = "Times New Roman";

	if((tmpval = config->Sections["Appearance"]["PopupFontName"]) != "")
		FontDialogPopup->Font->Name =  tmpval.c_str();
	else FontDialogPopup->Font->Name = "Times New Roman";

	if((tmpval = config->Sections["Appearance"]["SearchFontName"]) != "")
		FontDialogSearch->Font->Name =  tmpval.c_str();
	else FontDialogSearch->Font->Name = "Times New Roman";
			
		//****	Font Size			****//
	if((tmpval = config->Sections["Appearance"]["TextFontSize"]) != "")
		FontDialogText->Font->Size =  atoi(tmpval.c_str());
	else FontDialogText->Font->Size = 10;

	if((tmpval = config->Sections["Appearance"]["CommentFontSize"]) != "")
		FontDialogComment->Font->Size =  atoi(tmpval.c_str());
	else FontDialogComment->Font->Size = 10;

	if((tmpval = config->Sections["Appearance"]["LDFontSize"]) != "")
		FontDialogLD->Font->Size =  atoi(tmpval.c_str());
	else FontDialogLD->Font->Size = 10;

	if((tmpval = config->Sections["Appearance"]["PopupFontSize"]) != "")
		FontDialogPopup->Font->Size =  atoi(tmpval.c_str());
	else FontDialogPopup->Font->Size = 10;

	if((tmpval = config->Sections["Appearance"]["SearchFontSize"]) != "")
		FontDialogSearch->Font->Size =  atoi(tmpval.c_str());
	else FontDialogSearch->Font->Size = 10;
			
		//****	Font ForeColor		****//
	if((tmpval = config->Sections["Appearance"]["TextFontColor"]) != "")
		FontDialogText->Font->Color = TColor(atoi(tmpval.c_str()));
	else FontDialogText->Font->Color = clBlack;

	if((tmpval = config->Sections["Appearance"]["CommentFontColor"]) != "")
		FontDialogComment->Font->Color = TColor(atoi(tmpval.c_str()));
	else FontDialogComment->Font->Color = clBlack;

	if((tmpval = config->Sections["Appearance"]["LDFontColor"]) != "")
		FontDialogLD->Font->Color = TColor(atoi(tmpval.c_str()));
	else FontDialogLD->Font->Color = clBlack;

	if((tmpval = config->Sections["Appearance"]["PopupFontColor"]) != "")
		FontDialogPopup->Font->Color = TColor(atoi(tmpval.c_str()));
	else FontDialogPopup->Font->Color = clBlack;

	if((tmpval = config->Sections["Appearance"]["SearchFontColor"]) != "")
		FontDialogSearch->Font->Color = TColor(atoi(tmpval.c_str()));
	else FontDialogSearch->Font->Color = clBlack;
}


void TOptionsfrm::LoadMiscSettings(SWConfig* config) {
	ModMap::iterator it;
	SectionMap::iterator sit;
	ConfigEntMap::iterator eit;
	ConfigEntMap emap;
	int color;
	string tmpval;

	Optionsfrm->AutoBMPersonal->Checked = true;
	Optionsfrm->AutoLayout->Checked = true;
	if ((sit = config->Sections.find("Bookmarks")) != config->Sections.end()) {
		Optionsfrm->AutoBMPersonal->Checked = ((atoi(sit->second["AutoSavePersonal"].c_str()))?true:false);
		Optionsfrm->AutoBMOther->Checked    = ((atoi(sit->second["AutoSaveOther"].c_str()))?true:false);
	}
	if ((sit = config->Sections.find("Layout")) != config->Sections.end()) {
		Optionsfrm->AutoLayout->Checked = ((atoi(sit->second["AutoSaveLayout"].c_str()))?true:false);

	}

	tmpval = config->Sections["Hints"].getWithDefault("Hints", "true");
	Optionsfrm->HintPopups->Checked = (tmpval != "false");

	tmpval = config->Sections["Hints"].getWithDefault("Strongs", "true");
	Optionsfrm->HintStrongs->Checked = (tmpval != "false");

	tmpval = config->Sections["Hints"].getWithDefault("VLists", "true");
	Optionsfrm->HintVLists->Checked = (tmpval != "false");

	tmpval = config->Sections["Hints"].getWithDefault("Words", "false");
	Optionsfrm->HintWords->Checked = (tmpval == "true");


	Optionsfrm->devsAsDictsCB->Checked = false;
	tmpval = ((eit = config->Sections["General"].find("DevsAsDicts")) != config->Sections["General"].end())? (*eit).second : (string)"false";
	if (!stricmp(tmpval.c_str(), "true"))
		Optionsfrm->devsAsDictsCB->Checked = true;

	Optionsfrm->glosAsDictsCB->Checked = true;
	tmpval = config->Sections["General"].getWithDefault("GlosAsDicts", "true");
	if (!stricmp(tmpval.c_str(), "false"))
		Optionsfrm->glosAsDictsCB->Checked = false;

	Optionsfrm->devSplashCB->Checked = false;
	tmpval = ((eit = config->Sections["General"].find("TipOfTheDay")) != config->Sections["General"].end())? (*eit).second : (string)"";
	if (!stricmp(tmpval.c_str(), "Devotional"))
		Optionsfrm->devSplashCB->Checked = true;

	const char *localeName = LocaleMgr::systemLocaleMgr.getDefaultLocaleName();
	SWLocale *defLocale = LocaleMgr::systemLocaleMgr.getLocale(localeName);
	Optionsfrm->localeCB->ItemIndex = Optionsfrm->localeCB->Items->IndexOf((defLocale)?defLocale->getDescription():"English (US)");

	tmpval = ((eit = config->Sections["ModDefaults"].find("GreekDef")) != config->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = Form1->mainmgr->Modules.find(tmpval)) != Form1->mainmgr->Modules.end()) {
		Optionsfrm->greekDefCB->ItemIndex = Optionsfrm->greekDefCB->Items->IndexOf(it->second->Description());
	}

	tmpval = ((eit = config->Sections["ModDefaults"].find("GreekParse")) != config->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = Form1->mainmgr->Modules.find(tmpval)) != Form1->mainmgr->Modules.end()) {
		Optionsfrm->greekParseCB->ItemIndex = Optionsfrm->greekParseCB->Items->IndexOf(it->second->Description());
	}

	tmpval = ((eit = config->Sections["ModDefaults"].find("HebrewDef")) != config->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = Form1->mainmgr->Modules.find(tmpval)) != Form1->mainmgr->Modules.end()) {
		Optionsfrm->hebrewDefCB->ItemIndex = Optionsfrm->hebrewDefCB->Items->IndexOf(it->second->Description());
	}

	tmpval = ((eit = config->Sections["ModDefaults"].find("HebrewParse")) != config->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = Form1->mainmgr->Modules.find(tmpval)) != Form1->mainmgr->Modules.end()) {
		Optionsfrm->hebrewParseCB->ItemIndex = Optionsfrm->hebrewParseCB->Items->IndexOf(it->second->Description());
	}

	tmpval = ((eit = config->Sections["ModDefaults"].find("DailyDevotion")) != config->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = Form1->mainmgr->Modules.find(tmpval)) != Form1->mainmgr->Modules.end()) {
		Optionsfrm->dailyDefaultCB->ItemIndex = Optionsfrm->dailyDefaultCB->Items->IndexOf(it->second->Description());
	}

	tmpval = ((eit = config->Sections["ModDefaults"].find("GenDict")) != config->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = Form1->mainmgr->Modules.find(tmpval)) != Form1->mainmgr->Modules.end()) {
		Optionsfrm->genDictCB->ItemIndex = Optionsfrm->genDictCB->Items->IndexOf(it->second->Description());
	}

	tmpval = ((eit = config->Sections["ModDefaults"].find("StrongsNumbers")) != config->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = Form1->mainmgr->Modules.find(tmpval)) != Form1->mainmgr->Modules.end()) {
		Optionsfrm->strongsNumsCB->ItemIndex = Optionsfrm->strongsNumsCB->Items->IndexOf(it->second->Description());
	}
}


void TOptionsfrm::extractSettings(SWConfig* config) {
	ModMap::iterator it;
	SectionMap::iterator sit;
	ConfigEntMap::iterator eit;
	ConfigEntMap emap;
	int color;
	string tmpval;

	emap = config->Sections["Appearance"];
	emap["AutoVSColor"]      = IntToStr((Optionsfrm->AutoVSColor->Checked)?1:0).c_str();
	emap["CurrentVSColor"]   = IntToStr(Optionsfrm->ColorDialogVS->Color).c_str();
	emap["StrongsColor"]     = IntToStr(Optionsfrm->ColorDialogStrongs->Color).c_str();
	emap["MorphColor"]       = IntToStr(Optionsfrm->ColorDialogMorph->Color).c_str();
	emap["VSNumberColor"]    = IntToStr(Optionsfrm->ColorDialogVerseNum->Color).c_str();
	emap["FieldColor"]       = IntToStr(Optionsfrm->ColorDialogField->Color).c_str();
	    
	emap["TextBackColor"]    = IntToStr(Optionsfrm->FontDialogText->BackColor).c_str();
	emap["CommentBackColor"] = IntToStr(Optionsfrm->FontDialogComment->BackColor).c_str();
	emap["LDBackColor"]      = IntToStr(Optionsfrm->FontDialogLD->BackColor).c_str();
	emap["PopupBackColor"]   = IntToStr(Optionsfrm->FontDialogPopup->BackColor).c_str();
	emap["SearchBackColor"]   = IntToStr(Optionsfrm->FontDialogSearch->BackColor).c_str();
	    
	emap["TextFontName"]     = (Optionsfrm->FontDialogText->Font->Name).c_str();
	emap["CommentFontName"]  = (Optionsfrm->FontDialogComment->Font->Name).c_str();
	emap["LDFontName"]       = (Optionsfrm->FontDialogLD->Font->Name).c_str();
	emap["PopupFontName"]    = (Optionsfrm->FontDialogPopup->Font->Name).c_str();
	emap["SearchFontName"]    = (Optionsfrm->FontDialogSearch->Font->Name).c_str();

	emap["TextFontSize"]     = IntToStr(Optionsfrm->FontDialogText->Font->Size).c_str();
	emap["CommentFontSize"]  = IntToStr(Optionsfrm->FontDialogComment->Font->Size).c_str();
	emap["LDFontSize"]       = IntToStr(Optionsfrm->FontDialogLD->Font->Size).c_str();
	emap["PopupFontSize"]    = IntToStr(Optionsfrm->FontDialogPopup->Font->Size).c_str();
	emap["SearchFontSize"]    = IntToStr(Optionsfrm->FontDialogSearch->Font->Size).c_str();
	    
	emap["TextFontColor"]    = IntToStr(Optionsfrm->FontDialogText->Font->Color).c_str();
	emap["CommentFontColor"] = IntToStr(Optionsfrm->FontDialogComment->Font->Color).c_str();
	emap["LDFontColor"]      = IntToStr(Optionsfrm->FontDialogLD->Font->Color).c_str();
	emap["PopupFontColor"]   = IntToStr(Optionsfrm->FontDialogPopup->Font->Color).c_str();
	emap["SearchFontColor"]   = IntToStr(Optionsfrm->FontDialogSearch->Font->Color).c_str();
	    
	emap["locale"]           = (const char *)Optionsfrm->localeCB->Items->Objects[Optionsfrm->localeCB->ItemIndex];

	config->Sections["Appearance"] = emap;

	emap = config->Sections["ModDefaults"];

	if (Optionsfrm->greekDefCB->ItemIndex > -1) {
		emap["GreekDef"]       = (const char *)Optionsfrm->greekDefCB->Items->Objects[Optionsfrm->greekDefCB->ItemIndex];
	}
	if (Optionsfrm->greekParseCB->ItemIndex > -1) {
		emap["GreekParse"]     = (const char *)Optionsfrm->greekParseCB->Items->Objects[Optionsfrm->greekParseCB->ItemIndex];
	}
	if (Optionsfrm->hebrewDefCB->ItemIndex > -1) {
		emap["HebrewDef"]      = (const char *)Optionsfrm->hebrewDefCB->Items->Objects[Optionsfrm->hebrewDefCB->ItemIndex];
	}
	if (Optionsfrm->hebrewParseCB->ItemIndex > -1) {
		emap["HebrewParse"]    = (const char *)Optionsfrm->hebrewParseCB->Items->Objects[Optionsfrm->hebrewParseCB->ItemIndex];
	}
	if (Optionsfrm->dailyDefaultCB->ItemIndex > -1) {
		emap["DailyDevotion"]  = (const char *)Optionsfrm->dailyDefaultCB->Items->Objects[Optionsfrm->dailyDefaultCB->ItemIndex];
	}
	if (Optionsfrm->genDictCB->ItemIndex > -1) {
		emap["GenDict"]  = (const char *)Optionsfrm->genDictCB->Items->Objects[Optionsfrm->genDictCB->ItemIndex];
	}
	if (Optionsfrm->strongsNumsCB->ItemIndex > -1) {
		emap["StrongsNumbers"] = (const char *)Optionsfrm->strongsNumsCB->Items->Objects[Optionsfrm->strongsNumsCB->ItemIndex];
	}
	config->Sections["ModDefaults"] = emap;


	emap = config->Sections["Bookmarks"];
	emap["AutoSavePersonal"] = IntToStr((Optionsfrm->AutoBMPersonal->Checked)?1:0).c_str();
	emap["AutoSaveOther"]    = IntToStr((Optionsfrm->AutoBMOther->Checked)?1:0).c_str();
	config->Sections["Bookmarks"] = emap;

	config->Sections["Layout"]["AutoSaveLayout"] = IntToStr((Optionsfrm->AutoLayout->Checked)?1:0).c_str();

	config->Sections["Hints"]["Hints"]   = (Optionsfrm->HintPopups->Checked) ? "true" : "false";
	config->Sections["Hints"]["Strongs"] = (Optionsfrm->HintStrongs->Checked)? "true" : "false";
	config->Sections["Hints"]["VLists"]  = (Optionsfrm->HintVLists->Checked) ? "true" : "false";
	config->Sections["Hints"]["Words"]   = (Optionsfrm->HintWords->Checked)  ? "true" : "false";

	emap = config->Sections["General"];
	emap["TipOfTheDay"] = (Optionsfrm->devSplashCB->Checked)?"Devotional":"";
	emap["DevsAsDicts"] = (Optionsfrm->devsAsDictsCB->Checked)?"true":"false";
	emap["GlosAsDicts"] = (Optionsfrm->glosAsDictsCB->Checked)?"true":"false";

	config->Sections["General"] = emap;
}


void __fastcall TOptionsfrm::shpNumClrMouseDown(TObject *Sender,
	 TMouseButton Button, TShiftState Shift, int X, int Y)
{
	btnNumClrClick(Sender);
}
//---------------------------------------------------------------------------




