//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "biblecsmgr.h"
#include "swdisprtfchap.h"
#include <winbase.h>


//---------------------------------------------------------------------------
static inline SWDispRTFChap *ValidCtrCheck()
{
	return new SWDispRTFChap(NULL);
}

char SWDispRTFChap::platformID = 0;

class SWDispRTFChap_init {
public:
	SWDispRTFChap_init() {
		OSVERSIONINFO osvi;
		memset(&osvi, 0, sizeof(OSVERSIONINFO));
		osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
		GetVersionEx(&osvi);
		SWDispRTFChap::platformID = osvi.dwPlatformId;
	}
} SWDispRTFChap::_init;


//---------------------------------------------------------------------------
__fastcall SWDispRTFChap::SWDispRTFChap(TWinControl *Owner)
	: SWDispRTF(Owner)
{
}

__fastcall SWDispRTFChap::~SWDispRTFChap()
{
}


void __fastcall SWDispRTFChap::Loaded(void)
{
	SWDispRTF::Loaded();
}

// Display for biblical text
char SWDispRTFChap::Display(SWModule &Module) {
	int testmt, book, chap, verse, versepos;
	System::AnsiString newtext, tmptext, tmptext2;
	VerseKey *key = (VerseKey *)(SWKey *)Module;
	testmt = key->Testament();
	chap   = key->Chapter();
	book   = key->Book();
	verse  = key->Verse();
	key->Verse(1);

	module = &Module;
	type = "Default";

	recalcAppearance();


	newtext = RTFHeader;
	newtext = newtext + RTFChapterMarkPre + IntToStr(chap) + RTFChapterMarkPost;
	newtext = newtext + "\\pard\\f0\\nowidctlpar\\cf7 ";
	if (Module.Direction() == DIRECTION_RTL) {
		newtext = newtext + "\\qr ";
	}
	if (Module.Direction() == DIRECTION_RTL && (platformID == VER_PLATFORM_WIN32_NT	 && (!strnicmp(Module.Lang(), "he", 2) || !strnicmp(Module.Lang(), "ar", 2)))) {
	   newtext = newtext + "\\rtlpar ";
	}

	Module.Error(); // clear error;
	string lastEntry = "something the first entry will never be";
	while ((key->Book() == book) && (key->Chapter() == chap) && (Module.Error() == 0)) {
		if (lastEntry == (string)Module.getRawEntry()) {
			Module++;
			continue;
		}
		newtext = newtext + "{";

		tmptext = "";
		lastEntry = Module.getRawEntry();
		for (const char *loop = (const char *)Module; *loop; loop++) {
			if (*loop == '\n') {
				tmptext += "\\par ";
			}
			else tmptext += *loop;
		}
		if (tmptext.Length() > 3) {	// make sure we have an entry
			if (Module.Direction() == DIRECTION_RTL && (platformID == VER_PLATFORM_WIN32_WINDOWS	 || (Module.Lang() && strnicmp(Module.Lang(), "he", 2) && strnicmp(Module.Lang(), "ar", 2)))) {
				newtext = newtext + RTFVersePre;
				if ((key->Verse() == verse) && (dispAttribs.markCurrentVerse)) {
					newtext = newtext + "\\cf2 "; // \cf2 = second color in color table
				}
				newtext += tmptext + RTFVersePost;
				newtext = newtext + RTFVerseMarkPre + IntToStr(key->Verse()) + RTFVerseMarkPost;
				newtext = newtext + "\\par ";
			}
			else {
				newtext = newtext + RTFVerseMarkPre + IntToStr(key->Verse()) + RTFVerseMarkPost;
				newtext = newtext + RTFVersePre;
				if ((key->Verse() == verse) && (dispAttribs.markCurrentVerse)) {
					newtext = newtext + "\\cf2 "; // \cf2 = second color in color table
				}
				newtext += tmptext + RTFVersePost;
			}
		}
		if (key->Verse() == verse) {
			tmptext = newtext + RTFTrailer + "}";
			RTFStream->Clear();
			RTFStream->WriteBuffer(tmptext.c_str(), tmptext.Length());
			RTFStream->Position = 0;
			Lines->LoadFromStream(RTFStream);
			versepos =  GetTextLen() - 3;
		}
		newtext = newtext + "}";
		Module++;
	}
	newtext = newtext + RTFTrailer;
	key->Verse(1); //{ When setting chapter: if (verse <> new chapter range) don't autonormalize. (we could've just turned the autonormalize option off then back on, but this is cooler) }
	key->Chapter(1);
	key->Book(1);
	key->Testament(testmt);
	key->Book(book);
	key->Chapter(chap);
	key->Verse(verse);
	RTFStream->Clear();
	RTFStream->WriteBuffer(newtext.c_str(), newtext.Length());
	RTFStream->Position = 0;
	Lines->LoadFromStream(RTFStream);

	//{ Position control text at current verse }
	this->SetFocus();
	SelStart = versepos;
	SendMessage(Handle, EM_SCROLLCARET, 0, 0);
	return 0;
}


//---------------------------------------------------------------------------
namespace Swdisprtfchap
{
	void __fastcall Register()
	{
		TComponentClass classes[1] = {__classid(SWDispRTFChap)};
		RegisterComponents("SWORD", classes, 0);
	}
}
//---------------------------------------------------------------------------
