//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

extern "C" {
#include <untgz.h>
}

#include "MainFrm.h"
#include "StatusFrm.h"
#include "RemoteMntFrm.h"
#include "InfoFrm.h"
#include "cipherfrm.h"
#include "UninstallFrm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

#include <swwinlog.h>
#include <shellapi.h>
#include <dirent.h>
#include <fcntl.h>
#include <io.h>
#include <sys/stat.h>
#include <dir.h>
#include <FileCtrl.hpp>

TMainForm *MainForm;

	
VersionInfo::VersionInfo(const char *version) {
	char *buf = new char[ strlen(version) + 1 ];
	char *tok;
	major = minor = minor2 = minor3 = 0;
		
	strcpy(buf, version);
	tok = strtok(buf, ".");
	if (tok)
		major = atoi(tok);
	tok = strtok(0, ".");
	if (tok)
		minor = atoi(tok);
	tok = strtok(0, ".");
	if (tok)
		minor2 = atoi(tok);
	tok = strtok(0, ".");
	if (tok)
		minor3 = atoi(tok);
	delete [] buf;
}


int VersionInfo::compare(const VersionInfo &vi) const {
	if (major == vi.major)
		if (minor == vi.minor)
			if (minor2 == vi.minor2)
				if (minor3 == vi.minor3)
					return 0;
				else return minor3 - vi.minor3;
			else	return minor2 - vi.minor2;
		else	return minor - vi.minor;
	else	return major - vi.major;
}


__fastcall InstallSourceTab::InstallSourceTab(TComponent *Owner, const char *confEnt, const char *type) : TControl(Owner) {
	char *buf = new char [ strlen(confEnt) + 1 ];
	
	strcpy(buf, confEnt);

	Caption = strtok(buf, "|");
	Source = strtok(0, "|");
	Directory = strtok(0, "|");
	delete [] buf;
	Type = type;
	mgr = 0;
}

__fastcall InstallSourceTab::~InstallSourceTab() {
	if (mgr)
		delete mgr;
}
	
__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
     try {
	    manager = new SWMgr();
     }
     catch (...) {
           createPathAndFile("./mods.d/globals.conf");           
           manager = new SWMgr();
     }
	installConf = new SWConfig("./InstallMgr.conf");
	localMgr = 0;
}


__fastcall TMainForm::~TMainForm()
{
	delete manager;
	delete installConf;
	if (localMgr)
		delete localMgr;
}


void __fastcall TMainForm::FormCreate(TObject *Sender) {

	refreshPageControl();
	
	if (SWLog::systemlog)
		delete SWLog::systemlog;
	SWLog::systemlog = new SWWinLog(this->Handle);		// set the system logger to our MSWindows specific SWLog class

	fillInstallTree();
	fillSourceTree(getLocalDir(), localTree);
}


void TMainForm::refreshPageControl() {
	SectionMap::iterator sources;
	ConfigEntMap::iterator sourceBegin;
	ConfigEntMap::iterator sourceEnd;

	while (PageControl1->PageCount > 1) {
		delete PageControl1->Pages[1];
	}
	
	sources = installConf->Sections.find("Sources");
	passive = (!stricmp((*installConf)["General"]["PassiveFTP"].c_str(), "true"));

	if (sources != installConf->Sections.end()) {
		sourceBegin = sources->second.lower_bound("FTPSource");
		sourceEnd = sources->second.upper_bound("FTPSource");

		if (sourceBegin != sourceEnd) {
			while (sourceBegin != sourceEnd) {
				InstallSourceTab *ist = new InstallSourceTab(this, sourceBegin->second.c_str(), "FTP");
				addSource(ist);
				sourceBegin++;
			}
		}
	}
}


void TMainForm::addSource(InstallSourceTab *ist)
{
	TTabSheet *newtab = new TTabSheet(this);
	TTreeView *newtree = new TTreeView(this);
	TSpeedButton *newbutton = new TSpeedButton(this);
	TPanel *newpanel = new TPanel(this);
	char buf[512];
	SectionMap::iterator sit;
	
	newtab->Caption = ist->Caption.c_str();
	newtab->Hint = ist->Source.c_str();
	newtab->ShowHint = true;
	newtab->PageControl = PageControl1;
	ist->Parent = newtab;
	ist->tree = newtree;
	newpanel->Parent = newtab;
	newpanel->Align = alTop;
	newpanel->BevelOuter = bvNone;
	newpanel->BevelInner = bvNone;
	newpanel->Height = 25;
	newbutton->Parent = newpanel;
	newbutton->Caption = "Refresh from Remote Source";
	newbutton->Width = 210;
	newbutton->OnClick = RefreshRemoteSource;
	newbutton->Flat = true;
	newbutton->Glyph = SpeedButton2->Glyph;
	newtree->Parent = newtab;
	newtree->Align = alClient;
	newtree->ReadOnly = true;
	newtree->OnDblClick = localTreeDblClick;
	newtree->Images = ImageList1;
	newtree->StateImages = ImageList2;
	string parent = "./sources/" + ist->Source + "/file";
	createParent(parent.c_str());
	parent = "./sources/" + ist->Source;
	fillSourceTree(parent.c_str(), newtree);
}


const char *TMainForm::getLocalDir()
{
	ConfigEntMap::iterator entry;

	entry = installConf->Sections["Sources"].find("LocalPath");
	if (entry == installConf->Sections["Sources"].end()) {
		installConf->Sections["Sources"].insert(ConfigEntMap::value_type("LocalPath", "d:/sword"));
		entry = installConf->Sections["Sources"].find("LocalPath");
	}
	return entry->second.c_str();
		
}


void TMainForm::setLocalDir(const char *idir)
{
	installConf->Sections["Sources"].erase("LocalPath"); installConf->Sections["Sources"].insert(ConfigEntMap::value_type("LocalPath", idir));
}


//---------------------------------------------------------------------------
void __fastcall TMainForm::LocalPath1Click(TObject *Sender)
{
     AnsiString Dir = "C:";
     WideString Root = getLocalDir();
     SelectDirectory("Select Local Path", Root , Dir);

/*
	localPathDlg->Title = "Select a file in the directory to choose";
	localPathDlg->InitialDir = getLocalDir();
	if (localPathDlg->Execute()) {
		char *buf = new char [ strlen(localPathDlg->FileName.c_str()) + 1 ];

		strcpy(buf, localPathDlg->FileName.c_str());
		int end = strlen(buf) - 1;
		while (end) {
			if ((buf[end] == '/') || (buf[end] == '\\'))
				break;
			end--;
		}
		buf[end+1] = 0;
		setLocalDir(buf);
		delete [] buf;
	}
*/

        setLocalDir(Dir.c_str());

	installConf->Save();
	fillSourceTree(getLocalDir(), localTree);
}
//---------------------------------------------------------------------------

void TMainForm::fillInstallTree()
{
	ModMap::iterator mods;
	TTreeNode *node;
	string nodeName;
	
	installTree->Items->Clear();

	if (!manager->configPath)
		return;

	for (mods = manager->Modules.begin(); mods != manager->Modules.end(); mods++) {
		for (node = installTree->Items->GetFirstNode(); node; node = node->getNextSibling()) {
			if (!strcmp(node->Text.c_str(), mods->second->Type())) {
				break;
			}
		}
		if (!node) {	// Add Section
			if (!strncmp(mods->second->Type(), "Bibl", 4))	// If Bibles, put first in list
				node = installTree->Items->AddChildFirst(0, mods->second->Type());
			else	node = installTree->Items->AddChild(0, mods->second->Type());
		}
		nodeName = "[";
		nodeName += mods->second->Name();
		nodeName += "] ";
		nodeName += mods->second->Description();
		node = installTree->Items->AddChildObject(node, nodeName.c_str(), mods->second->Name());
	}
	for (node = installTree->Items->GetFirstNode(); node; node = node->getNextSibling())
		node->Expand(true);
	node = installTree->Items->GetFirstNode();
	if (node)
		node->MakeVisible();
}


void TMainForm::fillSourceTree(const char *sourceConf, TTreeView *tree)
{
	ModMap::iterator mods;
	TTreeNode *node;
	SectionMap::iterator sections, targetSection;
	ConfigEntMap::iterator entry;
	string secName;
	const char * modDesc;
	string nodeName;
	string targetVersion;
	string sourceVersion;
	bool cipher;
	bool showLocked = LockedModules1->Checked;
	
	SWMgr *mgr;

	if (tree == localTree) {
		if (localMgr)
			delete localMgr;
		mgr = localMgr = new SWMgr(sourceConf);
	}
	else {
     	
		InstallSourceTab *ist = (InstallSourceTab *) tree->Parent->Controls[0];
		if (ist->mgr)
			delete ist->mgr;
		mgr = ist->mgr = new SWMgr(sourceConf);
	}
	
	tree->Items->Clear();

	if (!mgr->configPath)
		return;

	for (sections = mgr->config->Sections.begin(); sections != mgr->config->Sections.end(); sections++) {
	
		cipher = false;
		
		if (!strcmp(sections->first.c_str(), "Globals"))	// skip [Globals]
			continue;
			
		entry = sections->second.find("CipherKey");
		if (entry != sections->second.end()) {
			if (showLocked)
				cipher = true;
			else continue;
		}
		
		mods = mgr->Modules.find(sections->first.c_str());
		if (mods != mgr->Modules.end())
			secName = mods->second->Type();
		else {
			secName = "Other";
		}

		string misc1 = ((entry = sections->second.find("Category")) != sections->second.end()) ? (*entry).second : (string)"";
          if (misc1.length() > 0)
             secName = misc1;

		entry = sections->second.find("Description");
		if (entry != sections->second.end())
			modDesc = entry->second.c_str();
		else modDesc = "";
		
		
		targetVersion = "0.0";
		sourceVersion = "1.0";
		
		entry = sections->second.find("Version");
		if (entry != sections->second.end())
			sourceVersion = entry->second.c_str();

		targetSection = manager->config->Sections.find(sections->first);
		if (targetSection != manager->config->Sections.end()) {
			targetVersion = "1.0";
			entry = targetSection->second.find("Version");
			if (entry != targetSection->second.end())
				targetVersion = entry->second;
		}

		if (VersionInfo(sourceVersion.c_str()) > VersionInfo(targetVersion.c_str())) {
			for (node = tree->Items->GetFirstNode(); node; node = node->getNextSibling()) {
				if (!strcmp(node->Text.c_str(), secName.c_str())) {
					break;
				}
			}

			if (!node) {	// Add Section
				if (!strncmp(secName.c_str(), "Bibl", 4))	// If Bibles, put first in list
					node = tree->Items->AddChildFirst(0, secName.c_str());
				else	node = tree->Items->AddChild(0, secName.c_str());
				node->ImageIndex = 0;
			}
			nodeName = "[" + sections->first + "] " + modDesc;
			node = tree->Items->AddChildObject(node, nodeName.c_str(), (void *) sections->first.c_str());
			if (VersionInfo(targetVersion.c_str()) < VersionInfo("1.0")) {
				node->ImageIndex = 1;
				node->SelectedIndex = 1;
			}
			else {
				node->ImageIndex = 2;
				node->SelectedIndex = 2;
			}
			if (cipher) {
				node->ImageIndex += 2;
				node->SelectedIndex += 2;
			}
			node->StateIndex = 0;
		}
	}
	for (node = tree->Items->GetFirstNode(); node; node = node->getNextSibling())
		node->Expand(true);
	node = tree->Items->GetFirstNode();
	if (node)
		node->MakeVisible();
}


void __fastcall TMainForm::Button5Click(TObject *Sender)
{
	TTreeView *tree;
	for (int i = 0; i < PageControl1->ActivePage->ControlCount; i++) {
		if (PageControl1->ActivePage->Controls[i]->ClassNameIs("TTreeView")) {
			tree = (TTreeView*)(PageControl1->ActivePage->Controls[i]);
			break;
		}
	}
	TTreeNode *node = tree->Selected;
	if (node) {
		if (node->Parent) {
			if (node->StateIndex == 1)
				node->StateIndex = 0; //node->StateIndex;
			else	node->StateIndex = 1;
			tree->Repaint();
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::localTreeDblClick(TObject *Sender)
{
	Button5Click(Sender);
}
//---------------------------------------------------------------------------

int TMainForm::selectAll(TTreeView *tree, bool sel)
{
	TTreeNode *node;
	TTreeNode *node2;
	int retCount = 0;
	
	for (node = tree->Items->GetFirstNode(); node; node = node->getNextSibling()) {
		for (node2 = node->getFirstChild(); node2; node2 = node2->getNextSibling()) {
			if (node2->StateIndex == 1) {
				if (!sel) {
					node2->StateIndex = 0; //node2->StateIndex;
					retCount++;
				}
			}
			else	{
				if (sel) {
					node2->StateIndex = 1;
					retCount++;
				}
			}
		}
	}
	return retCount;
}


void __fastcall TMainForm::Button6Click(TObject *Sender)	// SELECT ALL
{
	TTreeView *tree;
	for (int i = 0; i < PageControl1->ActivePage->ControlCount; i++) {
		if (PageControl1->ActivePage->Controls[i]->ClassNameIs("TTreeView")) {
			tree = (TTreeView*)(PageControl1->ActivePage->Controls[i]);
			break;
		}
	}
	if (!selectAll(tree, true))
		selectAll(tree, false);
	tree->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Image1Click(TObject *Sender)
{
	ShellExecute(this->Handle, "open", "http://www.crosswire.org", NULL, NULL, SW_SHOWNORMAL);

}
//---------------------------------------------------------------------------

int TMainForm::removeModule(const char *modName)
{
	SectionMap::iterator module;
	ConfigEntMap::iterator fileBegin;
	ConfigEntMap::iterator fileEnd, entry;

	module = manager->config->Sections.find(modName);

	if (module != manager->config->Sections.end()) {
		entry = module->second.find("CipherKey");
		if (entry != module->second.end())
			CipherForm->cipherEdit->Text = entry->second.c_str();
			
		fileBegin = module->second.lower_bound("File");
		fileEnd = module->second.upper_bound("File");

		if (fileBegin != fileEnd) {	// remove each file
			while (fileBegin != fileEnd) {
				//remove file
				remove(fileBegin->second.c_str());
				fileBegin++;
			}
		}
		else {	//remove all files in DataPath directory

			DIR *dir;
			struct dirent *ent;
			ConfigEntMap::iterator entry;
			string modDir;
			string modFile;

			entry = module->second.find("DataPath");
			if (entry != module->second.end()) {
				modDir = entry->second.c_str();
				entry = module->second.find("ModDrv");
				if (entry != module->second.end()) {
					if (!strcmp(entry->second.c_str(), "RawLD") || !strcmp(entry->second.c_str(), "RawLD4") || !strcmp(entry->second.c_str(), "zLD") || !strcmp(entry->second.c_str(), "RawGenBook") || !strcmp(entry->second.c_str(), "zGenBook")) {
						char *buf = new char [ strlen(modDir.c_str()) + 1 ];
	
						strcpy(buf, modDir.c_str());
						int end = strlen(buf) - 1;
						while (end) {
							if (buf[end] == '/')
								break;
							end--;
						}
						buf[end] = 0;
						modDir = buf;
						delete [] buf;
					}
				}

				if (dir = opendir(modDir.c_str())) {
					rewinddir(dir);
					while ((ent = readdir(dir))) {
						if ((strcmp(ent->d_name, ".")) && (strcmp(ent->d_name, ".."))) {
							modFile = modDir;
							modFile += "/";
							modFile += ent->d_name;
							remove(modFile.c_str());
						}
					}
					closedir(dir);
				}
				if (dir = opendir(manager->configPath)) {	// find and remove .conf file
					rewinddir(dir);
					while ((ent = readdir(dir))) {
						if ((strcmp(ent->d_name, ".")) && (strcmp(ent->d_name, ".."))) {
							modFile = manager->configPath;
							modFile += "/";
							modFile += ent->d_name;
							SWConfig *config = new SWConfig(modFile.c_str());
							if (config->Sections.find(modName) != config->Sections.end()) {
								delete config;
								remove(modFile.c_str());
							}
							else	delete config;
						}
					}
					closedir(dir);
				}
			}
		}
		return 0;
	}
	return 1;
}


int TMainForm::createParent(const char *pName)
{
	char *buf = new char [ strlen(pName) + 1 ];
	int retCode = 0;
	
	strcpy(buf, pName);
	int end = strlen(buf) - 1;
	while (end) {
		if (buf[end] == '/')
			break;
		end--;
	}
	buf[end] = 0;
	if (strlen(buf)>0) {
          if (access(buf, 02)) {  // not exists with write access?
          	if ((retCode = mkdir(buf))) {
		         	createParent(buf);
                    retCode = mkdir(buf);
               }
		}
     }
     else retCode = -1;
	delete [] buf;
	return retCode;
}
	

int TMainForm::createPathAndFile(const char *fName)
{
	int fd;
	
	fd = open(fName, O_CREAT|O_WRONLY|O_BINARY, S_IREAD|S_IWRITE);
	if (fd < 1) {
		createParent(fName);
		fd = open(fName, O_CREAT|O_WRONLY|O_BINARY, S_IREAD|S_IWRITE);
	}
	return fd;
}


int TMainForm::copyFileToCWD(const char *sourceDir, const char *fName)
{
	string sourcePath = sourceDir;
	sourcePath += fName;

     string dest;
     dest = manager->prefixPath;
     if ((manager->prefixPath[strlen(manager->prefixPath)-1] != '\\') && ( manager->prefixPath[strlen(manager->prefixPath)-1] != '/'))
        dest += "/";
       dest += fName;

	return copyFile(sourcePath.c_str(), dest.c_str());
}


int TMainForm::copyFile(const char *sourceFile, const char *targetFile)
{
	int sfd, dfd, len;
	char buf[4096];

	if ((sfd = open(sourceFile, O_RDONLY|O_BINARY)) < 1)
		return -1;
	if ((dfd = createPathAndFile(targetFile)) < 1)
		return -1;

	do {
		len = read(sfd, buf, 4096);
		write(dfd, buf, len);
	}
	while(len == 4096);	
	close(dfd);
	close(sfd);
	
	return 0;
}


int TMainForm::installModule(const char *modName, InstallSourceTab *ist)
{
	SectionMap::iterator module, section;
	ConfigEntMap::iterator fileBegin;
	ConfigEntMap::iterator fileEnd;
	ConfigEntMap::iterator entry;
	string sourceDir;
	string buffer;
	bool aborted = false;
	bool cipher = false;

	if (ist)
		sourceDir = "./sources/" + ist->Source;
	else	sourceDir = getLocalDir();
	
	SWMgr mgr(sourceDir.c_str());
	
	module = mgr.config->Sections.find(modName);

	if (module != mgr.config->Sections.end()) {
	
		entry = module->second.find("CipherKey");
		if (entry != module->second.end())
			cipher = true;
		
		fileEnd = module->second.upper_bound("File");
		fileBegin = module->second.lower_bound("File");

		if (fileBegin != fileEnd) {	// copy each file
			if (ist) {
				while (fileBegin != fileEnd) {	// ftp each file first
					buffer = sourceDir + "/" + fileBegin->second;
					if (FTPCopy(ist, fileBegin->second.c_str(), buffer.c_str())) {
						aborted = true;
						break;	// user aborted
					}
					fileBegin++;
				}
				fileBegin = module->second.lower_bound("File");
			}

			if (!aborted) {
				// DO THE INSTALL
				while (fileBegin != fileEnd) {
					copyFileToCWD(sourceDir.c_str(), fileBegin->second.c_str());
					fileBegin++;
				}
			}
			//---------------

			if (ist) {
				fileBegin = module->second.lower_bound("File");
				while (fileBegin != fileEnd) {	// delete each tmp ftp file
					buffer = sourceDir + "/" + fileBegin->second;
					remove(buffer.c_str());
					fileBegin++;
				}
			}
		}
		else {	//copy all files in DataPath directory
			DIR *dir;
			struct dirent *ent;
			ConfigEntMap::iterator entry;
			string modDir;
			string modFile;
			string sourceOrig = sourceDir;

			entry = module->second.find("DataPath");
			if (entry != module->second.end()) {
				modDir = entry->second.c_str();
				entry = module->second.find("ModDrv");
				if (entry != module->second.end()) {
					if (!strcmp(entry->second.c_str(), "RawLD") || !strcmp(entry->second.c_str(), "RawLD4") || !strcmp(entry->second.c_str(), "zLD") || !strcmp(entry->second.c_str(), "RawGenBook") || !strcmp(entry->second.c_str(), "zGenBook")) {
						char *buf = new char [ strlen(modDir.c_str()) + 1 ];
	
						strcpy(buf, modDir.c_str());
						int end = strlen(buf) - 1;
						while (end) {
							if (buf[end] == '/')
								break;
							end--;
						}
						buf[end] = 0;
						modDir = buf;
						delete [] buf;
					}
				}

				if (ist) {
					buffer = sourceDir + "/" + modDir;
					if (FTPCopy(ist, modDir.c_str(), buffer.c_str(), true)) {
						aborted = true;	// user aborted
					}
				}
				sourceDir += "/";
				sourceDir += modDir;
				if (!aborted) {
					if (dir = opendir(sourceDir.c_str())) {
						rewinddir(dir);
						while ((ent = readdir(dir))) {
							if ((strcmp(ent->d_name, ".")) && (strcmp(ent->d_name, ".."))) {
								modFile = modDir;
								modFile += "/";
								modFile += ent->d_name;
								copyFileToCWD(sourceOrig.c_str(), modFile.c_str());
							}
						}
						closedir(dir);
					}
				}
				if (ist) {		// delete tmp ftp files
					if (dir = opendir(sourceDir.c_str())) {
						rewinddir(dir);
						while ((ent = readdir(dir))) {
							if ((strcmp(ent->d_name, ".")) && (strcmp(ent->d_name, ".."))) {
								modFile = sourceOrig + "/" + modDir;
								modFile += "/";
								modFile += ent->d_name;
								remove(modFile.c_str());
							}
						}
						closedir(dir);
					}
				}
				sourceDir = sourceOrig;
				sourceDir += "/mods.d/";
				if (!aborted) {
					if (dir = opendir(sourceDir.c_str())) {	// find and copy .conf file
						rewinddir(dir);
						while ((ent = readdir(dir))) {
							if ((strcmp(ent->d_name, ".")) && (strcmp(ent->d_name, ".."))) {
								modFile = sourceDir;
								modFile += ent->d_name;
								SWConfig *config = new SWConfig(modFile.c_str());
								if (config->Sections.find(modName) != config->Sections.end()) {
									delete config;
									string targetFile = manager->configPath; //"./mods.d/";
                                             targetFile += "/";
									targetFile += ent->d_name;
									copyFile(modFile.c_str(), targetFile.c_str());
									if (cipher) {
										CipherForm->modName = modName;
										CipherForm->confFile = targetFile;
										if (CipherForm->ShowModal() == mrCancel) {
											removeModule(modName);
											aborted = true;
										}
									}
								}
								else	delete config;
							}
						}
						closedir(dir);
					}
				}
			}
		}
		return (aborted) ? -1 : 0;
	}
	return 1;
}


void	TMainForm::fillAllSourceTrees()
{
	fillSourceTree(getLocalDir(), localTree);
	for (int i = 1; i < PageControl1->PageCount; i++) {
		InstallSourceTab *ist = (InstallSourceTab *) MainForm->PageControl1->Pages[i]->Controls[0];
		string parent = "./sources/" + ist->Source;
		fillSourceTree(parent.c_str(), ist->tree);
	}
}


void __fastcall TMainForm::Button4Click(TObject *Sender)	// REMOVE MODULE
{
	TTreeNode *node = installTree->Selected;
	if (node) {
		if (node->Parent) {
			removeModule((const char *)node->Data);
			delete manager;
			manager = new SWMgr();
			fillInstallTree();
			fillAllSourceTrees();
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Button2Click(TObject *Sender)	// INSTALL
{
	TTreeNode *node;
	int count = 0;
	int abort = 0;

	class TWaitCursor {
	public:
	    TWaitCursor() : oldc(Screen->Cursor) { Screen->Cursor = crHourGlass; }
	    ~TWaitCursor()                       { Screen->Cursor = oldc; }
	private:
	    TCursor oldc;
	} wait; // show hourglass

	TTreeView *tree;
	for (int i = 0; i < PageControl1->ActivePage->ControlCount; i++) {
		if (PageControl1->ActivePage->Controls[i]->ClassNameIs("TTreeView")) {
			tree = (TTreeView*)(PageControl1->ActivePage->Controls[i]);
			break;
		}
	}

	for (node = tree->Items->GetFirstNode(); node; node = node->GetNext()) {
		if (node->StateIndex == 1)
			count++;
	}	// do true progress bar

	if (!count) {
		MessageBox(this->WindowHandle, "Please first choose which modules you would like to install by double-clicking a module in the 'Available' tree.", "Please select modules first.", MB_OK);
		return;		// if nothing is selected, do nothing
	}
		
	progressBar->Max = count;
	progressBar->Position = 0;

	for (node = tree->Items->GetFirstNode(); node; node = node->GetNext()) {
		if (node->StateIndex == 1) {	// if selected for install
			CipherForm->cipherEdit->Text = "";
			if ((node->ImageIndex == 2) || (node->ImageIndex == 4)) {	// if this is an upgrade
				removeModule((const char *)node->Data);
			}
				// install module
			statusBar->Caption = "Installing: " + node->Text + "...";
			statusBar->Repaint();
			if (tree == localTree)
				abort = installModule((const char *)node->Data);
			else	abort = installModule((const char *)node->Data, (InstallSourceTab *) PageControl1->ActivePage->Controls[0]);
			if (abort)
				break;
			progressBar->Position++;
		}
	}
	delete manager;
	manager = new SWMgr();
	fillInstallTree();
	fillAllSourceTrees();
	statusBar->Caption = "";
	progressBar->Position = 0;
}


int TMainForm::FTPCopy(InstallSourceTab *ist, const char *src, const char *dest, bool dirTransfer, const char *suffix)
{
	StatusForm->ist = ist;
	StatusForm->src = src;
	StatusForm->dest = dest;
        StatusForm->suffix = suffix;
	StatusForm->dirTransfer = dirTransfer;
        StatusForm->passive = passive;
	Application->ProcessMessages();
	if (StatusForm->ShowModal() == mrCancel)
		return -1;
	else	return 0;
}


void __fastcall TMainForm::RefreshRemoteSource(TObject *Sender)
{
	InstallSourceTab *ist = (InstallSourceTab *) MainForm->PageControl1->ActivePage->Controls[0];
	DIR *dir;
	struct dirent *ent;
	ConfigEntMap::iterator entry;
	string modDir;
	string modFile;
	string root = "./sources/";
	root += ist->Source.c_str();
	string target = root + "/mods.d";

	if (dir = opendir(target.c_str())) {
		rewinddir(dir);
		while ((ent = readdir(dir))) {
			if ((strcmp(ent->d_name, ".")) && (strcmp(ent->d_name, ".."))) {
				modFile = target;
				modFile += "/";
				modFile += ent->d_name;
				remove(modFile.c_str());
			}
		}
		closedir(dir);
	}


    	string archive = root + "/mods.d.tar.gz";
	if (!FTPCopy(ist, "mods.d.tar.gz", archive.c_str(), false)) {
     	int fd = open(archive.c_str(), O_RDONLY|O_BINARY);
     	untargz(fd, root.c_str());
          close(fd);
     }
     else	FTPCopy(ist, "mods.d", target.c_str(), true, ".conf");

	target = "./sources/";
	target += ist->Source.c_str();

	fillSourceTree(target.c_str(), ist->tree);	
}



void __fastcall TMainForm::SpeedButton1Click(TObject *Sender)
{
	InfoForm->Caption = "W A R N I N G";
	InfoForm->info = "\\qc {\\b \\fs20 -=+* WARNING *+=- -=+* WARNING *+=-}\\par\\par\\pard ";
	InfoForm->info += "Although Install Manager provides a convenient way for installing and upgrading SWORD components, it also uses a systematic method for accessing sites which gives packet sniffers a target to lock into for singling out users. \\par\\par ";
	InfoForm->info += "\\b\\qc IF YOU LIVE IN A PERSECUTED COUNTRY AND DO NOT WISH TO RISK DETECTION, YOU SHOULD *NOT* USE INSTALL MANAGER'S REMOTE SOURCE FEATURES.";
	InfoForm->ShowModal();
	if (RemoteMntForm->ShowModal() == mrOk) {
		delete installConf;
		installConf = new SWConfig("./InstallMgr.conf");
	
		refreshPageControl();
	}
}

void __fastcall TMainForm::SpeedButton5Click(TObject *Sender)
{
	TTreeView *tree;
	InstallSourceTab *ist = 0;
	SectionMap::iterator module;
	ConfigEntMap::iterator entry, entryEnd;
	string sourceDir;

	if (PageControl1->ActivePage != PageControl1->Pages[0]) {
		ist = (InstallSourceTab *) PageControl1->ActivePage->Controls[0];
		tree = ist->tree;
	}
	else	tree = localTree;
		
	TTreeNode *node = tree->Selected;
	if (node) {
		if (node->Parent) {
			if (ist)
				sourceDir = "./sources/" + ist->Source;
			else	sourceDir = getLocalDir();
			SWMgr *mgr = new SWMgr(sourceDir.c_str());
	
			module = mgr->config->Sections.find((const char *)node->Data);

			if (module != mgr->config->Sections.end()) {
				string targetVersion = "0.0";
				string sourceVersion = "1.0";
				SectionMap::iterator targetSection;
					
				entry = module->second.find("Version");
				if (entry != module->second.end())
					sourceVersion = entry->second.c_str();

				targetSection = manager->config->Sections.find(module->first);
				if (targetSection != manager->config->Sections.end()) {
					targetVersion = "1.0";
					entry = targetSection->second.find("Version");
					if (entry != targetSection->second.end())
						targetVersion = entry->second;
				}
				if (VersionInfo(targetVersion.c_str()) < VersionInfo("1.0")) {
					InfoForm->info = "\\pard{\\b * Additional Module Available for Install. } \\par ";
				}
				else {
					InfoForm->info = "\\pard{\\b + Upgraded Module Available for Install.}\\par\\tab Current Version:  \\tab " + targetVersion + " \\par\\tab Upgrade Version:\\tab " + sourceVersion + " \\par ";
					bool changes = false;
					for (entry = module->second.begin(); entry != module->second.end(); entry++) {
						if (!strncmp(entry->first.c_str(), "History_", 8)) {
							if (VersionInfo(&entry->first.c_str()[8]) > VersionInfo(targetVersion.c_str())) {
								if (!changes) {
									changes = true;
									InfoForm->info += "\\par{\\b Changes: }\\par ";
								}
								InfoForm->info += "\\tab ";
								InfoForm->info += entry->second.c_str();
								InfoForm->info += "\\par ";
							}
						}
					}
				}

				entry = module->second.find("About");
				if (entry != module->second.end()) {
					InfoForm->info += "\\par{\\b About: } \\par\\par ";
					InfoForm->info += entry->second.c_str();
				}
				InfoForm->Caption = "Module Information";
				InfoForm->ShowModal();
			}
			delete mgr;
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Exit1Click(TObject *Sender)
{
	Close();	
}
//---------------------------------------------------------------------------


void TMainForm::deleteAllModules() {

	SWMgr *mgr = new SWMgr();
	

	int count = mgr->Modules.size();

	if (!count)
		return;

	UninstallForm->Show();
	UninstallForm->ProgressBar1->Max = count;
	UninstallForm->ProgressBar1->Position = 0;

	ModMap::iterator it;
	for (it = mgr->Modules.begin(); it != mgr->Modules.end(); it++) {
		string label = "Uninstalling: [";
		label += it->second->Name();
		label += "] ";
		label += it->second->Description();
		UninstallForm->Label1->Caption = label.c_str();
		UninstallForm->Label1->Repaint();
		removeModule(it->second->Name());
		UninstallForm->ProgressBar1->Position = UninstallForm->ProgressBar1->Position + 1;
		UninstallForm->ProgressBar1->Repaint();
	}
	delete mgr;
	UninstallForm->Hide();
	return;
}
void __fastcall TMainForm::FormShow(TObject *Sender)
{
	for (int i=0;i<=ParamCount();i++) {
		if (LowerCase(ParamStr(i)) == "-uninstall") {
			deleteAllModules();
			Application->Terminate();
		}
	}
	
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::LockedModules1Click(TObject *Sender) {
	LockedModules1->Checked = !(LockedModules1->Checked);

	if (LockedModules1->Checked) {
		InfoForm->Caption = "About Locked Modules";
		InfoForm->info = "\\qc {\\b \\fs20 About Locked Modules}\\par\\par\\pard ";

		InfoForm->info += "Unfortunately, we are unable to legally provide these modules to the general public at this time. We are making attempts to gain permission from the copyright holders, but until such an agreement is arranged, these modules are only available to our developers and testers.  We hope to be able to provide some of these to you soon. \\par\\par\\pard ";
		InfoForm->info += "If you would like to contribute to the project by contacting a publisher seeking distribution permission for CrossWire, your efforts would be very appreciated-- especially in regard to non-English texts. Please subscribe to our developers' forum per instructions on our website, following the [Mailing Lists] link, and post a message stating how you would like to help. Thank you. \\par\\par\\pard ";
		InfoForm->info += "\t-CrossWire Bible Society. ";
		InfoForm->ShowModal();
	}
	fillAllSourceTrees();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Contents1Click(TObject *Sender)
{
	SWConfig optionsconf("options.conf");
	string helpDir;
	ConfigEntMap::iterator it = optionsconf.Sections["Help"].find("Directory");
	if (it != optionsconf.Sections["Help"].end())
		helpDir = (*it).second;
	else helpDir = ".\\help";

	string helpExe = helpDir + "\\Sword.chm::modulesh.html#instmgr";
	ShellExecute(this->Handle, "open", "hh", helpExe.c_str(), NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------

