//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "StatusFrm.h"
#include "MainFrm.h"
#include <installmgr.h>
#include <vector>

using namespace std;

//---------------------------------------------------------------------------
#pragma package(smart_init)
//#pragma link "IdBaseComponent"
//#pragma link "IdComponent"
//#pragma link "IdFTP"
//#pragma link "IdTCPClient"
//#pragma link "IdTCPConnection"
#pragma resource "*.dfm"
TStatusForm *StatusForm;


void status_callback(double dltotal, double dlnow) {
	int filePercent  = (int)((float)(dlnow + 1) / (float)(dltotal) * 100);
	int totalPercent = (int)((float)(dlnow + StatusForm->completedBytes + 1) / (float)(StatusForm->totalBytes) * 100);
	StatusForm->statusBar->Caption = ::IntToStr((long)dlnow) + " bytes out of " + ::IntToStr((long)dltotal) + " transferred (file: " + IntToStr(filePercent) + "% / total: " + IntToStr(totalPercent) + "%)";
	StatusForm->fileProgress->Position = filePercent;
	StatusForm->totalProgress->Position = totalPercent;
	
	StatusForm->statusBar->Repaint();
}


//---------------------------------------------------------------------------
__fastcall TStatusForm::TStatusForm(TComponent* Owner)
		: TForm(Owner) {
	suffix = "";
	passive = false;
	ftpCon = new TFTPCon();
}


__fastcall TStatusForm::~TStatusForm() {
	delete ftpCon;
}


//---------------------------------------------------------------------------
void __fastcall TStatusForm::FormShow(TObject *Sender)
{
	abort = false;
	ftpThread = new TFTPThread(ist, src.c_str(), dest.c_str(), dirTransfer, passive, true, suffix.c_str());
	ftpThread->OnTerminate = Cleanup;
	ftpThread->Resume();
}
//---------------------------------------------------------------------------
__fastcall TStatusForm::TFTPThread::TFTPThread(InstallSourceTab *iist, const char *isrc, const char *idest, bool idirTransfer, bool CreateSuspended, bool ipassive, const char *isuffix)
	: TThread(CreateSuspended)
{
	ist = iist;
	src = isrc;
	dest = idest;
	suffix = isuffix;
	dirTransfer = idirTransfer;
	Priority = tpNormal;
	passive = ipassive;
	FreeOnTerminate = true;
	Synchronize((TThreadMethod)&CreateFTPObject);
}

__fastcall TStatusForm::TFTPThread::~TFTPThread()
{
}


void __fastcall TStatusForm::TFTPThread::Execute()
{
	void *session = FTPOpenSession();

	Synchronize((TThreadMethod)&PreConnect);
	StatusForm->ftpCon->Host = ist->Source.c_str();
	StatusForm->ftpCon->Username = "ftp";
	StatusForm->ftpCon->Password = "installmgr@user.com";
	StatusForm->ftpCon->Passive = passive;

	
/*
	try {
		StatusForm->ftpCon->Connect(true, -1);
		StatusForm->ftpCon->TransferType = ftBinary;
		StatusForm->ftpCon->ChangeDir(ist->Directory.c_str());
	}
	catch(...) {
		MessageBox(0, "Can't connect.  Please check your configuration.", "Connection Error", MB_OK);
		StatusForm->Button1Click(0);	// abort thread
	}
*/
	string url = "ftp://" + ist->Source + ist->Directory.c_str() + "/"; //dont forget the final slash
	if (FTPURLGetFile(session, "dirlist", url.c_str())) {
		MessageBox(0, "Can't connect.  Please check your configuration.", "Connection Error", MB_OK);
		StatusForm->Button1Click(0);	// abort thread
	}
	if (!Terminated) {
		if (dirTransfer) {
//			StatusForm->ftpCon->ChangeDir(src.c_str());


	string url = "ftp://" + ist->Source + ist->Directory.c_str() + "/" + src + "/"; //dont forget the final slash
	vector<struct ftpparse> dirList = FTPURLGetDir(session, url.c_str(), passive);

	if (!dirList.size()) {
		MessageBox(0, "Can't connect.  Please check your configuration.", "Connection Error", MB_OK);
		StatusForm->Button1Click(0);	// abort thread
	}
					
//			StatusForm->ftpCon->List(dirText, "*", true);
//			TIdFTPListItems *dirList = StatusForm->ftpCon->DirectoryListing;
			StatusForm->totalBytes = 0;
			for (int i = 0; i < dirList.size(); i++)
				StatusForm->totalBytes += dirList[i].size;
			StatusForm->completedBytes = 0;
			for (int i = 0; i < dirList.size(); i++) {
				if (dirList[i].flagtrycwd != 1) {
					buffer = dest + "/" + (dirList[i].name);
//                           files->Strings[i].c_str();
					if (!strcmp(&buffer.c_str()[buffer.length()-suffix.length()], suffix.c_str())) {
						buffer2 = "Downloading (";
						buffer2 += IntToStr(i+1).c_str();
						buffer2 += " of ";
						buffer2 += IntToStr(dirList.size()).c_str();
						buffer2 += "): ";
						buffer2 += (dirList[i].name);
		//				SWLog::systemlog->LogInformation("%s", buffer.c_str());
						TMainForm::createParent(buffer.c_str());	// make sure parent directory exists
						Synchronize((TThreadMethod)&PreDownload1);
						try {
//							StatusForm->ftpCon->Get(dirList->Items[i]->FileName.c_str(), buffer.c_str(), true, false);

							string url = "ftp://" + ist->Source + ist->Directory.c_str() + "/" + src + "/" + dirList[i].name; //dont forget the final slash

							if (FTPURLGetFile(session, buffer.c_str(), url.c_str(), passive, status_callback)) {
								MessageBox(0, "Can't download file.  If you have not done so recently, you might try pressing the Refresh from Remote Source button.", "Download Error", MB_OK);
								StatusForm->Button1Click(0);	// abort thread
							}
							StatusForm->completedBytes += dirList[i].size;
						}
						catch (...) {}
						if (Terminated)
							break;
					}
				}
			}
		}
		else {
			Synchronize((TThreadMethod)&PreDownload2);
			try {
//				StatusForm->ftpCon->Get(src.c_str(), dest.c_str(), true, false);
				string url = "ftp://" + ist->Source + ist->Directory.c_str() + "/" + src.c_str(); //dont forget the final slash
				if (FTPURLGetFile(session, dest.c_str(), url.c_str(), status_callback)) {
					MessageBox(0, "Can't connect.  Please check your configuration.", "Connection Error", MB_OK);
					StatusForm->Button1Click(0);	// abort thread
				}
			}
			catch(...) {StatusForm->abort = true;}
		}
		try {
//			StatusForm->ftpCon->Disconnect();
			FTPCloseSession(session);
		}
		catch(...){}
	}
}


void __fastcall TStatusForm::TFTPThread::FTPLinkPacketRecvd(TObject *Sender)
{
//	Synchronize((TThreadMethod)&UpdateBytes);
}


//void __fastcall TStatusForm::TFTPThread::UpdateBytes(void) {
void __fastcall TStatusForm::UpdateBytes(void) {
}


void __fastcall TStatusForm::TFTPThread::CreateFTPObject(void)
{
//	FTPLink = new TNMFTP(0);
}


void __fastcall TStatusForm::TFTPThread::PreConnect(void)
{
	buffer = "Connecting to server at ";
	buffer += ist->Source.c_str();
	buffer += "...";
	StatusForm->actionBar->Caption = buffer.c_str();
	StatusForm->statusBar->Caption = "";
	StatusForm->Repaint();
}


void __fastcall TStatusForm::TFTPThread::PreDownload1(void)
{
//	SWLog::systemlog->LogInformation("Creating parent dir: %s", buffer.c_str());
//	SWLog::systemlog->LogInformation("Return: %d", ret);
	StatusForm->actionBar->Caption = buffer2.c_str();
	StatusForm->statusBar->Caption = "";
	StatusForm->Repaint();
}


void __fastcall TStatusForm::TFTPThread::PreDownload2(void)
{
	buffer = "Downloading: ";
	buffer += src.c_str();
	StatusForm->actionBar->Caption = buffer.c_str();
	StatusForm->statusBar->Caption = "";
	StatusForm->Repaint();
	MainForm->createParent(dest.c_str());	// make sure parent directory exists
}


void __fastcall TStatusForm::Cleanup(TObject *Sender)
//void __fastcall TStatusForm::TFTPThread::Cleanup()
{
	if (abort)
		StatusForm->ModalResult = mrCancel;
	else	StatusForm->ModalResult = mrOk;
//	StatusForm->Close();
}

void __fastcall TStatusForm::FormClose(TObject *Sender, TCloseAction &Action)
{
	suffix = "";
	MainForm->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TStatusForm::Button1Click(TObject *Sender)
{
	abort = true;
//	ftpCon->Abort();
	ftpThread->Terminate();
}
//---------------------------------------------------------------------------

/*
void __fastcall TStatusForm::ftpConWork(TObject *Sender,
	 TWorkMode AWorkMode, const int AWorkCount)
{
	currentByteCount = AWorkCount;
//	Synchronize((TThreadMethod)&UpdateBytes);
	UpdateBytes();
}
*/
//---------------------------------------------------------------------------

